/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.util.ArrayList;

public class IntermediateResponse
implements Serializable,
LDAPResponse {
    protected static final byte TYPE_INTERMEDIATE_RESPONSE_OID = -128;
    protected static final byte TYPE_INTERMEDIATE_RESPONSE_VALUE = -127;
    private static final Control[] NO_CONTROLS = new Control[0];
    private static final long serialVersionUID = 218434694212935869L;
    private final ASN1OctetString value;
    private final Control[] controls;
    private final int messageID;
    private final String oid;

    public IntermediateResponse(String string, ASN1OctetString aSN1OctetString) {
        this(-1, string, aSN1OctetString, NO_CONTROLS);
    }

    public IntermediateResponse(int n, String string, ASN1OctetString aSN1OctetString) {
        this(n, string, aSN1OctetString, NO_CONTROLS);
    }

    public IntermediateResponse(String string, ASN1OctetString aSN1OctetString, Control[] controlArray) {
        this(-1, string, aSN1OctetString, controlArray);
    }

    public IntermediateResponse(int n, String string, ASN1OctetString aSN1OctetString, Control[] controlArray) {
        this.messageID = n;
        this.oid = string;
        this.value = aSN1OctetString;
        this.controls = controlArray == null ? NO_CONTROLS : controlArray;
    }

    protected IntermediateResponse(IntermediateResponse intermediateResponse) {
        this.messageID = intermediateResponse.messageID;
        this.oid = intermediateResponse.oid;
        this.value = intermediateResponse.value;
        this.controls = intermediateResponse.controls;
    }

    static IntermediateResponse readFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            Control[] controlArray;
            String string = null;
            ASN1OctetString aSN1OctetString = null;
            ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
            block7: while (aSN1StreamReaderSequence2.hasMoreElements()) {
                byte by = (byte)aSN1StreamReader.peek();
                switch (by) {
                    case -128: {
                        string = aSN1StreamReader.readString();
                        continue block7;
                    }
                    case -127: {
                        aSN1OctetString = new ASN1OctetString(by, aSN1StreamReader.readBytes());
                        continue block7;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT.get(StaticUtils.toHex(by)));
            }
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                ArrayList<Control> arrayList = new ArrayList<Control>(1);
                ASN1StreamReaderSequence aSN1StreamReaderSequence3 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence3.hasMoreElements()) {
                    arrayList.add(Control.readFrom(aSN1StreamReader));
                }
                controlArray = new Control[arrayList.size()];
                arrayList.toArray(controlArray);
            } else {
                controlArray = NO_CONTROLS;
            }
            return new IntermediateResponse(n, string, aSN1OctetString, controlArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_INTERMEDIATE_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public int getMessageID() {
        return this.messageID;
    }

    public final String getOID() {
        return this.oid;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final Control[] getControls() {
        return this.controls;
    }

    public final Control getControl(String string) {
        for (Control control : this.controls) {
            if (!control.getOID().equals(string)) continue;
            return control;
        }
        return null;
    }

    public String getIntermediateResponseName() {
        return this.oid;
    }

    public String valueToString() {
        return null;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("IntermediateResponse(");
        boolean bl = false;
        if (this.messageID >= 0) {
            stringBuilder.append("messageID=");
            stringBuilder.append(this.messageID);
            bl = true;
        }
        if (this.oid != null) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("oid='");
            stringBuilder.append(this.oid);
            stringBuilder.append('\'');
            bl = true;
        }
        if (this.controls.length > 0) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("controls={");
            for (int i = 0; i < this.controls.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.controls[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

