/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.util.Debug;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class LDAPConnectionPoolHealthCheckThread
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AbstractConnectionPool pool;
    private final LinkedBlockingQueue<Object> queue;
    private volatile Thread thread;

    LDAPConnectionPoolHealthCheckThread(AbstractConnectionPool abstractConnectionPool) {
        this.setName("Health Check Thread for " + abstractConnectionPool.toString());
        this.setDaemon(true);
        this.pool = abstractConnectionPool;
        this.stopRequested = new AtomicBoolean(false);
        this.queue = new LinkedBlockingQueue(1);
        this.thread = null;
    }

    public void run() {
        this.thread = Thread.currentThread();
        long l = System.currentTimeMillis();
        while (!this.stopRequested.get()) {
            long l2 = System.currentTimeMillis() - l;
            if (l2 >= this.pool.getHealthCheckIntervalMillis()) {
                try {
                    this.pool.doHealthCheck();
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                }
                l = System.currentTimeMillis();
                continue;
            }
            long l3 = Math.min(this.pool.getHealthCheckIntervalMillis() - l2, 30000L);
            try {
                this.queue.poll(l3, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        this.thread = null;
    }

    void stopRunning() {
        this.stopRequested.set(true);
        this.wakeUp();
        Thread thread = this.thread;
        if (thread != null) {
            try {
                thread.join();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
    }

    void wakeUp() {
        this.queue.offer(new Object());
    }
}

