/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.InternalASN1Helper;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.extensions.NoticeOfDisconnectionExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.WakeableSleeper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.sasl.SaslClient;

@InternalUseOnly
final class LDAPConnectionReader
extends Thread {
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 4096;
    private volatile ASN1StreamReader asn1StreamReader;
    private volatile boolean closeRequested;
    private final ConcurrentHashMap<Integer, ResponseAcceptor> acceptorMap;
    private volatile Exception startTLSException;
    private volatile InputStream inputStream;
    private volatile OutputStream startTLSOutputStream;
    private final LDAPConnection connection;
    private volatile Socket socket;
    private volatile SSLSocketFactory sslSocketFactory;
    private volatile Thread thread;
    private final WakeableSleeper startTLSSleeper;

    LDAPConnectionReader(LDAPConnection lDAPConnection, LDAPConnectionInternals lDAPConnectionInternals) throws IOException {
        this.connection = lDAPConnection;
        this.setName(this.constructThreadName(lDAPConnectionInternals));
        this.setDaemon(true);
        this.socket = lDAPConnectionInternals.getSocket();
        this.inputStream = new BufferedInputStream(this.socket.getInputStream(), 4096);
        this.asn1StreamReader = new ASN1StreamReader(this.inputStream, lDAPConnection.getConnectionOptions().getMaxMessageSize());
        this.acceptorMap = new ConcurrentHashMap();
        this.closeRequested = false;
        this.sslSocketFactory = null;
        this.startTLSException = null;
        this.startTLSOutputStream = null;
        this.startTLSSleeper = new WakeableSleeper();
        if (!lDAPConnectionInternals.synchronousMode()) {
            LDAPConnectionOptions lDAPConnectionOptions = lDAPConnection.getConnectionOptions();
            int n = lDAPConnectionOptions.getConnectTimeoutMillis();
            if (n > 0) {
                if (Debug.debugEnabled()) {
                    Debug.debug(Level.INFO, DebugType.CONNECT, "Setting SO_TIMEOUT to connect timeout of " + n + "ms in LDAPConnectionReader constructor");
                }
                this.socket.setSoTimeout(n);
            } else {
                if (Debug.debugEnabled()) {
                    Debug.debug(Level.INFO, DebugType.CONNECT, "Setting SO_TIMEOUT to 0ms in LDAPConnectionReader constructor");
                }
                this.socket.setSoTimeout(0);
            }
        }
    }

    void registerResponseAcceptor(int n, ResponseAcceptor responseAcceptor) throws LDAPException {
        if (this.acceptorMap.putIfAbsent(n, responseAcceptor) != null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_MSGID_IN_USE.get());
        }
    }

    void deregisterResponseAcceptor(int n) {
        this.acceptorMap.remove(n);
    }

    int getActiveOperationCount() {
        return this.acceptorMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        this.thread = Thread.currentThread();
        while (!this.closeRequested) {
            Object object;
            Serializable serializable;
            try {
                Object object2;
                Object object3;
                LDAPResponse lDAPResponse;
                try {
                    lDAPResponse = LDAPMessage.readLDAPResponseFrom(this.asn1StreamReader, true, this.connection.getCachedSchema());
                }
                catch (LDAPException lDAPException) {
                    serializable = lDAPException.getCause();
                    if (serializable != null && serializable instanceof SocketTimeoutException) {
                        object3 = (SocketTimeoutException)serializable;
                        Debug.debugException(Level.FINEST, (Throwable)object3);
                        if (this.sslSocketFactory == null) continue;
                        object2 = this.connection.getConnectionOptions();
                        try {
                            SSLSocket sSLSocket;
                            int n = ((LDAPConnectionOptions)object2).getConnectTimeoutMillis();
                            if (n > 0) {
                                if (Debug.debugEnabled()) {
                                    Debug.debug(Level.INFO, DebugType.CONNECT, "Setting SO_TIMEOUT to connect timeout of " + n + "ms in " + "LDAPConnectionReader.run while performing " + "StartTLS processing.");
                                }
                                this.socket.setSoTimeout(n);
                            } else {
                                if (Debug.debugEnabled()) {
                                    Debug.debug(Level.INFO, DebugType.CONNECT, "Setting SO_TIMEOUT to 0ms in LDAPConnectionReader.run while performing StartTLS processing.");
                                }
                                this.socket.setSoTimeout(0);
                            }
                            SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
                            synchronized (sSLSocketFactory) {
                                sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(this.socket, this.connection.getConnectedAddress(), this.socket.getPort(), true);
                                sSLSocket.startHandshake();
                            }
                            ((LDAPConnectionOptions)object2).getSSLSocketVerifier().verifySSLSocket(this.connection.getConnectedAddress(), this.socket.getPort(), sSLSocket);
                            this.inputStream = new BufferedInputStream(sSLSocket.getInputStream(), 4096);
                            this.asn1StreamReader = new ASN1StreamReader(this.inputStream, ((LDAPConnectionOptions)object2).getMaxMessageSize());
                            this.startTLSOutputStream = sSLSocket.getOutputStream();
                            this.socket = sSLSocket;
                            this.connection.getConnectionInternals(true).setSocket(sSLSocket);
                            this.startTLSSleeper.wakeup();
                        }
                        catch (Exception exception) {
                            Debug.debugException(exception);
                            this.connection.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, StaticUtils.getExceptionMessage(exception), exception);
                            this.startTLSException = exception;
                            this.closeRequested = true;
                            if (this.thread != null) {
                                this.thread.setName(this.thread.getName() + " (closed)");
                                this.thread = null;
                            }
                            this.closeInternal(true, StaticUtils.getExceptionMessage(exception));
                            this.startTLSSleeper.wakeup();
                            return;
                        }
                        this.sslSocketFactory = null;
                        continue;
                    }
                    if (this.closeRequested || this.connection.closeRequested() || this.connection.getDisconnectType() != null) {
                        this.closeRequested = true;
                        Debug.debugException(Level.FINEST, lDAPException);
                    } else {
                        Debug.debugException(lDAPException);
                    }
                    object2 = Level.SEVERE;
                    if (serializable == null) {
                        this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, lDAPException.getMessage(), (Throwable)serializable);
                        object3 = lDAPException.getMessage();
                        object2 = Level.WARNING;
                    } else if (serializable instanceof InterruptedIOException && this.socket.isClosed()) {
                        this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITHOUT_NOTICE, lDAPException.getMessage(), (Throwable)serializable);
                        object3 = LDAPMessages.ERR_READER_CLOSING_DUE_TO_INTERRUPTED_IO.get(this.connection.getHostPort());
                        object2 = Level.WARNING;
                    } else if (serializable instanceof IOException) {
                        this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, lDAPException.getMessage(), (Throwable)serializable);
                        object3 = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage((Throwable)serializable));
                        object2 = Level.WARNING;
                    } else if (serializable instanceof ASN1Exception) {
                        this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, lDAPException.getMessage(), (Throwable)serializable);
                        object3 = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage((Throwable)serializable));
                    } else {
                        this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, lDAPException.getMessage(), (Throwable)serializable);
                        object3 = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage((Throwable)serializable));
                    }
                    Debug.debug((Level)object2, DebugType.LDAP, (String)object3, (Throwable)serializable);
                    boolean bl2 = this.connection.getConnectionOptions().autoReconnect();
                    if (!this.closeRequested && bl2) {
                        bl = true;
                        break;
                    }
                    this.closeRequested = true;
                    if (this.thread != null) {
                        this.thread.setName(this.thread.getName() + " (closed)");
                        this.thread = null;
                    }
                    this.closeInternal(true, (String)object3);
                    return;
                }
                if (lDAPResponse == null) {
                    this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITHOUT_NOTICE, null, null);
                    boolean bl3 = this.connection.getConnectionOptions().autoReconnect();
                    if (!this.closeRequested && !this.connection.unbindRequestSent() && bl3) {
                        bl = true;
                        break;
                    }
                    this.closeRequested = true;
                    if (this.thread != null) {
                        this.thread.setName(this.thread.getName() + " (closed)");
                        this.thread = null;
                    }
                    this.closeInternal(true, null);
                    return;
                }
                Debug.debugLDAPResult(lDAPResponse, this.connection);
                this.connection.setLastCommunicationTime();
                if (lDAPResponse instanceof SearchResultEntry || lDAPResponse instanceof SearchResultReference) {
                    object = this.acceptorMap.get(lDAPResponse.getMessageID());
                } else {
                    if (lDAPResponse instanceof IntermediateResponse) {
                        serializable = (IntermediateResponse)lDAPResponse;
                        object = this.acceptorMap.get(lDAPResponse.getMessageID());
                        object3 = null;
                        if (object instanceof LDAPRequest) {
                            object2 = (LDAPRequest)object;
                            object3 = ((LDAPRequest)object2).getIntermediateResponseListener();
                        } else if (object instanceof IntermediateResponseListener) {
                            object3 = (IntermediateResponseListener)object;
                        }
                        if (object3 == null) {
                            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(serializable)));
                            continue;
                        }
                        try {
                            object3.intermediateResponseReturned((IntermediateResponse)serializable);
                        }
                        catch (Exception exception) {
                            Debug.debugException(exception);
                        }
                        continue;
                    }
                    object = this.acceptorMap.remove(lDAPResponse.getMessageID());
                }
                if (object == null) {
                    if (lDAPResponse instanceof ExtendedResult && lDAPResponse.getMessageID() == 0) {
                        serializable = (ExtendedResult)lDAPResponse;
                        object3 = ((ExtendedResult)serializable).getOID();
                        if ("1.3.6.1.4.1.1466.20036".equals(object3)) {
                            serializable = new NoticeOfDisconnectionExtendedResult((ExtendedResult)serializable);
                            this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITH_NOTICE, ((LDAPResult)serializable).getDiagnosticMessage(), null);
                        } else if ("1.3.6.1.4.1.30221.2.6.5".equals(object3)) {
                            try {
                                object2 = Class.forName("com.unboundid.ldap.sdk.unboundidds.extensions.InteractiveTransactionAbortedExtendedResult");
                                Constructor<?> constructor = ((Class)object2).getConstructor(ExtendedResult.class);
                                serializable = (ExtendedResult)constructor.newInstance(serializable);
                            }
                            catch (Exception exception) {
                                Debug.debugException(exception);
                            }
                        }
                        object2 = this.connection.getConnectionOptions().getUnsolicitedNotificationHandler();
                        if (object2 == null) {
                            if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION.get(lDAPResponse));
                            continue;
                        }
                        object2.handleUnsolicitedNotification(this.connection, (ExtendedResult)serializable);
                        continue;
                    }
                    if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                    Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_NO_ACCEPTOR.get(lDAPResponse));
                    continue;
                }
                try {
                    object.responseReceived(lDAPResponse);
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                    Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.ERR_READER_ACCEPTOR_ERROR.get(String.valueOf(lDAPResponse), this.connection.getHostPort(), StaticUtils.getExceptionMessage(lDAPException)), lDAPException);
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                serializable = Level.SEVERE;
                if (exception instanceof IOException) {
                    this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, null, exception);
                    object = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(exception));
                    serializable = Level.WARNING;
                } else if (exception instanceof ASN1Exception) {
                    this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, null, exception);
                    object = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(exception));
                } else {
                    this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, exception);
                    object = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(exception));
                }
                Debug.debug((Level)serializable, DebugType.LDAP, (String)object, exception);
                boolean bl4 = this.connection.getConnectionOptions().autoReconnect();
                if (bl4) {
                    bl = true;
                    break;
                }
                this.closeRequested = true;
                if (this.thread != null) {
                    this.thread.setName(this.thread.getName() + " (closed)");
                    this.thread = null;
                }
                this.closeInternal(true, (String)object);
                return;
            }
        }
        if (this.thread != null) {
            this.thread.setName(this.constructThreadName(null));
            this.thread = null;
        }
        if (bl && !this.connection.closeRequested()) {
            try {
                this.connection.setNeedsReconnect();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        } else {
            this.closeInternal(true, null);
        }
    }

    LDAPResponse readResponse(int n) throws LDAPException {
        try {
            while (true) {
                LDAPResponse lDAPResponse;
                if ((lDAPResponse = LDAPMessage.readLDAPResponseFrom(this.asn1StreamReader, false, this.connection.getCachedSchema())) == null) {
                    return new ConnectionClosedResponse(ResultCode.SERVER_DOWN, null);
                }
                this.connection.setLastCommunicationTime();
                if (lDAPResponse.getMessageID() == n) {
                    return lDAPResponse;
                }
                if (lDAPResponse instanceof ExtendedResult && lDAPResponse.getMessageID() == 0) {
                    Object object;
                    ExtendedResult extendedResult = (ExtendedResult)lDAPResponse;
                    String string = extendedResult.getOID();
                    if ("1.3.6.1.4.1.1466.20036".equals(string)) {
                        extendedResult = new NoticeOfDisconnectionExtendedResult(extendedResult);
                        this.connection.setDisconnectInfo(DisconnectType.SERVER_CLOSED_WITH_NOTICE, extendedResult.getDiagnosticMessage(), null);
                    } else if ("1.3.6.1.4.1.30221.2.6.5".equals(string)) {
                        try {
                            object = Class.forName("com.unboundid.ldap.sdk.unboundidds.extensions.InteractiveTransactionAbortedExtendedResult");
                            Constructor<?> constructor = ((Class)object).getConstructor(ExtendedResult.class);
                            extendedResult = (ExtendedResult)constructor.newInstance(extendedResult);
                        }
                        catch (Exception exception) {
                            Debug.debugException(exception);
                        }
                    }
                    object = this.connection.getConnectionOptions().getUnsolicitedNotificationHandler();
                    if (object == null) {
                        if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                        Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION.get(lDAPResponse));
                        continue;
                    }
                    object.handleUnsolicitedNotification(this.connection, extendedResult);
                    continue;
                }
                if (!Debug.debugEnabled(DebugType.LDAP)) continue;
                Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_READER_DISCARDING_UNEXPECTED_RESPONSE.get(lDAPResponse, n));
            }
        }
        catch (LDAPException lDAPException) {
            String string;
            Debug.debugException(lDAPException);
            Throwable throwable = lDAPException.getCause();
            if (throwable != null && throwable instanceof SocketTimeoutException) {
                throw new LDAPException(ResultCode.TIMEOUT, lDAPException.getMessage(), lDAPException);
            }
            Level level = Level.SEVERE;
            if (throwable == null) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, lDAPException.getMessage(), throwable);
                string = lDAPException.getMessage();
                level = Level.WARNING;
            } else if (throwable instanceof IOException) {
                this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, lDAPException.getMessage(), throwable);
                string = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(throwable));
                level = Level.WARNING;
            } else if (throwable instanceof ASN1Exception) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, lDAPException.getMessage(), throwable);
                string = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(throwable));
            } else {
                this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, lDAPException.getMessage(), throwable);
                string = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(throwable));
            }
            Debug.debug(level, DebugType.LDAP, string, throwable);
            boolean bl = this.connection.getConnectionOptions().autoReconnect();
            if (!bl) {
                this.closeRequested = true;
            }
            this.closeInternal(true, string);
            throw lDAPException;
        }
        catch (Exception exception) {
            String string;
            Debug.debugException(exception);
            Level level = Level.SEVERE;
            if (exception instanceof IOException) {
                this.connection.setDisconnectInfo(DisconnectType.IO_ERROR, null, exception);
                string = LDAPMessages.ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(exception));
                level = Level.WARNING;
            } else if (exception instanceof ASN1Exception) {
                this.connection.setDisconnectInfo(DisconnectType.DECODE_ERROR, null, exception);
                string = LDAPMessages.ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(exception));
            } else {
                this.connection.setDisconnectInfo(DisconnectType.LOCAL_ERROR, null, exception);
                string = LDAPMessages.ERR_READER_CLOSING_DUE_TO_EXCEPTION.get(this.connection.getHostPort(), StaticUtils.getExceptionMessage(exception));
            }
            Debug.debug(level, DebugType.LDAP, string, exception);
            boolean bl = this.connection.getConnectionOptions().autoReconnect();
            if (!bl) {
                this.closeRequested = true;
            }
            this.closeInternal(true, string);
            throw new LDAPException(ResultCode.SERVER_DOWN, string, exception);
        }
    }

    void setSoTimeout(int n) throws LDAPException {
        try {
            this.socket.setSoTimeout(n);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_READER_CANNOT_SET_SO_TIMEOUT.get(n, this.connection.toString(), StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream doStartTLS(SSLSocketFactory sSLSocketFactory) throws LDAPException {
        LDAPConnectionOptions lDAPConnectionOptions = this.connection.getConnectionOptions();
        if (this.connection.synchronousMode()) {
            try {
                SSLSocket sSLSocket;
                int n = lDAPConnectionOptions.getConnectTimeoutMillis();
                if (n > 0) {
                    if (Debug.debugEnabled()) {
                        Debug.debug(Level.INFO, DebugType.CONNECT, "Setting SO_TIMEOUT to connect timeout of " + n + "ms in " + "LDAPConnectionReader.doStartTLS while performing " + "StartTLS processing.");
                    }
                    this.socket.setSoTimeout(n);
                } else {
                    if (Debug.debugEnabled()) {
                        Debug.debug(Level.INFO, DebugType.CONNECT, "Setting SO_TIMEOUT to 0ms in LDAPConnectionReader.doStartTLS while performing StartTLS processing.");
                    }
                    this.socket.setSoTimeout(0);
                }
                Object object = sSLSocketFactory;
                synchronized (object) {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, this.connection.getConnectedAddress(), this.socket.getPort(), true);
                    sSLSocket.startHandshake();
                }
                lDAPConnectionOptions.getSSLSocketVerifier().verifySSLSocket(this.connection.getConnectedAddress(), this.socket.getPort(), sSLSocket);
                this.inputStream = new BufferedInputStream(sSLSocket.getInputStream(), 4096);
                this.asn1StreamReader = new ASN1StreamReader(this.inputStream, lDAPConnectionOptions.getMaxMessageSize());
                this.startTLSOutputStream = sSLSocket.getOutputStream();
                this.socket = sSLSocket;
                this.connection.getConnectionInternals(true).setSocket(sSLSocket);
                object = this.startTLSOutputStream;
                this.startTLSOutputStream = null;
                return object;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                this.connection.setDisconnectInfo(DisconnectType.SECURITY_PROBLEM, StaticUtils.getExceptionMessage(exception), exception);
                this.startTLSException = exception;
                this.closeRequested = true;
                this.closeInternal(true, StaticUtils.getExceptionMessage(exception));
                throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED.get(StaticUtils.getExceptionMessage(exception)), exception);
            }
        }
        this.sslSocketFactory = sSLSocketFactory;
        while (true) {
            if (this.startTLSOutputStream != null) {
                OutputStream outputStream = this.startTLSOutputStream;
                this.startTLSOutputStream = null;
                return outputStream;
            }
            if (this.thread == null) {
                if (this.startTLSException == null) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED_NO_EXCEPTION.get());
                }
                Exception exception = this.startTLSException;
                this.startTLSException = null;
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_CONNREADER_STARTTLS_FAILED.get(StaticUtils.getExceptionMessage(exception)), exception);
            }
            this.startTLSSleeper.sleep(10L);
        }
    }

    void applySASLQoP(SaslClient saslClient) {
        InternalASN1Helper.setSASLClient(this.asn1StreamReader, saslClient);
    }

    void close(boolean bl) {
        this.closeRequested = true;
        for (int i = 0; i < 5; ++i) {
            try {
                Thread thread = this.thread;
                if (thread == null || thread == Thread.currentThread() || !thread.isAlive()) break;
                thread.interrupt();
                thread.join(100L);
                continue;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        this.closeInternal(bl, null);
    }

    private void closeInternal(boolean bl, String string) {
        InputStream inputStream = this.inputStream;
        this.inputStream = null;
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        if (bl) {
            this.connection.setClosed();
        }
        Iterator iterator = this.acceptorMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            ResponseAcceptor responseAcceptor = this.acceptorMap.get(n);
            try {
                if (string == null) {
                    DisconnectType disconnectType = this.connection.getDisconnectType();
                    if (disconnectType == null) {
                        responseAcceptor.responseReceived(new ConnectionClosedResponse(ResultCode.SERVER_DOWN, null));
                    } else {
                        responseAcceptor.responseReceived(new ConnectionClosedResponse(disconnectType.getResultCode(), this.connection.getDisconnectMessage()));
                    }
                } else {
                    responseAcceptor.responseReceived(new ConnectionClosedResponse(ResultCode.SERVER_DOWN, string));
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            iterator.remove();
        }
    }

    Thread getReaderThread() {
        return this.thread;
    }

    void updateThreadName() {
        Thread thread = this.thread;
        if (thread != null) {
            try {
                thread.setName(this.constructThreadName(this.connection.getConnectionInternals(true)));
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
    }

    private String constructThreadName(LDAPConnectionInternals lDAPConnectionInternals) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connection reader for connection ");
        stringBuilder.append(this.connection.getConnectionID());
        stringBuilder.append(' ');
        String string = this.connection.getConnectionName();
        if (string != null) {
            stringBuilder.append('\'');
            stringBuilder.append(string);
            stringBuilder.append("' ");
        }
        if ((string = this.connection.getConnectionPoolName()) != null) {
            stringBuilder.append("in pool '");
            stringBuilder.append(string);
            stringBuilder.append("' ");
        }
        if (lDAPConnectionInternals == null) {
            stringBuilder.append("(not connected)");
        } else {
            stringBuilder.append("to ");
            stringBuilder.append(lDAPConnectionInternals.getHost());
            stringBuilder.append(':');
            stringBuilder.append(lDAPConnectionInternals.getPort());
        }
        return stringBuilder.toString();
    }
}

