/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;

public final class LDAPConnectionStatistics
implements Serializable {
    private static final long serialVersionUID = -1096417617572481790L;
    private final AtomicLong numAbandonRequests = new AtomicLong(0L);
    private final AtomicLong numAddRequests = new AtomicLong(0L);
    private final AtomicLong numAddResponses = new AtomicLong(0L);
    private final AtomicLong numBindRequests = new AtomicLong(0L);
    private final AtomicLong numBindResponses = new AtomicLong(0L);
    private final AtomicLong numCompareRequests = new AtomicLong(0L);
    private final AtomicLong numCompareResponses = new AtomicLong(0L);
    private final AtomicLong numConnects = new AtomicLong(0L);
    private final AtomicLong numDeleteRequests = new AtomicLong(0L);
    private final AtomicLong numDeleteResponses = new AtomicLong(0L);
    private final AtomicLong numDisconnects = new AtomicLong(0L);
    private final AtomicLong numExtendedRequests = new AtomicLong(0L);
    private final AtomicLong numExtendedResponses = new AtomicLong(0L);
    private final AtomicLong numModifyRequests = new AtomicLong(0L);
    private final AtomicLong numModifyResponses = new AtomicLong(0L);
    private final AtomicLong numModifyDNRequests = new AtomicLong(0L);
    private final AtomicLong numModifyDNResponses = new AtomicLong(0L);
    private final AtomicLong numSearchRequests = new AtomicLong(0L);
    private final AtomicLong numSearchEntryResponses = new AtomicLong(0L);
    private final AtomicLong numSearchReferenceResponses = new AtomicLong(0L);
    private final AtomicLong numSearchDoneResponses = new AtomicLong(0L);
    private final AtomicLong numUnbindRequests = new AtomicLong(0L);
    private final AtomicLong totalAddResponseTime = new AtomicLong(0L);
    private final AtomicLong totalBindResponseTime = new AtomicLong(0L);
    private final AtomicLong totalCompareResponseTime = new AtomicLong(0L);
    private final AtomicLong totalDeleteResponseTime = new AtomicLong(0L);
    private final AtomicLong totalExtendedResponseTime = new AtomicLong(0L);
    private final AtomicLong totalModifyResponseTime = new AtomicLong(0L);
    private final AtomicLong totalModifyDNResponseTime = new AtomicLong(0L);
    private final AtomicLong totalSearchResponseTime = new AtomicLong(0L);

    public void reset() {
        this.numAbandonRequests.set(0L);
        this.numAddRequests.set(0L);
        this.numAddResponses.set(0L);
        this.numBindRequests.set(0L);
        this.numBindResponses.set(0L);
        this.numCompareRequests.set(0L);
        this.numCompareResponses.set(0L);
        this.numConnects.set(0L);
        this.numDeleteRequests.set(0L);
        this.numDeleteResponses.set(0L);
        this.numDisconnects.set(0L);
        this.numExtendedRequests.set(0L);
        this.numExtendedResponses.set(0L);
        this.numModifyRequests.set(0L);
        this.numModifyResponses.set(0L);
        this.numModifyDNRequests.set(0L);
        this.numModifyDNResponses.set(0L);
        this.numSearchRequests.set(0L);
        this.numSearchEntryResponses.set(0L);
        this.numSearchReferenceResponses.set(0L);
        this.numSearchDoneResponses.set(0L);
        this.numUnbindRequests.set(0L);
        this.totalAddResponseTime.set(0L);
        this.totalBindResponseTime.set(0L);
        this.totalCompareResponseTime.set(0L);
        this.totalDeleteResponseTime.set(0L);
        this.totalExtendedResponseTime.set(0L);
        this.totalModifyResponseTime.set(0L);
        this.totalModifyDNResponseTime.set(0L);
        this.totalSearchResponseTime.set(0L);
    }

    public long getNumConnects() {
        return this.numConnects.get();
    }

    void incrementNumConnects() {
        this.numConnects.incrementAndGet();
    }

    public long getNumDisconnects() {
        return this.numDisconnects.get();
    }

    void incrementNumDisconnects() {
        this.numDisconnects.incrementAndGet();
    }

    public long getNumAbandonRequests() {
        return this.numAbandonRequests.get();
    }

    void incrementNumAbandonRequests() {
        this.numAbandonRequests.incrementAndGet();
    }

    public long getNumAddRequests() {
        return this.numAddRequests.get();
    }

    void incrementNumAddRequests() {
        this.numAddRequests.incrementAndGet();
    }

    public long getNumAddResponses() {
        return this.numAddResponses.get();
    }

    void incrementNumAddResponses(long l) {
        this.numAddResponses.incrementAndGet();
        if (l > 0L) {
            this.totalAddResponseTime.addAndGet(l);
        }
    }

    public long getTotalAddResponseTimeNanos() {
        return this.totalAddResponseTime.get();
    }

    public long getTotalAddResponseTimeMillis() {
        return Math.round((double)this.totalAddResponseTime.get() / 1000000.0);
    }

    public double getAverageAddResponseTimeNanos() {
        long l = this.totalAddResponseTime.get();
        long l2 = this.numAddResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageAddResponseTimeMillis() {
        long l = this.totalAddResponseTime.get();
        long l2 = this.numAddResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumBindRequests() {
        return this.numBindRequests.get();
    }

    void incrementNumBindRequests() {
        this.numBindRequests.incrementAndGet();
    }

    public long getNumBindResponses() {
        return this.numBindResponses.get();
    }

    void incrementNumBindResponses(long l) {
        this.numBindResponses.incrementAndGet();
        if (l > 0L) {
            this.totalBindResponseTime.addAndGet(l);
        }
    }

    public long getTotalBindResponseTimeNanos() {
        return this.totalBindResponseTime.get();
    }

    public long getTotalBindResponseTimeMillis() {
        return Math.round((double)this.totalBindResponseTime.get() / 1000000.0);
    }

    public double getAverageBindResponseTimeNanos() {
        long l = this.totalBindResponseTime.get();
        long l2 = this.numBindResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageBindResponseTimeMillis() {
        long l = this.totalBindResponseTime.get();
        long l2 = this.numBindResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumCompareRequests() {
        return this.numCompareRequests.get();
    }

    void incrementNumCompareRequests() {
        this.numCompareRequests.incrementAndGet();
    }

    public long getNumCompareResponses() {
        return this.numCompareResponses.get();
    }

    void incrementNumCompareResponses(long l) {
        this.numCompareResponses.incrementAndGet();
        if (l > 0L) {
            this.totalCompareResponseTime.addAndGet(l);
        }
    }

    public long getTotalCompareResponseTimeNanos() {
        return this.totalCompareResponseTime.get();
    }

    public long getTotalCompareResponseTimeMillis() {
        return Math.round((double)this.totalCompareResponseTime.get() / 1000000.0);
    }

    public double getAverageCompareResponseTimeNanos() {
        long l = this.totalCompareResponseTime.get();
        long l2 = this.numCompareResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageCompareResponseTimeMillis() {
        long l = this.totalCompareResponseTime.get();
        long l2 = this.numCompareResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumDeleteRequests() {
        return this.numDeleteRequests.get();
    }

    void incrementNumDeleteRequests() {
        this.numDeleteRequests.incrementAndGet();
    }

    public long getNumDeleteResponses() {
        return this.numDeleteResponses.get();
    }

    void incrementNumDeleteResponses(long l) {
        this.numDeleteResponses.incrementAndGet();
        if (l > 0L) {
            this.totalDeleteResponseTime.addAndGet(l);
        }
    }

    public long getTotalDeleteResponseTimeNanos() {
        return this.totalDeleteResponseTime.get();
    }

    public long getTotalDeleteResponseTimeMillis() {
        return Math.round((double)this.totalDeleteResponseTime.get() / 1000000.0);
    }

    public double getAverageDeleteResponseTimeNanos() {
        long l = this.totalDeleteResponseTime.get();
        long l2 = this.numDeleteResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageDeleteResponseTimeMillis() {
        long l = this.totalDeleteResponseTime.get();
        long l2 = this.numDeleteResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumExtendedRequests() {
        return this.numExtendedRequests.get();
    }

    void incrementNumExtendedRequests() {
        this.numExtendedRequests.incrementAndGet();
    }

    public long getNumExtendedResponses() {
        return this.numExtendedResponses.get();
    }

    void incrementNumExtendedResponses(long l) {
        this.numExtendedResponses.incrementAndGet();
        if (l > 0L) {
            this.totalExtendedResponseTime.addAndGet(l);
        }
    }

    public long getTotalExtendedResponseTimeNanos() {
        return this.totalExtendedResponseTime.get();
    }

    public long getTotalExtendedResponseTimeMillis() {
        return Math.round((double)this.totalExtendedResponseTime.get() / 1000000.0);
    }

    public double getAverageExtendedResponseTimeNanos() {
        long l = this.totalExtendedResponseTime.get();
        long l2 = this.numExtendedResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageExtendedResponseTimeMillis() {
        long l = this.totalExtendedResponseTime.get();
        long l2 = this.numExtendedResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumModifyRequests() {
        return this.numModifyRequests.get();
    }

    void incrementNumModifyRequests() {
        this.numModifyRequests.incrementAndGet();
    }

    public long getNumModifyResponses() {
        return this.numModifyResponses.get();
    }

    void incrementNumModifyResponses(long l) {
        this.numModifyResponses.incrementAndGet();
        if (l > 0L) {
            this.totalModifyResponseTime.addAndGet(l);
        }
    }

    public long getTotalModifyResponseTimeNanos() {
        return this.totalModifyResponseTime.get();
    }

    public long getTotalModifyResponseTimeMillis() {
        return Math.round((double)this.totalModifyResponseTime.get() / 1000000.0);
    }

    public double getAverageModifyResponseTimeNanos() {
        long l = this.totalModifyResponseTime.get();
        long l2 = this.numModifyResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageModifyResponseTimeMillis() {
        long l = this.totalModifyResponseTime.get();
        long l2 = this.numModifyResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumModifyDNRequests() {
        return this.numModifyDNRequests.get();
    }

    void incrementNumModifyDNRequests() {
        this.numModifyDNRequests.incrementAndGet();
    }

    public long getNumModifyDNResponses() {
        return this.numModifyDNResponses.get();
    }

    void incrementNumModifyDNResponses(long l) {
        this.numModifyDNResponses.incrementAndGet();
        if (l > 0L) {
            this.totalModifyDNResponseTime.addAndGet(l);
        }
    }

    public long getTotalModifyDNResponseTimeNanos() {
        return this.totalModifyDNResponseTime.get();
    }

    public long getTotalModifyDNResponseTimeMillis() {
        return Math.round((double)this.totalModifyDNResponseTime.get() / 1000000.0);
    }

    public double getAverageModifyDNResponseTimeNanos() {
        long l = this.totalModifyDNResponseTime.get();
        long l2 = this.numModifyDNResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageModifyDNResponseTimeMillis() {
        long l = this.totalModifyDNResponseTime.get();
        long l2 = this.numModifyDNResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumSearchRequests() {
        return this.numSearchRequests.get();
    }

    void incrementNumSearchRequests() {
        this.numSearchRequests.incrementAndGet();
    }

    public long getNumSearchEntryResponses() {
        return this.numSearchEntryResponses.get();
    }

    public long getNumSearchReferenceResponses() {
        return this.numSearchReferenceResponses.get();
    }

    public long getNumSearchDoneResponses() {
        return this.numSearchDoneResponses.get();
    }

    void incrementNumSearchResponses(int n, int n2, long l) {
        this.numSearchEntryResponses.addAndGet(n);
        this.numSearchReferenceResponses.addAndGet(n2);
        this.numSearchDoneResponses.incrementAndGet();
        if (l > 0L) {
            this.totalSearchResponseTime.addAndGet(l);
        }
    }

    public long getTotalSearchResponseTimeNanos() {
        return this.totalSearchResponseTime.get();
    }

    public long getTotalSearchResponseTimeMillis() {
        return Math.round((double)this.totalSearchResponseTime.get() / 1000000.0);
    }

    public double getAverageSearchResponseTimeNanos() {
        long l = this.totalSearchResponseTime.get();
        long l2 = this.numSearchDoneResponses.get();
        if (l > 0L) {
            return 1.0 * (double)l / (double)l2;
        }
        return Double.NaN;
    }

    public double getAverageSearchResponseTimeMillis() {
        long l = this.totalSearchResponseTime.get();
        long l2 = this.numSearchDoneResponses.get();
        if (l > 0L) {
            return (double)l / 1000000.0 / (double)l2;
        }
        return Double.NaN;
    }

    public long getNumUnbindRequests() {
        return this.numUnbindRequests.get();
    }

    void incrementNumUnbindRequests() {
        this.numUnbindRequests.incrementAndGet();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        long l = this.numConnects.get();
        long l2 = this.numDisconnects.get();
        long l3 = this.numAbandonRequests.get();
        long l4 = this.numAddRequests.get();
        long l5 = this.numAddResponses.get();
        long l6 = this.totalAddResponseTime.get();
        long l7 = this.numBindRequests.get();
        long l8 = this.numBindResponses.get();
        long l9 = this.totalBindResponseTime.get();
        long l10 = this.numCompareRequests.get();
        long l11 = this.numCompareResponses.get();
        long l12 = this.totalCompareResponseTime.get();
        long l13 = this.numDeleteRequests.get();
        long l14 = this.numDeleteResponses.get();
        long l15 = this.totalDeleteResponseTime.get();
        long l16 = this.numExtendedRequests.get();
        long l17 = this.numExtendedResponses.get();
        long l18 = this.totalExtendedResponseTime.get();
        long l19 = this.numModifyRequests.get();
        long l20 = this.numModifyResponses.get();
        long l21 = this.totalModifyResponseTime.get();
        long l22 = this.numModifyDNRequests.get();
        long l23 = this.numModifyDNResponses.get();
        long l24 = this.totalModifyDNResponseTime.get();
        long l25 = this.numSearchRequests.get();
        long l26 = this.numSearchEntryResponses.get();
        long l27 = this.numSearchReferenceResponses.get();
        long l28 = this.numSearchDoneResponses.get();
        long l29 = this.totalSearchResponseTime.get();
        long l30 = this.numUnbindRequests.get();
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        stringBuilder.append("LDAPConnectionStatistics(numConnects=");
        stringBuilder.append(l);
        stringBuilder.append(", numDisconnects=");
        stringBuilder.append(l2);
        stringBuilder.append(", numAbandonRequests=");
        stringBuilder.append(l3);
        stringBuilder.append(", numAddRequests=");
        stringBuilder.append(l4);
        stringBuilder.append(", numAddResponses=");
        stringBuilder.append(l5);
        stringBuilder.append(", totalAddResponseTimeNanos=");
        stringBuilder.append(l6);
        if (l6 > 0L) {
            stringBuilder.append(", averageAddResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l5 / (double)l6));
        }
        stringBuilder.append(", numBindRequests=");
        stringBuilder.append(l7);
        stringBuilder.append(", numBindResponses=");
        stringBuilder.append(l8);
        stringBuilder.append(", totalBindResponseTimeNanos=");
        stringBuilder.append(l9);
        if (l9 > 0L) {
            stringBuilder.append(", averageBindResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l8 / (double)l9));
        }
        stringBuilder.append(", numCompareRequests=");
        stringBuilder.append(l10);
        stringBuilder.append(", numCompareResponses=");
        stringBuilder.append(l11);
        stringBuilder.append(", totalCompareResponseTimeNanos=");
        stringBuilder.append(l12);
        if (l12 > 0L) {
            stringBuilder.append(", averageCompareResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l11 / (double)l12));
        }
        stringBuilder.append(", numDeleteRequests=");
        stringBuilder.append(l13);
        stringBuilder.append(", numDeleteResponses=");
        stringBuilder.append(l14);
        stringBuilder.append(", totalDeleteResponseTimeNanos=");
        stringBuilder.append(l15);
        if (l15 > 0L) {
            stringBuilder.append(", averageDeleteResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l14 / (double)l15));
        }
        stringBuilder.append(", numExtendedRequests=");
        stringBuilder.append(l16);
        stringBuilder.append(", numExtendedResponses=");
        stringBuilder.append(l17);
        stringBuilder.append(", totalExtendedResponseTimeNanos=");
        stringBuilder.append(l18);
        if (l18 > 0L) {
            stringBuilder.append(", averageExtendedResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l17 / (double)l18));
        }
        stringBuilder.append(", numModifyRequests=");
        stringBuilder.append(l19);
        stringBuilder.append(", numModifyResponses=");
        stringBuilder.append(l20);
        stringBuilder.append(", totalModifyResponseTimeNanos=");
        stringBuilder.append(l21);
        if (l21 > 0L) {
            stringBuilder.append(", averageModifyResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l20 / (double)l21));
        }
        stringBuilder.append(", numModifyDNRequests=");
        stringBuilder.append(l22);
        stringBuilder.append(", numModifyDNResponses=");
        stringBuilder.append(l23);
        stringBuilder.append(", totalModifyDNResponseTimeNanos=");
        stringBuilder.append(l24);
        if (l24 > 0L) {
            stringBuilder.append(", averageModifyDNResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l23 / (double)l24));
        }
        stringBuilder.append(", numSearchRequests=");
        stringBuilder.append(l25);
        stringBuilder.append(", numSearchEntries=");
        stringBuilder.append(l26);
        stringBuilder.append(", numSearchReferences=");
        stringBuilder.append(l27);
        stringBuilder.append(", numSearchDone=");
        stringBuilder.append(l28);
        stringBuilder.append(", totalSearchResponseTimeNanos=");
        stringBuilder.append(l29);
        if (l29 > 0L) {
            stringBuilder.append(", averageSearchResponseTimeNanos=");
            stringBuilder.append(decimalFormat.format(1.0 * (double)l28 / (double)l29));
        }
        stringBuilder.append(", numUnbindRequests=");
        stringBuilder.append(l30);
        stringBuilder.append(')');
    }
}

