/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.StaticUtils;

public class LDAPException
extends LDAPSDKException {
    private static final long serialVersionUID = -4257171063946350327L;
    protected static final Control[] NO_CONTROLS = StaticUtils.NO_CONTROLS;
    protected static final String[] NO_REFERRALS = StaticUtils.NO_STRINGS;
    private final Control[] responseControls;
    private final ResultCode resultCode;
    private final String[] referralURLs;
    private final String diagnosticMessage;
    private final String matchedDN;

    public LDAPException(ResultCode resultCode) {
        super(resultCode.getName());
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, Throwable throwable) {
        super(resultCode.getName(), throwable);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String string) {
        super(string);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String string, Throwable throwable) {
        super(string, throwable);
        this.resultCode = resultCode;
        this.matchedDN = null;
        this.diagnosticMessage = null;
        this.referralURLs = NO_REFERRALS;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String string, String string2, String[] stringArray) {
        super(string);
        this.resultCode = resultCode;
        this.matchedDN = string2;
        this.referralURLs = stringArray == null ? NO_REFERRALS : stringArray;
        this.diagnosticMessage = null;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String string, String string2, String[] stringArray, Throwable throwable) {
        super(string, throwable);
        this.resultCode = resultCode;
        this.matchedDN = string2;
        this.referralURLs = stringArray == null ? NO_REFERRALS : stringArray;
        this.diagnosticMessage = null;
        this.responseControls = NO_CONTROLS;
    }

    public LDAPException(ResultCode resultCode, String string, String string2, String[] stringArray, Control[] controlArray) {
        super(string);
        this.resultCode = resultCode;
        this.matchedDN = string2;
        this.diagnosticMessage = null;
        this.referralURLs = stringArray == null ? NO_REFERRALS : stringArray;
        this.responseControls = controlArray == null ? NO_CONTROLS : controlArray;
    }

    public LDAPException(ResultCode resultCode, String string, String string2, String[] stringArray, Control[] controlArray, Throwable throwable) {
        super(string, throwable);
        this.resultCode = resultCode;
        this.matchedDN = string2;
        this.diagnosticMessage = null;
        this.referralURLs = stringArray == null ? NO_REFERRALS : stringArray;
        this.responseControls = controlArray == null ? NO_CONTROLS : controlArray;
    }

    public LDAPException(LDAPResult lDAPResult) {
        super(lDAPResult.getDiagnosticMessage() == null ? lDAPResult.getResultCode().getName() : lDAPResult.getDiagnosticMessage());
        this.resultCode = lDAPResult.getResultCode();
        this.matchedDN = lDAPResult.getMatchedDN();
        this.diagnosticMessage = lDAPResult.getDiagnosticMessage();
        this.referralURLs = lDAPResult.getReferralURLs();
        this.responseControls = lDAPResult.getResponseControls();
    }

    public LDAPException(LDAPResult lDAPResult, Throwable throwable) {
        super(lDAPResult.getDiagnosticMessage() == null ? lDAPResult.getResultCode().getName() : lDAPResult.getDiagnosticMessage(), throwable);
        this.resultCode = lDAPResult.getResultCode();
        this.matchedDN = lDAPResult.getMatchedDN();
        this.diagnosticMessage = lDAPResult.getDiagnosticMessage();
        this.referralURLs = lDAPResult.getReferralURLs();
        this.responseControls = lDAPResult.getResponseControls();
    }

    public LDAPException(LDAPException lDAPException) {
        super(lDAPException.getMessage(), lDAPException.getCause());
        this.resultCode = lDAPException.getResultCode();
        this.matchedDN = lDAPException.getMatchedDN();
        this.diagnosticMessage = lDAPException.getDiagnosticMessage();
        this.referralURLs = lDAPException.getReferralURLs();
        this.responseControls = lDAPException.getResponseControls();
    }

    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    public final String getMatchedDN() {
        return this.matchedDN;
    }

    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public final String[] getReferralURLs() {
        return this.referralURLs;
    }

    public final boolean hasResponseControl() {
        return this.responseControls.length > 0;
    }

    public final boolean hasResponseControl(String string) {
        for (Control control : this.responseControls) {
            if (!control.getOID().equals(string)) continue;
            return true;
        }
        return false;
    }

    public final Control[] getResponseControls() {
        return this.responseControls;
    }

    public final Control getResponseControl(String string) {
        for (Control control : this.responseControls) {
            if (!control.getOID().equals(string)) continue;
            return control;
        }
        return null;
    }

    public LDAPResult toLDAPResult() {
        if (this.diagnosticMessage == null && this.getMessage() != null) {
            return new LDAPResult(-1, this.resultCode, this.getMessage(), this.matchedDN, this.referralURLs, this.responseControls);
        }
        return new LDAPResult(-1, this.resultCode, this.diagnosticMessage, this.matchedDN, this.referralURLs, this.responseControls);
    }

    public String getResultString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("result code='");
        stringBuilder.append(this.resultCode);
        stringBuilder.append('\'');
        if (this.diagnosticMessage != null && this.diagnosticMessage.length() > 0) {
            stringBuilder.append(" diagnostic message='");
            stringBuilder.append(this.diagnosticMessage);
            stringBuilder.append('\'');
        }
        if (this.matchedDN != null && this.matchedDN.length() > 0) {
            stringBuilder.append("  matched DN='");
            stringBuilder.append(this.matchedDN);
            stringBuilder.append('\'');
        }
        if (this.referralURLs != null && this.referralURLs.length > 0) {
            stringBuilder.append("  referral URLs={");
            for (int i = 0; i < this.referralURLs.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(this.referralURLs[i]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        int n;
        stringBuilder.append("LDAPException(resultCode=");
        stringBuilder.append(this.resultCode);
        String string = this.getMessage();
        if (string != null) {
            stringBuilder.append(", errorMessage='");
            stringBuilder.append(string);
            stringBuilder.append('\'');
        }
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(this.matchedDN);
            stringBuilder.append('\'');
        }
        if (this.diagnosticMessage != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(this.diagnosticMessage);
            stringBuilder.append('\'');
        }
        if (this.referralURLs.length > 0) {
            stringBuilder.append(", referralURLs={");
            for (n = 0; n < this.referralURLs.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(this.referralURLs[n]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        if (this.responseControls.length > 0) {
            stringBuilder.append(", responseControls={");
            for (n = 0; n < this.responseControls.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.responseControls[n]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    public final String getExceptionMessage() {
        return this.toString();
    }
}

