/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum LDAPMessages {
    ERR_ABANDON_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE("Abandon operations are not supported on connections operating in synchronous mode."),
    ERR_ADD_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to add request with message ID {1,number,0} for entry ''{2}'' from server {3}."),
    ERR_ADD_INTERRUPTED("Add processing was interrupted while waiting for a response from server {0}."),
    ERR_ASYNC_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE("Asynchronous operations are not supported on connections operating in synchronous mode."),
    ERR_ASYNC_SEARCH_INVALID_LISTENER("The search result listener for the provided search request is not an AsyncSearchResultListener."),
    ERR_ASYNC_SEARCH_NO_LISTENER("The provided search request is not configured with a search result listener."),
    ERR_ATTR_CANNOT_DECODE("Unable to read or decode an LDAP attribute:  {0}"),
    ERR_ATTR_DECODE_INVALID_COUNT("An LDAP attribute sequence must contain exactly two elements, but the provided sequence had {0,number,0} elements."),
    ERR_ATTR_DECODE_VALUE_SET("Unable to decode the second element of the LDAP attribute sequence as the value set:  {0}"),
    ERR_BIND_INTERRUPTED("Bind processing was interrupted while waiting for a response from server {0}."),
    ERR_BIND_RESULT_CANNOT_DECODE("Unable to read or decode a bind result:  {0}"),
    ERR_BIND_RESULT_INVALID_ELEMENT("Invalid element type {0} found in a bind result sequence."),
    ERR_COMPARE_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to compare request with message ID {1,number,0} for entry ''{2}'' from server {3}."),
    ERR_COMPARE_INTERRUPTED("Compare processing was interrupted while waiting for a response from server {0}."),
    ERR_CONNECT_THREAD_EXCEPTION("An error occurred while attempting to establish a connection to server {0}:{1,number,0}:  {2}"),
    ERR_CONNECT_THREAD_TIMEOUT("Unable to establish a connection to server {0}:{1,number,0} within the configured timeout of {2,number,0} milliseconds."),
    ERR_CONNREADER_MSGID_IN_USE("The specified message ID is already registered with another response acceptor."),
    ERR_CONNREADER_STARTTLS_FAILED("The connection reader was unable to successfully complete TLS negotiation:  {0}"),
    ERR_CONNREADER_STARTTLS_FAILED_NO_EXCEPTION("The connection reader was unable to successfully complete TLS negotiation, but no additional information is available to explain the reason for the failure."),
    ERR_CONN_CANNOT_AUTHENTICATE_FOR_REFERRAL("Unable to authenticate to remote system {0}:{1,number,0} because the authentication method used does not support rebinding."),
    ERR_CONN_CANNOT_REAUTHENTICATE("The connection to directory server {0} was lost and the authentication method chosen does not provide the ability to automatically re-authenticate."),
    ERR_CONN_CLOSED_BY_UNEXPECTED_CALL_PATH("The connection was closed through an unexpected call path that did not first set the disconnect reason (stack trace:  {0})."),
    ERR_CONN_CLOSED_WAITING_FOR_ADD_RESPONSE("The connection to server {0} was closed while waiting for a response to an add request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_ADD_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to an add request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE("The connection to the directory server was closed while waiting for a response to an asynchronous request."),
    ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE("The connection to the directory server was closed while waiting for a response to an asynchronous request:  {0}"),
    ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE("The connection to server {0} was closed while waiting for a response to a bind request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to a bind request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_COMPARE_RESPONSE("The connection to server {0} was closed while waiting for a response to a compare request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_COMPARE_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to a compare request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_DELETE_RESPONSE("The connection to server {0} was closed while waiting for a response to a delete request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_DELETE_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to a delete request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE("The connection to server {0} was closed while waiting for a response to an extended request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_EXTENDED_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to an extended request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_MODIFY_DN_RESPONSE("The connection to server {0} was closed while waiting for a response to a modify DN request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_MODIFY_DN_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to a modify DN request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_MODIFY_RESPONSE("The connection to server {0} was closed while waiting for a response to a modify request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_MODIFY_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to a modify request {1}:  {2}"),
    ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE("The connection to server {0} was closed while waiting for a response to search request {1}."),
    ERR_CONN_CLOSED_WAITING_FOR_SEARCH_RESPONSE_WITH_MESSAGE("The connection to server {0} was closed while waiting for a response to search request {1}:  {2}"),
    ERR_CONN_CONNECT_ERROR("An error occurred while attempting to connect to server {0}:  {1}"),
    ERR_CONN_ENCODE_ERROR("An error occurred while encoding the LDAP message or sending it to server {0}:  {1}"),
    ERR_CONN_MULTIPLE_FAILURES("Multiple connect failures in less than one second."),
    ERR_CONN_NOT_ESTABLISHED("The connection is not established."),
    ERR_CONN_READ_RESPONSE_NOT_ESTABLISHED("An attempt was made to read a response on a connection that is not established."),
    ERR_CONN_RESOLVE_ERROR("An error occurred while attempting to resolve address ''{0}'':  {1}"),
    ERR_CONN_SEND_ERROR("An error occurred while attempting to send the LDAP message to server {0}:  {1}"),
    ERR_CONTROLS_DECODE_ELEMENT_NOT_SEQUENCE("Unable to decode the provided sequence as a set of controls because one of the elements could not be decoded as a control sequence:  {0}"),
    ERR_CONTROL_CANNOT_DECODE("Unable to read or decode an LDAP control:  {0}"),
    ERR_CONTROL_DECODE_CRITICALITY("Unable to decode the second element of the control sequence as a Boolean criticality:  {0}"),
    ERR_CONTROL_DECODE_INVALID_ELEMENT_COUNT("The control sequence contained an invalid number of elements (expected between 1 and 3, got {0,number,0})."),
    ERR_CONTROL_INVALID_TYPE("The second element of the control sequence contained an invalid BER type of {0}."),
    ERR_DELETE_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to delete request with message ID {1,number,0} for entry ''{2}'' from server {3}."),
    ERR_DELETE_INTERRUPTED("Delete processing was interrupted while waiting for a response from server {0}."),
    ERR_DN_ENDS_WITH_COMMA("Unexpected comma or semicolon found at the end of the DN string."),
    ERR_DN_ENDS_WITH_PLUS("The provided DN string ends with a plus sign that is not followed by a name-value pair."),
    ERR_DN_MATCHES_UNSUPPORTED_SCOPE("Unable to determine whether DN ''{0}'' matches the specified base and scope because the provided scope ''{1}'' is not supported for this determination."),
    ERR_DN_NO_ATTR_IN_RDN("The provided DN string does not contain an attribute name in an RDN component."),
    ERR_DN_NO_EQUAL_SIGN("The provided string could not be decoded as a DN because no equal sign was found after the RDN attribute ''{0}''."),
    ERR_DN_UNEXPECTED_CHAR("Unexpected character {0} found at position {1,number,0} in the DN string."),
    ERR_DN_UNEXPECTED_COMMA("Unexpected comma or semicolon encountered at position {0,number,0} of the DN string."),
    ERR_ENTRY_APPLY_MODS_ADD_EXISTING("Unable to add value ''{0}'' for attribute {1} because that value already exists in the entry."),
    ERR_ENTRY_APPLY_MODS_ADD_NO_VALUES("Unable to perform the add for attribute {0} because there were no values contained in the provided modification."),
    ERR_ENTRY_APPLY_MODS_DELETE_NONEXISTENT_ATTR("Unable to remove attribute {0} because it does not exist in the entry."),
    ERR_ENTRY_APPLY_MODS_DELETE_NONEXISTENT_VALUE("Unable to remove value ''{0}'' for attribute {1} because it does not exist in the entry."),
    ERR_ENTRY_APPLY_MODS_FAILURE("Unable to update entry {0}:  {1}"),
    ERR_ENTRY_APPLY_MODS_INCREMENT_ENTRY_VALUE_NOT_INTEGER("Unable to increment the value for attribute {0} because the value ''{1}'' for that attribute in the entry cannot be parsed as an integer."),
    ERR_ENTRY_APPLY_MODS_INCREMENT_MOD_VALUE_NOT_INTEGER("Unable to increment the value for attribute {0} because the provided increment value ''{1}'' cannot be parsed as an integer."),
    ERR_ENTRY_APPLY_MODS_INCREMENT_MULTIPLE_MOD_VALUES("Unable to increment the value for attribute {0} because the increment modification had multiple values."),
    ERR_ENTRY_APPLY_MODS_INCREMENT_NOT_SINGLE_VALUED("Unable to increment the value for attribute {0} because the entry has multiple values for that attribute."),
    ERR_ENTRY_APPLY_MODS_INCREMENT_NO_MOD_VALUES("Unable to increment the value for attribute {0} because the increment modification did not include any values."),
    ERR_ENTRY_APPLY_MODS_INCREMENT_NO_SUCH_ATTR("Unable to increment the value for attribute {0} because that attribute does not exist in the entry."),
    ERR_ENTRY_APPLY_MODS_TARGETS_RDN("Unable to apply the modification to entry ''{0}'' because the modifications would have impacted the entry RDN."),
    ERR_ENTRY_APPLY_MODS_UNKNOWN_TYPE("Unknown modification type {0}."),
    ERR_EXCEPTION_HANDLING_RESPONSE("An error occurred while attempting to handle the response message:  {0}"),
    ERR_EXTENDED_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to extended request with message ID {1,number,0} and request OID ''{2}'' from server {3}."),
    ERR_EXTENDED_RESULT_CANNOT_DECODE("Unable to read or decode an extended result:  {0}"),
    ERR_EXTENDED_RESULT_INVALID_ELEMENT("Invalid element type {0} found in an extended result sequence."),
    ERR_EXTOP_INTERRUPTED("Extended operation processing was interrupted while waiting for a response from server {0}."),
    ERR_FILTER_APPROXIMATE_MATCHING_NOT_SUPPORTED("Approximate matching is not supported when attempting to determine whether a given entry matches a search filter."),
    ERR_FILTER_CANNOT_DECODE("Unable to read or decode a search filter:  {0}"),
    ERR_FILTER_CANNOT_DECODE_AVA("Unable to decode the value of the filter element as an attribute value assertion:  {0}"),
    ERR_FILTER_CANNOT_DECODE_COMPS("Unable to decode the provided filter element as a set of components for an AND or OR filter:  {0}"),
    ERR_FILTER_CANNOT_DECODE_EXTMATCH("Unable to decode the provided filter element as an extensible match component:  {0}"),
    ERR_FILTER_CANNOT_DECODE_NOT_COMP("Unable to decode the provided filter element as the component for a NOT filter:  {0}"),
    ERR_FILTER_CANNOT_DECODE_SUBSTRING("Unable to decode the value of the filter element as a substring filter sequence:  {0}"),
    ERR_FILTER_CANNOT_PARSE_MRID("Unable to parse the matching rule ID and/or dnAttributes flag from an extensible match filter component beginning at position {0,number,0}."),
    ERR_FILTER_ELEMENT_INVALID_TYPE("The provided ASN.1 element had an invalid BER type ({0}) for an LDAP filter component."),
    ERR_FILTER_EMPTY_ATTR_NAME("Zero-length attribute name found in the filter component starting at position {0,number,0}."),
    ERR_FILTER_EMPTY_MRID("Unable to parse an extensible match filter component starting at position {0,number,0} because the matching rule ID string was empty."),
    ERR_FILTER_END_AFTER_GT("Unexpected end of filter encountered after the greater than sign in the filter component starting at position {0,number,0}."),
    ERR_FILTER_END_AFTER_LT("Unexpected end of filter encountered after the less than sign in the filter component starting at position {0,number,0}."),
    ERR_FILTER_END_AFTER_TILDE("Unexpected end of filter encountered after the tilde in the filter component starting at position {0,number,0}."),
    ERR_FILTER_EXPECTED_CLOSE_PAREN("Expected a closing parenthesis in the provided filter string at position {0,number,0}."),
    ERR_FILTER_EXPECTED_OPEN_PAREN("Expected an opening parenthesis in the provided filter string at position {0,number,0}."),
    ERR_FILTER_EXTENSIBLE_MATCHING_NOT_SUPPORTED("Extensible matching is not supported when attempting to determine whether a given entry matches a search filter."),
    ERR_FILTER_EXTMATCH_DNATTRS_NOT_BOOLEAN("Unable to decode the provided extensible match filter because the dnAttributes flag element could not be decoded as a Boolean:  {0}"),
    ERR_FILTER_EXTMATCH_INVALID_TYPE("Unable to decode the provided extensible match filter because the filter sequence contained an element with an invalid type ({0})."),
    ERR_FILTER_EXTMATCH_MULTIPLE_ATTRS("Unable to decode the provided extensible match filter because it included multiple attribute name elements."),
    ERR_FILTER_EXTMATCH_MULTIPLE_DNATTRS("Unable to decode the provided extensible match filter because it included multiple dnAttributes elements."),
    ERR_FILTER_EXTMATCH_MULTIPLE_MRIDS("Unable to decode the provided extensible match filter because it included multiple matching rule ID elements."),
    ERR_FILTER_EXTMATCH_MULTIPLE_VALUES("Unable to decode the provided extensible match filter because it included multiple match value elements."),
    ERR_FILTER_EXTMATCH_NO_ATTR_OR_MRID("Unable to decode the provided extensible match filter because it did not contain either an attribute name or a matching rule ID, but at least one of them must be given."),
    ERR_FILTER_EXTMATCH_NO_VALUE("Unable to decode the provided extensible match filter because it did not contain a match value, which is a required element."),
    ERR_FILTER_INVALID_AVA_ELEMENT_COUNT("Invalid number of elements in the attribute value assertion sequence (expected 2, got {0,number,0})."),
    ERR_FILTER_INVALID_HEX_CHAR("Invalid hex character ''{0}'' encountered at position {1,number,0}."),
    ERR_FILTER_INVALID_SUBSTR_ASSERTION_COUNT("Unable to decode the value of the filter element as a substring filter because the filter sequence had an invalid number of elements (expected 2, got {0,number,0})."),
    ERR_FILTER_INVALID_SUBSTR_TYPE("Invalid substring component type {0}."),
    ERR_FILTER_INVALID_TYPE("Invalid filter type {0}."),
    ERR_FILTER_MISMATCHED_PARENS("Mismatched number of parentheses encountered in the provided search filter string between positions {0,number,0} and {1,number,0}."),
    ERR_FILTER_MISSING_PARENTHESES("Expected parentheses around the filter component ''{0}''."),
    ERR_FILTER_MULTIPLE_SUBFINAL("The substring filter included multiple subFinal elements."),
    ERR_FILTER_MULTIPLE_SUBINITIAL("The substring filter included multiple subInitial elements."),
    ERR_FILTER_NO_COLON_AFTER_MRID("Unable to parse an extensible match filter component starting at position {0,number,0} because the end of the component was reached before a colon was found to mark the end of the matching rule ID."),
    ERR_FILTER_NO_EQUALS("Encountered the end of the filter component starting at position {0,number,0} without finding an equal sign to indicate the start of the assertion value."),
    ERR_FILTER_NO_EQUAL_AFTER_MRID("Unable to parse an extensible match filter component starting at position {0,number,0} because the colon following the matching rule ID was not followed by an equal sign."),
    ERR_FILTER_NO_EQUAL_SIGN("The filter component starting at position {0,number,0} does not have an equal sign to separate the attribute description from the assertion value."),
    ERR_FILTER_OPEN_WITHOUT_CLOSE("Opening parenthesis found at position {0,number,0} without the expected closing parenthesis at position {1,number,0}."),
    ERR_FILTER_TOO_DEEP("The provided search filter string was nested too deeply to be parsed."),
    ERR_FILTER_TOO_SHORT("The provided filter string is too short to be a valid search filter."),
    ERR_FILTER_UNEXPECTED_ASTERISK("Unexpected unescaped asterisk encountered in the non-presence, non-substring filter component starting at position {0,number,0}."),
    ERR_FILTER_UNEXPECTED_CHAR_AFTER_GT("Unexpected character following the greater than sign in the filter component starting at position {0,number,0} (expected ''='', got ''{1}'')."),
    ERR_FILTER_UNEXPECTED_CHAR_AFTER_LT("Unexpected character following the less than sign in the filter component starting at position {0,number,0} (expected ''='', got ''{1}'')."),
    ERR_FILTER_UNEXPECTED_CHAR_AFTER_MRID("Unexpected character {0} after the colon following the matching rule ID in the extensible match filter starting at position {1,number,0}."),
    ERR_FILTER_UNEXPECTED_CHAR_AFTER_TILDE("Unexpected character following the tilde in the filter component starting at position {0,number,0} (expected ''='', got ''{1}'')."),
    ERR_FILTER_UNEXPECTED_CHAR_IN_AV("Unexpected character ''{0}'' found as the only character in the assertion value in the filter component starting at position {1,number,0}."),
    ERR_FILTER_UNEXPECTED_CLOSE_PAREN("Unexpected closing parenthesis found at position {0,number,0} of the filter string."),
    ERR_FILTER_UNEXPECTED_DOUBLE_ASTERISK("Unexpected double asterisk encountered in the substring filter component starting at position {0,number,0}."),
    ERR_FILTER_UNEXPECTED_OPEN_PAREN("Unexpected opening parenthesis found at position {0,number,0} of the filter string."),
    ERR_INTERMEDIATE_RESPONSE_CANNOT_DECODE("Unable to read or decode an intermediate response:  {0}"),
    ERR_INTERMEDIATE_RESPONSE_INVALID_ELEMENT("Invalid element type {0} found in an intermediate response sequence."),
    ERR_LDAPURL_ATTRLIST_EMPTY_ATTRIBUTE("Empty attribute name found in the attribute list."),
    ERR_LDAPURL_ATTRLIST_ENDS_WITH_COMMA("The attribute list ended with a comma."),
    ERR_LDAPURL_HEX_STRING_TOO_SHORT("Unable to percent-decode string ''{0}'' from the URL because it included a percent character that was not followed by two hexadecimal digits."),
    ERR_LDAPURL_INVALID_HEX_CHAR("Invalid non-hexadecimal character ''{0}'' found following a percent sign in the URL string."),
    ERR_LDAPURL_INVALID_PORT("Invalid port value {0,number,0} found in the LDAP URL (port values must be between 1 and 65535)."),
    ERR_LDAPURL_INVALID_SCHEME("The provided URL string cannot be parsed as an LDAP URL because it had an invalid scheme of ''{0}''.  The only accepted scheme values are ''ldap'' and ''ldaps''."),
    ERR_LDAPURL_INVALID_SCOPE("Invalid scope string ''{0}''."),
    ERR_LDAPURL_INVALID_SCOPE_VALUE("Invalid scope value ''{0}''."),
    ERR_LDAPURL_IPV6_HOST_EMPTY("An IPv6 literal address cannot be a zero-length string."),
    ERR_LDAPURL_IPV6_HOST_MISSING_BRACKET("The host/port element of the LDAP URL started with a square bracket to begin an IPv6 address, but there was no closing bracket to end the address."),
    ERR_LDAPURL_IPV6_HOST_UNEXPECTED_CHAR("Unexpected character ''{0}'' found after the bracket-enclosed address."),
    ERR_LDAPURL_NO_COLON_SLASHES("The provided URL string cannot be parsed as an LDAP URL because it does not include a ''://'' to separate the scheme name from the rest of the URL."),
    ERR_LDAPURL_PORT_NOT_INT("Unable to decode ''{0}'' as an address:port because the value after the colon could not be parsed as an integer."),
    ERR_MODDN_INTERRUPTED("Modify DN processing was interrupted while waiting for a response from server {0}."),
    ERR_MODIFY_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to modify request with message ID {1,number,0} for entry ''{2}'' from server {3}."),
    ERR_MODIFY_DN_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to modify DN request with message ID {1,number,0} for entry ''{2}'' from server {3}."),
    ERR_MODIFY_INTERRUPTED("Modify processing was interrupted while waiting for a response from server {0}."),
    ERR_MODIFY_INVALID_LDIF("The provided LDIF lines did not represent a modify change record."),
    ERR_MOD_CANNOT_DECODE("Unable to read or decode a modification:  {0}"),
    ERR_MOD_DECODE_CANNOT_PARSE_ATTR("Unable to decode the attribute element of the modification as a sequence:  {0}"),
    ERR_MOD_DECODE_CANNOT_PARSE_ATTR_VALUE_SET("Unable to decode the attribute value set from the modification sequence:  {0}"),
    ERR_MOD_DECODE_CANNOT_PARSE_MOD_TYPE("Unable to decode the modification type element as an enumerated element:  {0}"),
    ERR_MOD_DECODE_INVALID_ATTR_ELEMENT_COUNT("An LDAP modification sequence must have exactly two elements in the attribute sequence, but the provided sequence had {0,number,0}."),
    ERR_MOD_DECODE_INVALID_ELEMENT_COUNT("An LDAP modification sequence must have exactly two elements but the provided sequence had {0,number,0}."),
    ERR_POOL_CLOSED("This connection pool has been closed."),
    ERR_POOL_CONN_NOT_ESTABLISHED("The provided connection is not established."),
    ERR_POOL_HEALTH_CHECK_CONN_CLOSED("An attempt to read from a connection during health check processing indicated that the connection has been closed."),
    ERR_POOL_HEALTH_CHECK_CONN_INVALID_AFTER_EXCEPTION("The connection is no longer valid after an exception encountered during processing:  {0}"),
    ERR_POOL_HEALTH_CHECK_READ_FAILURE("An unexpected error occurred while attempting to read from a connection during health check processing:  {0}"),
    ERR_POOL_NO_CONNECTIONS("No connections are currently available in the connection pool."),
    ERR_POOL_OP_EXCEPTION("An unexpected error occurred while processing the operation:  {0}"),
    ERR_POOL_POST_CONNECT_ERROR("An error occurred while performing post-connect processing on a connection created for use in a connection pool:  {0}"),
    ERR_POOL_PROCESS_REQUESTS_ASYNC_OP_NOT_ASYNC("Unable to process request {0} as one of the asynchronous operations because it is not an add, compare, delete, modify, modify DN, or search operation."),
    ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_EXCEPTION("An unexpected client-side exception was encountered while waiting for a response to the associated request:  {0}.  It is not possible to determine whether the server successfully processed the operation."),
    ERR_POOL_PROCESS_REQUESTS_ASYNC_RESULT_TIMEOUT("A client-side timeout was encountered while waiting at least {0,number,0} milliseconds for a response to the associated request.  It is not possible to determine whether the server successfully processed the operation."),
    ERR_POOL_PROCESS_REQUESTS_ASYNC_SEARCH_NOT_ASYNC("Unable to process search request {0} as one of the asynchronous operations because it is not configured with an AsyncSearchResultListener."),
    ERR_POOL_PROCESS_REQUESTS_ASYNC_SYNCHRONOUS_MODE("Unable to process asynchronous operations using a connection pool with connections configured to operate in synchronous mode."),
    ERR_POOL_STARTTLS_NOT_ALLOWED("The StartTLS operation cannot be processed on a connection that is part of a connection pool."),
    ERR_RDN_CHAR_OUTSIDE_QUOTES("Unexpected character {0} found at position {1,number,0} outside the quotes around the RDN value."),
    ERR_RDN_ENDS_WITH_BACKSLASH("Unexpected backslash found at the end of the RDN string."),
    ERR_RDN_INVALID_HEX_CHAR("Invalid character {0} found at position {1,number,0} in hex string."),
    ERR_RDN_MISSING_HEX_CHAR("There were an odd number of characters in the hex string."),
    ERR_RDN_NO_ATTR_NAME("The provided RDN string does not contain an attribute name."),
    ERR_RDN_NO_EQUAL_SIGN("The provided string could not be decoded as an RDN because no equal sign was found after attribute ''{0}''."),
    ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP("The provided RDN string ends with a plus sign that is not followed by a name-value pair."),
    ERR_RDN_UNCLOSED_DOUBLE_QUOTE("Unclosed double quote in RDN value."),
    ERR_RDN_UNEXPECTED_DOUBLE_QUOTE("Unexpected unescaped double quote found at position {0,number,0} in the RDN string."),
    ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS("The provided RDN string has a value which is followed by a character that is not a plus sign."),
    ERR_READER_ACCEPTOR_ERROR("Discarding response LDAP message {0} from server {1} because an error occurred while passing the message to the corresponding acceptor:  {2}"),
    ERR_READER_CANNOT_SET_SO_TIMEOUT("An error occurred while attempting to set an SO_TIMEOUT value of {0,number0}ms for LDAP connection {1}:  {2}"),
    ERR_READER_CLOSING_DUE_TO_ASN1_EXCEPTION("Terminating the connection to server {0} because data read from the server could not be parsed as an ASN.1 element:  {1}"),
    ERR_READER_CLOSING_DUE_TO_EXCEPTION("Terminating the connection to server {0} because an unexpected error occurred during processing:  {1}"),
    ERR_READER_CLOSING_DUE_TO_INTERRUPTED_IO("Terminating the connection to server {0} because an attempted I/O operation was interrupted when the connection was discovered to have been closed by the server."),
    ERR_READER_CLOSING_DUE_TO_IO_EXCEPTION("Terminating the connection to server {0} because an I/O problem occurred while trying to read data:  {1}"),
    ERR_RESULT_CANNOT_DECODE("Unable to read or decode an LDAP result:  {0}"),
    ERR_SASL_BIND_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to SASL {1} bind request with message ID {2,number,0} from server {3}."),
    ERR_SEARCH_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to search request with message ID {1,number,0}, base DN ''{2}'', scope {3}, and filter ''{4}'' from server {5}."),
    ERR_SEARCH_ENTRY_CANNOT_DECODE("Unable to read or decode a search result entry:  {0}"),
    ERR_SEARCH_INTERRUPTED("Search processing was interrupted while waiting for a response from server {0}."),
    ERR_SEARCH_REFERENCE_CANNOT_DECODE("Unable to read or decode a search result reference:  {0}"),
    ERR_SIMPLE_BIND_CLIENT_TIMEOUT("A client-side timeout was encountered while waiting {0,number,0}ms for a response to simple bind request with message ID {1,number,0} for user ''{2}'' from server {3}."),
    ERR_SIMPLE_BIND_DN_WITHOUT_PASSWORD("Simple bind operations are not allowed to contain a bind DN without a password."),
    ERR_SIMPLE_BIND_ENCODE_PROTOCOL_OP_WITH_PROVIDER("The SimpleBindRequest.encodeProtocolOp method may only be called for bind requests created with a static password.  It may not be used for bind requests created with a password provider."),
    ERR_TOO_MANY_REFERRALS("Too many referrals were encountered while attempting to process the operation."),
    INFO_ASYNC_OPERATION_TIMEOUT_WITHOUT_ABANDON("The asynchronous operation encountered a client-side timeout after waiting {0,number,0} milliseconds for a response to arrive."),
    INFO_ASYNC_OPERATION_TIMEOUT_WITH_ABANDON("The asynchronous operation encountered a client-side timeout after waiting {0,number,0} milliseconds for a response to arrive.  The operation will be abandoned."),
    INFO_ASYNC_REQUEST_USER_CANCELED("An abandon request was sent for the operation through the AsyncRequestID.cancel() method."),
    INFO_DISCONNECT_TYPE_BIND_FAILED("The client closed the connection because a bind operation performed as part of creating the connection did not complete successfully."),
    INFO_DISCONNECT_TYPE_CLOSED_BY_FINALIZER("The connection was closed by a finalizer in the LDAP SDK, which indicates that it was not properly closed by the application that was using the connection."),
    INFO_DISCONNECT_TYPE_DECODE_ERROR("The connection was closed because an error occurred while attempting to decode data from the server."),
    INFO_DISCONNECT_TYPE_IO_ERROR("The connection was closed because an I/O problem was encountered while attempting to communicate with the server."),
    INFO_DISCONNECT_TYPE_LOCAL_ERROR("The connection was closed because of an unexpected error encountered within the LDAP SDK."),
    INFO_DISCONNECT_TYPE_OTHER("The connection was closed for a reason that is not suitable for any other disconnect type."),
    INFO_DISCONNECT_TYPE_POOLED_CONNECTION_DEFUNCT("The connection was closed because it was part of a connection pool and had been classified as defunct."),
    INFO_DISCONNECT_TYPE_POOLED_CONNECTION_EXPIRED("The connection was closed because it was part of a connection pool and had been established for longer than the pool's maximum connection age."),
    INFO_DISCONNECT_TYPE_POOLED_CONNECTION_UNNEEDED("The connection was closed because it was part of a connection pool and was no longer needed."),
    INFO_DISCONNECT_TYPE_POOL_CLOSED("The connection was closed because it was part of a connection pool that was closed."),
    INFO_DISCONNECT_TYPE_POOL_CREATION_FAILURE("The connection was closed because it was part of a connection pool and a failure occurred while attempting to create another connection for use as part of the pool."),
    INFO_DISCONNECT_TYPE_RECONNECT("The client closed the connection because it was going to reconnect the existing connection."),
    INFO_DISCONNECT_TYPE_REFERRAL("The client closed the connection because it was a temporary connection created for following a referral and was no longer needed."),
    INFO_DISCONNECT_TYPE_SECURITY_PROBLEM("The connection was closed because an error was encountered while attempting to negotiate a security layer with the server."),
    INFO_DISCONNECT_TYPE_SERVER_CLOSED_WITHOUT_NOTICE("The server closed the connection without prior notice."),
    INFO_DISCONNECT_TYPE_SERVER_CLOSED_WITH_NOTICE("The server closed the connection with a notice of disconnection unsolicited notification."),
    INFO_DISCONNECT_TYPE_UNBIND("The client closed the connection with an unbind request."),
    INFO_DISCONNECT_TYPE_UNKNOWN("The reason for the disconnect is not known to the LDAP SDK."),
    INFO_RC_ADMIN_LIMIT_EXCEEDED("admin limit exceeded"),
    INFO_RC_AFFECTS_MULTIPLE_DSAS("affects multiple DSAs"),
    INFO_RC_ALIAS_DEREFERENCING_PROBLEM("alias dereferencing problem"),
    INFO_RC_ALIAS_PROBLEM("alias problem"),
    INFO_RC_ASSERTION_FAILED("assertion failed"),
    INFO_RC_ATTRIBUTE_OR_VALUE_EXISTS("attribute or value exists"),
    INFO_RC_AUTHORIZATION_DENIED("authorization denied"),
    INFO_RC_AUTH_METHOD_NOT_SUPPORTED("auth method not supported"),
    INFO_RC_AUTH_UNKNOWN("auth unknown"),
    INFO_RC_BUSY("busy"),
    INFO_RC_CANCELED("canceled"),
    INFO_RC_CANNOT_CANCEL("cannot cancel"),
    INFO_RC_CLIENT_LOOP("client loop"),
    INFO_RC_COMPARE_FALSE("compare false"),
    INFO_RC_COMPARE_TRUE("compare true"),
    INFO_RC_CONFIDENTIALITY_REQUIRED("confidentiality required"),
    INFO_RC_CONNECT_ERROR("connect error"),
    INFO_RC_CONSTRAINT_VIOLATION("constraint violation"),
    INFO_RC_CONTROL_NOT_FOUND("control not found"),
    INFO_RC_DATABASE_LOCK_CONFLICT("database lock conflict"),
    INFO_RC_DECODING_ERROR("decoding error"),
    INFO_RC_ENCODING_ERROR("encoding error"),
    INFO_RC_ENTRY_ALREADY_EXISTS("entry already exists"),
    INFO_RC_E_SYNC_REFRESH_REQUIRED("e-sync refresh required"),
    INFO_RC_FILTER_ERROR("filter error"),
    INFO_RC_INAPPROPRIATE_AUTHENTICATION("inappropriate authentication"),
    INFO_RC_INAPPROPRIATE_MATCHING("inappropriate matching"),
    INFO_RC_INSUFFICIENT_ACCESS_RIGHTS("insufficient access rights"),
    INFO_RC_INTERACTIVE_TRANSACTION_ABORTED("interactive transaction aborted"),
    INFO_RC_INVALID_ATTRIBUTE_SYNTAX("invalid attribute syntax"),
    INFO_RC_INVALID_CREDENTIALS("invalid credentials"),
    INFO_RC_INVALID_DN_SYNTAX("invalid DN syntax"),
    INFO_RC_LOCAL_ERROR("local error"),
    INFO_RC_LOOP_DETECT("loop detect"),
    INFO_RC_MIRRORED_SUBTREE_DIGEST_MISMATCH("mirrored subtree digest mismatch"),
    INFO_RC_MORE_RESULTS_TO_RETURN("more results to return"),
    INFO_RC_NAMING_VIOLATION("naming violation"),
    INFO_RC_NOT_ALLOWED_ON_NONLEAF("not allowed on non-leaf"),
    INFO_RC_NOT_ALLOWED_ON_RDN("not allowed on RDN"),
    INFO_RC_NOT_SUPPORTED("not supported"),
    INFO_RC_NO_MEMORY("no memory"),
    INFO_RC_NO_OPERATION("no operation"),
    INFO_RC_NO_RESULTS_RETURNED("no results returned"),
    INFO_RC_NO_SUCH_ATTRIBUTE("no such attribute"),
    INFO_RC_NO_SUCH_OBJECT("no such object"),
    INFO_RC_NO_SUCH_OPERATION("no such operation"),
    INFO_RC_OBJECT_CLASS_MODS_PROHIBITED("object class mods prohibited"),
    INFO_RC_OBJECT_CLASS_VIOLATION("object class violation"),
    INFO_RC_OFFSET_RANGE_ERROR("offset range error"),
    INFO_RC_OPERATIONS_ERROR("operations error"),
    INFO_RC_OTHER("other"),
    INFO_RC_PARAM_ERROR("parameter error"),
    INFO_RC_PROTOCOL_ERROR("protocol error"),
    INFO_RC_REFERRAL("referral"),
    INFO_RC_REFERRAL_LIMIT_EXCEEDED("referral limit exceeded"),
    INFO_RC_SASL_BIND_IN_PROGRESS("SASL bind in progress"),
    INFO_RC_SERVER_DOWN("server down"),
    INFO_RC_SIZE_LIMIT_EXCEEDED("size limit exceeded"),
    INFO_RC_SORT_CONTROL_MISSING("sort control missing"),
    INFO_RC_STRONG_AUTH_REQUIRED("strong auth required"),
    INFO_RC_SUCCESS("success"),
    INFO_RC_TIMEOUT("timeout"),
    INFO_RC_TIME_LIMIT_EXCEEDED("time limit exceeded"),
    INFO_RC_TOKEN_DELIVERY_ATTEMPT_FAILED("token delivery attempt failed"),
    INFO_RC_TOKEN_DELIVERY_INVALID_ACCOUNT_STATE("token delivery invalid account state"),
    INFO_RC_TOKEN_DELIVERY_INVALID_RECIPIENT_ID("token delivery invalid recipient ID"),
    INFO_RC_TOKEN_DELIVERY_MECHANISM_UNAVAILABLE("token delivery mechanism unavailable"),
    INFO_RC_TOO_LATE("too late"),
    INFO_RC_UNAVAILABLE("unavailable"),
    INFO_RC_UNAVAILABLE_CRITICAL_EXTENSION("unavailable critical extension"),
    INFO_RC_UNDEFINED_ATTRIBUTE_TYPE("undefined attribute type"),
    INFO_RC_UNWILLING_TO_PERFORM("unwilling to perform"),
    INFO_RC_USER_CANCELED("user canceled"),
    INFO_RC_VIRTUAL_LIST_VIEW_ERROR("virtual list view error"),
    WARN_ASYNC_REQUEST_GET_TIMEOUT("No response has been received from the server after a maximum wait time of {0,number,0} milliseconds.  The operation may still be in progress in the server, or it may have already been interrupted through another channel that could not be detected by the LDAP SDK."),
    WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER("Received an intermediate response message ({0}) for which no listener was registered."),
    WARN_READER_DISCARDING_UNEXPECTED_RESPONSE("Discarding response {0} because it did not have the expected message ID of {1,number,0}."),
    WARN_READER_NO_ACCEPTOR("Received a response message {0} for which no response acceptor was registered."),
    WARN_READER_UNHANDLED_UNSOLICITED_NOTIFICATION("Discarding unsolicited notification {0} because no handler is registered with the connection.");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<LDAPMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<LDAPMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private LDAPMessages(String string2) {
        this.defaultText = string2;
    }

    public String get() {
        String string = MESSAGE_STRINGS.get((Object)this);
        if (string == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                string = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception exception) {
                string = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... objectArray) {
        MessageFormat messageFormat = MESSAGES.get((Object)this);
        if (messageFormat == null) {
            if (RESOURCE_BUNDLE == null) {
                messageFormat = new MessageFormat(this.defaultText);
            } else {
                try {
                    messageFormat = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception exception) {
                    messageFormat = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, messageFormat);
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(objectArray);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("unboundid-ldapsdk-ldap");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = resourceBundle;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

