/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.StaticUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPSearchException
extends LDAPException {
    private static final long serialVersionUID = 350230437196125113L;
    private final SearchResult searchResult;

    public LDAPSearchException(ResultCode resultCode, String string) {
        super(resultCode, string);
        this.searchResult = new SearchResult(-1, resultCode, string, null, StaticUtils.NO_STRINGS, 0, 0, StaticUtils.NO_CONTROLS);
    }

    public LDAPSearchException(ResultCode resultCode, String string, Throwable throwable) {
        super(resultCode, string, throwable);
        this.searchResult = new SearchResult(-1, resultCode, string, null, StaticUtils.NO_STRINGS, 0, 0, StaticUtils.NO_CONTROLS);
    }

    public LDAPSearchException(LDAPException lDAPException) {
        super(lDAPException.getResultCode(), lDAPException.getMessage(), lDAPException.getMatchedDN(), lDAPException.getReferralURLs(), lDAPException.getResponseControls(), lDAPException);
        if (lDAPException instanceof LDAPSearchException) {
            LDAPSearchException lDAPSearchException = (LDAPSearchException)lDAPException;
            this.searchResult = lDAPSearchException.searchResult;
        } else {
            this.searchResult = new SearchResult(-1, lDAPException.getResultCode(), lDAPException.getMessage(), lDAPException.getMatchedDN(), lDAPException.getReferralURLs(), 0, 0, lDAPException.getResponseControls());
        }
    }

    public LDAPSearchException(SearchResult searchResult) {
        super(searchResult);
        this.searchResult = searchResult;
    }

    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    public int getEntryCount() {
        return this.searchResult.getEntryCount();
    }

    public int getReferenceCount() {
        return this.searchResult.getReferenceCount();
    }

    public List<SearchResultEntry> getSearchEntries() {
        return this.searchResult.getSearchEntries();
    }

    public List<SearchResultReference> getSearchReferences() {
        return this.searchResult.getSearchReferences();
    }

    @Override
    public SearchResult toLDAPResult() {
        return this.searchResult;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        Control[] controlArray;
        String[] stringArray;
        String string;
        stringBuilder.append("LDAPSearchException(resultCode=");
        stringBuilder.append(this.getResultCode());
        stringBuilder.append(", numEntries=");
        stringBuilder.append(this.searchResult.getEntryCount());
        stringBuilder.append(", numReferences=");
        stringBuilder.append(this.searchResult.getReferenceCount());
        String string2 = this.getMessage();
        if (string2 != null) {
            stringBuilder.append(", errorMessage='");
            stringBuilder.append(string2);
            stringBuilder.append('\'');
        }
        if ((string = this.getMatchedDN()) != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(string);
            stringBuilder.append('\'');
        }
        if ((stringArray = this.getReferralURLs()).length > 0) {
            stringBuilder.append(", referralURLs={");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(stringArray[i]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        if ((controlArray = this.getResponseControls()).length > 0) {
            stringBuilder.append(", responseControls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

