/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1BufferSet;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSet;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Modification
implements Serializable {
    private static final ASN1OctetString[] NO_VALUES = new ASN1OctetString[0];
    private static final byte[][] NO_BYTE_VALUES = new byte[0][];
    private static final long serialVersionUID = 5170107037390858876L;
    private final ASN1OctetString[] values;
    private final ModificationType modificationType;
    private final String attributeName;

    public Modification(ModificationType modificationType, String string) {
        Validator.ensureNotNull(string);
        this.modificationType = modificationType;
        this.attributeName = string;
        this.values = NO_VALUES;
    }

    public Modification(ModificationType modificationType, String string, String string2) {
        Validator.ensureNotNull(string, string2);
        this.modificationType = modificationType;
        this.attributeName = string;
        this.values = new ASN1OctetString[]{new ASN1OctetString(string2)};
    }

    public Modification(ModificationType modificationType, String string, byte[] byArray) {
        Validator.ensureNotNull(string, byArray);
        this.modificationType = modificationType;
        this.attributeName = string;
        this.values = new ASN1OctetString[]{new ASN1OctetString(byArray)};
    }

    public Modification(ModificationType modificationType, String string, String ... stringArray) {
        Validator.ensureNotNull(string, stringArray);
        this.modificationType = modificationType;
        this.attributeName = string;
        this.values = new ASN1OctetString[stringArray.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ASN1OctetString(stringArray[i]);
        }
    }

    public Modification(ModificationType modificationType, String string, byte[] ... byArray) {
        Validator.ensureNotNull(string, byArray);
        this.modificationType = modificationType;
        this.attributeName = string;
        this.values = new ASN1OctetString[byArray.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ASN1OctetString(byArray[i]);
        }
    }

    public Modification(ModificationType modificationType, String string, ASN1OctetString[] aSN1OctetStringArray) {
        this.modificationType = modificationType;
        this.attributeName = string;
        this.values = aSN1OctetStringArray;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public Attribute getAttribute() {
        return new Attribute(this.attributeName, (MatchingRule)CaseIgnoreStringMatchingRule.getInstance(), this.values);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean hasValue() {
        return this.values.length > 0;
    }

    public String[] getValues() {
        if (this.values.length == 0) {
            return StaticUtils.NO_STRINGS;
        }
        String[] stringArray = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringArray[i] = this.values[i].stringValue();
        }
        return stringArray;
    }

    public byte[][] getValueByteArrays() {
        if (this.values.length == 0) {
            return NO_BYTE_VALUES;
        }
        byte[][] byArrayArray = new byte[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            byArrayArray[i] = this.values[i].getValue();
        }
        return byArrayArray;
    }

    public ASN1OctetString[] getRawValues() {
        return this.values;
    }

    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence();
        aSN1Buffer.addEnumerated(this.modificationType.intValue());
        ASN1BufferSequence aSN1BufferSequence2 = aSN1Buffer.beginSequence();
        aSN1Buffer.addOctetString(this.attributeName);
        ASN1BufferSet aSN1BufferSet = aSN1Buffer.beginSet();
        for (ASN1OctetString aSN1OctetString : this.values) {
            aSN1Buffer.addElement(aSN1OctetString);
        }
        aSN1BufferSet.end();
        aSN1BufferSequence2.end();
        aSN1BufferSequence.end();
    }

    public ASN1Sequence encode() {
        ASN1Element[] aSN1ElementArray = new ASN1Element[]{new ASN1OctetString(this.attributeName), new ASN1Set(this.values)};
        ASN1Element[] aSN1ElementArray2 = new ASN1Element[]{new ASN1Enumerated(this.modificationType.intValue()), new ASN1Sequence(aSN1ElementArray)};
        return new ASN1Sequence(aSN1ElementArray2);
    }

    public static Modification readFrom(ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            Validator.ensureNotNull(aSN1StreamReader.beginSequence());
            ModificationType modificationType = ModificationType.valueOf(aSN1StreamReader.readEnumerated());
            Validator.ensureNotNull(aSN1StreamReader.beginSequence());
            String string = aSN1StreamReader.readString();
            ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>(5);
            ASN1StreamReaderSet aSN1StreamReaderSet = aSN1StreamReader.beginSet();
            while (aSN1StreamReaderSet.hasMoreElements()) {
                arrayList.add(new ASN1OctetString(aSN1StreamReader.readBytes()));
            }
            ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[arrayList.size()];
            arrayList.toArray(aSN1OctetStringArray);
            return new Modification(modificationType, string, aSN1OctetStringArray);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public static Modification decode(ASN1Sequence aSN1Sequence) throws LDAPException {
        ASN1Set aSN1Set;
        int n;
        ASN1Element aSN1Element;
        Validator.ensureNotNull(aSN1Sequence);
        ASN1Element[] aSN1ElementArray = aSN1Sequence.elements();
        if (aSN1ElementArray.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_INVALID_ELEMENT_COUNT.get(aSN1ElementArray.length));
        }
        try {
            aSN1Element = ASN1Enumerated.decodeAsEnumerated(aSN1ElementArray[0]);
            n = ((ASN1Enumerated)aSN1Element).intValue();
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_CANNOT_PARSE_MOD_TYPE.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
        }
        try {
            aSN1Element = ASN1Sequence.decodeAsSequence(aSN1ElementArray[1]);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_CANNOT_PARSE_ATTR.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
        }
        ASN1Element[] aSN1ElementArray2 = ((ASN1Sequence)aSN1Element).elements();
        if (aSN1ElementArray2.length != 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_INVALID_ATTR_ELEMENT_COUNT.get(aSN1ElementArray2.length));
        }
        String string = ASN1OctetString.decodeAsOctetString(aSN1ElementArray2[0]).stringValue();
        try {
            aSN1Set = ASN1Set.decodeAsSet(aSN1ElementArray2[1]);
        }
        catch (ASN1Exception aSN1Exception) {
            Debug.debugException(aSN1Exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_MOD_DECODE_CANNOT_PARSE_ATTR_VALUE_SET.get(StaticUtils.getExceptionMessage(aSN1Exception)), aSN1Exception);
        }
        ASN1Element[] aSN1ElementArray3 = aSN1Set.elements();
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1ElementArray3.length];
        for (int i = 0; i < aSN1OctetStringArray.length; ++i) {
            aSN1OctetStringArray[i] = ASN1OctetString.decodeAsOctetString(aSN1ElementArray3[i]);
        }
        return new Modification(ModificationType.valueOf(n), string, aSN1OctetStringArray);
    }

    public int hashCode() {
        int n = this.modificationType.intValue() + StaticUtils.toLowerCase(this.attributeName).hashCode();
        for (ASN1OctetString aSN1OctetString : this.values) {
            n += aSN1OctetString.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Modification)) {
            return false;
        }
        Modification modification = (Modification)object;
        if (this.modificationType != modification.modificationType) {
            return false;
        }
        if (!this.attributeName.equalsIgnoreCase(modification.attributeName)) {
            return false;
        }
        if (this.values.length != modification.values.length) {
            return false;
        }
        for (ASN1OctetString aSN1OctetString : this.values) {
            boolean bl = false;
            for (int i = 0; i < modification.values.length; ++i) {
                if (!aSN1OctetString.equalsIgnoreType(modification.values[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDAPModification(type=");
        switch (this.modificationType.intValue()) {
            case 0: {
                stringBuilder.append("add");
                break;
            }
            case 1: {
                stringBuilder.append("delete");
                break;
            }
            case 2: {
                stringBuilder.append("replace");
                break;
            }
            case 3: {
                stringBuilder.append("increment");
                break;
            }
            default: {
                stringBuilder.append(this.modificationType);
            }
        }
        stringBuilder.append(", attr=");
        stringBuilder.append(this.attributeName);
        if (this.values.length == 0) {
            stringBuilder.append(", values={");
        } else if (this.needsBase64Encoding()) {
            stringBuilder.append(", base64Values={'");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuilder.append("', '");
                }
                stringBuilder.append(Base64.encode(this.values[i].getValue()));
            }
            stringBuilder.append('\'');
        } else {
            stringBuilder.append(", values={'");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuilder.append("', '");
                }
                stringBuilder.append(this.values[i].stringValue());
            }
            stringBuilder.append('\'');
        }
        stringBuilder.append("})");
    }

    private boolean needsBase64Encoding() {
        for (ASN1OctetString aSN1OctetString : this.values) {
            if (!Attribute.needsBase64Encoding(aSN1OctetString.getValue())) continue;
            return true;
        }
        return false;
    }

    public void toCode(List<String> list, int n, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        String string3 = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append(string3);
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append("new Modification(");
        list.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append(string3);
        stringBuilder.append("     \"ModificationType.");
        stringBuilder.append(this.modificationType.getName());
        stringBuilder.append(',');
        list.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append(string3);
        stringBuilder.append("     \"");
        stringBuilder.append(this.attributeName);
        stringBuilder.append('\"');
        if (this.values.length > 0) {
            ASN1OctetString[] aSN1OctetStringArray;
            boolean bl = true;
            if (StaticUtils.isSensitiveToCodeAttribute(this.attributeName)) {
                aSN1OctetStringArray = new ASN1OctetString[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    aSN1OctetStringArray[i] = new ASN1OctetString("---redacted-value-" + (i + 1) + "---");
                }
            } else {
                aSN1OctetStringArray = this.values;
                for (ASN1OctetString aSN1OctetString : this.values) {
                    if (StaticUtils.isPrintableString(aSN1OctetString.getValue())) continue;
                    bl = false;
                    break;
                }
            }
            for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray) {
                stringBuilder.append(',');
                list.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append(string3);
                stringBuilder.append("     ");
                if (bl) {
                    stringBuilder.append('\"');
                    stringBuilder.append(aSN1OctetString.stringValue());
                    stringBuilder.append('\"');
                    continue;
                }
                StaticUtils.byteArrayToCode(aSN1OctetString.getValue(), stringBuilder);
            }
        }
        stringBuilder.append(')');
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        list.add(stringBuilder.toString());
    }
}

