/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import java.io.Serializable;
import java.util.HashMap;

public final class ModificationType
implements Serializable {
    public static final int ADD_INT_VALUE = 0;
    public static final ModificationType ADD = new ModificationType("ADD", 0);
    public static final int DELETE_INT_VALUE = 1;
    public static final ModificationType DELETE = new ModificationType("DELETE", 1);
    public static final int REPLACE_INT_VALUE = 2;
    public static final ModificationType REPLACE = new ModificationType("REPLACE", 2);
    public static final int INCREMENT_INT_VALUE = 3;
    public static final ModificationType INCREMENT = new ModificationType("INCREMENT", 3);
    private static final HashMap<Integer, ModificationType> UNDEFINED_MOD_TYPES = new HashMap();
    private static final long serialVersionUID = -7863114394728980308L;
    private final int intValue;
    private final String name;

    private ModificationType(int n) {
        this.intValue = n;
        this.name = String.valueOf(n);
    }

    private ModificationType(String string, int n) {
        this.name = string;
        this.intValue = n;
    }

    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModificationType valueOf(int n) {
        switch (n) {
            case 0: {
                return ADD;
            }
            case 1: {
                return DELETE;
            }
            case 2: {
                return REPLACE;
            }
            case 3: {
                return INCREMENT;
            }
        }
        HashMap<Integer, ModificationType> hashMap = UNDEFINED_MOD_TYPES;
        synchronized (hashMap) {
            ModificationType modificationType = UNDEFINED_MOD_TYPES.get(n);
            if (modificationType == null) {
                modificationType = new ModificationType(n);
                UNDEFINED_MOD_TYPES.put(n, modificationType);
            }
            return modificationType;
        }
    }

    public static ModificationType definedValueOf(int n) {
        switch (n) {
            case 0: {
                return ADD;
            }
            case 1: {
                return DELETE;
            }
            case 2: {
                return REPLACE;
            }
            case 3: {
                return INCREMENT;
            }
        }
        return null;
    }

    public static ModificationType[] values() {
        return new ModificationType[]{ADD, DELETE, REPLACE, INCREMENT};
    }

    public int hashCode() {
        return this.intValue;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ModificationType) {
            return this.intValue == ((ModificationType)object).intValue;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

