/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncHelper;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.ldap.sdk.UpdatableLDAPRequest;
import com.unboundid.ldif.LDIFModifyDNChangeRecord;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModifyDNRequest
extends UpdatableLDAPRequest
implements ReadOnlyModifyDNRequest,
ResponseAcceptor,
ProtocolOp {
    private static final byte NEW_SUPERIOR_TYPE = -128;
    private static final long serialVersionUID = -2325552729975091008L;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private boolean deleteOldRDN;
    private int messageID = -1;
    private String dn;
    private String newRDN;
    private String newSuperiorDN;

    public ModifyDNRequest(String string, String string2, boolean bl) {
        super(null);
        Validator.ensureNotNull(string, string2);
        this.dn = string;
        this.newRDN = string2;
        this.deleteOldRDN = bl;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(DN dN, RDN rDN, boolean bl) {
        super(null);
        Validator.ensureNotNull(dN, rDN);
        this.dn = dN.toString();
        this.newRDN = rDN.toString();
        this.deleteOldRDN = bl;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(String string, String string2, boolean bl, String string3) {
        super(null);
        Validator.ensureNotNull(string, string2);
        this.dn = string;
        this.newRDN = string2;
        this.deleteOldRDN = bl;
        this.newSuperiorDN = string3;
    }

    public ModifyDNRequest(DN dN, RDN rDN, boolean bl, DN dN2) {
        super(null);
        Validator.ensureNotNull(dN, rDN);
        this.dn = dN.toString();
        this.newRDN = rDN.toString();
        this.deleteOldRDN = bl;
        this.newSuperiorDN = dN2 == null ? null : dN2.toString();
    }

    public ModifyDNRequest(String string, String string2, boolean bl, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, string2);
        this.dn = string;
        this.newRDN = string2;
        this.deleteOldRDN = bl;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(DN dN, RDN rDN, boolean bl, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, rDN);
        this.dn = dN.toString();
        this.newRDN = rDN.toString();
        this.deleteOldRDN = bl;
        this.newSuperiorDN = null;
    }

    public ModifyDNRequest(String string, String string2, boolean bl, String string3, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(string, string2);
        this.dn = string;
        this.newRDN = string2;
        this.deleteOldRDN = bl;
        this.newSuperiorDN = string3;
    }

    public ModifyDNRequest(DN dN, RDN rDN, boolean bl, DN dN2, Control[] controlArray) {
        super(controlArray);
        Validator.ensureNotNull(dN, rDN);
        this.dn = dN.toString();
        this.newRDN = rDN.toString();
        this.deleteOldRDN = bl;
        this.newSuperiorDN = dN2 == null ? null : dN2.toString();
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public void setDN(String string) {
        Validator.ensureNotNull(string);
        this.dn = string;
    }

    public void setDN(DN dN) {
        Validator.ensureNotNull(dN);
        this.dn = dN.toString();
    }

    @Override
    public String getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(String string) {
        Validator.ensureNotNull(string);
        this.newRDN = string;
    }

    public void setNewRDN(RDN rDN) {
        Validator.ensureNotNull(rDN);
        this.newRDN = rDN.toString();
    }

    @Override
    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean bl) {
        this.deleteOldRDN = bl;
    }

    @Override
    public String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public void setNewSuperiorDN(String string) {
        this.newSuperiorDN = string;
    }

    public void setNewSuperiorDN(DN dN) {
        this.newSuperiorDN = dN == null ? null : dN.toString();
    }

    @Override
    public byte getProtocolOpType() {
        return 108;
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)108);
        aSN1Buffer.addOctetString(this.dn);
        aSN1Buffer.addOctetString(this.newRDN);
        aSN1Buffer.addBoolean(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            aSN1Buffer.addOctetString((byte)-128, this.newSuperiorDN);
        }
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ASN1Element[] aSN1ElementArray = this.newSuperiorDN == null ? new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN)} : new ASN1Element[]{new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN), new ASN1OctetString(-128, this.newSuperiorDN)};
        return new ASN1Sequence(108, aSN1ElementArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LDAPResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            boolean bl = lDAPConnection.getConnectionOptions().autoReconnect();
            return this.processSync(lDAPConnection, n, bl);
        }
        long l = System.nanoTime();
        this.processAsync(lDAPConnection, null);
        try {
            LDAPResponse lDAPResponse;
            try {
                long l2 = this.getResponseTimeoutMillis(lDAPConnection);
                lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_MODDN_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            LDAPResult lDAPResult = this.handleResponse(lDAPConnection, lDAPResponse, l, n, false);
            return lDAPResult;
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
        }
    }

    AsyncRequestID processAsync(LDAPConnection lDAPConnection, AsyncResultListener asyncResultListener) throws LDAPException {
        AsyncRequestID asyncRequestID;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        if (asyncResultListener == null) {
            asyncRequestID = null;
            lDAPConnection.registerResponseAcceptor(this.messageID, this);
        } else {
            AsyncHelper asyncHelper = new AsyncHelper(lDAPConnection, OperationType.MODIFY_DN, this.messageID, asyncResultListener, this.getIntermediateResponseListener());
            lDAPConnection.registerResponseAcceptor(this.messageID, asyncHelper);
            asyncRequestID = asyncHelper.getAsyncRequestID();
            long l = this.getResponseTimeoutMillis(lDAPConnection);
            if (l > 0L) {
                Timer timer = lDAPConnection.getTimer();
                AsyncTimeoutTimerTask asyncTimeoutTimerTask = new AsyncTimeoutTimerTask(asyncHelper);
                timer.schedule((TimerTask)asyncTimeoutTimerTask, l);
                asyncRequestID.setTimerTask(asyncTimeoutTimerTask);
            }
        }
        try {
            Debug.debugLDAPRequest(this);
            lDAPConnection.getConnectionStatistics().incrementNumModifyDNRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            return asyncRequestID;
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
            throw lDAPException;
        }
    }

    private LDAPResult processSync(LDAPConnection lDAPConnection, int n, boolean bl) throws LDAPException {
        LDAPResponse lDAPResponse;
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(lDAPConnection));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        long l = System.nanoTime();
        Debug.debugLDAPRequest(this);
        lDAPConnection.getConnectionStatistics().incrementNumModifyDNRequests();
        try {
            lDAPConnection.sendMessage(lDAPMessage);
        }
        catch (LDAPException lDAPException) {
            LDAPResult lDAPResult;
            Debug.debugException(lDAPException);
            if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                return lDAPResult;
            }
            throw lDAPException;
        }
        while (true) {
            try {
                lDAPResponse = lDAPConnection.readResponse(this.messageID);
            }
            catch (LDAPException lDAPException) {
                LDAPResult lDAPResult;
                Debug.debugException(lDAPException);
                if (lDAPException.getResultCode() == ResultCode.TIMEOUT && lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                    lDAPConnection.abandon(this.messageID, new Control[0]);
                }
                if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPException.getResultCode())) != null) {
                    return lDAPResult;
                }
                throw lDAPException;
            }
            if (!(lDAPResponse instanceof IntermediateResponse)) break;
            IntermediateResponseListener intermediateResponseListener = this.getIntermediateResponseListener();
            if (intermediateResponseListener == null) continue;
            intermediateResponseListener.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l, n, bl);
    }

    private LDAPResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l, int n, boolean bl) throws LDAPException {
        LDAPResult lDAPResult;
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            if (lDAPConnection.getConnectionOptions().abandonOnTimeout()) {
                lDAPConnection.abandon(this.messageID, new Control[0]);
            }
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_MODIFY_DN_CLIENT_TIMEOUT.get(l2, this.messageID, this.dn, lDAPConnection.getHostPort()));
        }
        lDAPConnection.getConnectionStatistics().incrementNumModifyDNResponses(System.nanoTime() - l);
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            Serializable serializable;
            if (bl && (serializable = this.reconnectAndRetry(lDAPConnection, n, ResultCode.SERVER_DOWN)) != null) {
                return serializable;
            }
            serializable = (ConnectionClosedResponse)lDAPResponse;
            String string = ((ConnectionClosedResponse)serializable).getMessage();
            if (string == null) {
                throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_DN_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_MODIFY_DN_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        LDAPResult lDAPResult2 = (LDAPResult)lDAPResponse;
        if (lDAPResult2.getResultCode().equals(ResultCode.REFERRAL) && this.followReferrals(lDAPConnection)) {
            if (n >= lDAPConnection.getConnectionOptions().getReferralHopLimit()) {
                return new LDAPResult(this.messageID, ResultCode.REFERRAL_LIMIT_EXCEEDED, LDAPMessages.ERR_TOO_MANY_REFERRALS.get(), lDAPResult2.getMatchedDN(), lDAPResult2.getReferralURLs(), lDAPResult2.getResponseControls());
            }
            return this.followReferral(lDAPResult2, lDAPConnection, n);
        }
        if (bl && (lDAPResult = this.reconnectAndRetry(lDAPConnection, n, lDAPResult2.getResultCode())) != null) {
            return lDAPResult;
        }
        return lDAPResult2;
    }

    private LDAPResult reconnectAndRetry(LDAPConnection lDAPConnection, int n, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    lDAPConnection.reconnect();
                    return this.processSync(lDAPConnection, n, false);
                }
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPResult followReferral(LDAPResult lDAPResult, LDAPConnection lDAPConnection, int n) throws LDAPException {
        for (String string : lDAPResult.getReferralURLs()) {
            LDAPURL lDAPURL = new LDAPURL(string);
            String string2 = lDAPURL.getHost();
            if (string2 == null) continue;
            ModifyDNRequest modifyDNRequest = lDAPURL.baseDNProvided() ? new ModifyDNRequest(lDAPURL.getBaseDN().toString(), this.newRDN, this.deleteOldRDN, this.newSuperiorDN, this.getControls()) : this;
            LDAPConnection lDAPConnection2 = lDAPConnection.getReferralConnector().getReferralConnection(lDAPURL, lDAPConnection);
            try {
                LDAPResult lDAPResult2 = modifyDNRequest.process(lDAPConnection2, n + 1);
                lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                lDAPConnection2.close();
                return lDAPResult2;
            }
            catch (Throwable throwable) {
                try {
                    lDAPConnection2.setDisconnectInfo(DisconnectType.REFERRAL, null, null);
                    lDAPConnection2.close();
                    throw throwable;
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
        }
        return lDAPResult;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.MODIFY_DN;
    }

    @Override
    public ModifyDNRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public ModifyDNRequest duplicate(Control[] controlArray) {
        ModifyDNRequest modifyDNRequest = new ModifyDNRequest(this.dn, this.newRDN, this.deleteOldRDN, this.newSuperiorDN, controlArray);
        if (this.followReferralsInternal() != null) {
            modifyDNRequest.setFollowReferrals(this.followReferralsInternal());
        }
        modifyDNRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return modifyDNRequest;
    }

    @Override
    public LDIFModifyDNChangeRecord toLDIFChangeRecord() {
        return new LDIFModifyDNChangeRecord(this);
    }

    @Override
    public String[] toLDIF() {
        return this.toLDIFChangeRecord().toLDIF();
    }

    @Override
    public String toLDIFString() {
        return this.toLDIFChangeRecord().toLDIFString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        Control[] controlArray;
        stringBuilder.append("ModifyDNRequest(dn='");
        stringBuilder.append(this.dn);
        stringBuilder.append("', newRDN='");
        stringBuilder.append(this.newRDN);
        stringBuilder.append("', deleteOldRDN=");
        stringBuilder.append(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            stringBuilder.append(", newSuperiorDN='");
            stringBuilder.append(this.newSuperiorDN);
            stringBuilder.append('\'');
        }
        if ((controlArray = this.getControls()).length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(4);
        arrayList.add(ToCodeArgHelper.createString(this.dn, "Current DN"));
        arrayList.add(ToCodeArgHelper.createString(this.newRDN, "New RDN"));
        arrayList.add(ToCodeArgHelper.createBoolean(this.deleteOldRDN, "Delete Old RDN Value(s)"));
        if (this.newSuperiorDN != null) {
            arrayList.add(ToCodeArgHelper.createString(this.newSuperiorDN, "New Superior Entry DN"));
        }
        ToCodeHelper.generateMethodCall(list, n, "ModifyDNRequest", string + "Request", "new ModifyDNRequest", arrayList);
        for (Control control : this.getControls()) {
            ToCodeHelper.generateMethodCall(list, n, null, null, string + "Request.addControl", ToCodeArgHelper.createControl(control, null));
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string2 = stringBuilder.toString();
            list.add("");
            list.add(string2 + "try");
            list.add(string2 + '{');
            list.add(string2 + "  LDAPResult " + string + "Result = connection.modifyDN(" + string + "Request);");
            list.add(string2 + "  // The modify DN was processed successfully.");
            list.add(string2 + '}');
            list.add(string2 + "catch (LDAPException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The modify DN failed.  Maybe the following " + "will help explain why.");
            list.add(string2 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string2 + "  String message = e.getMessage();");
            list.add(string2 + "  String matchedDN = e.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string2 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string2 + '}');
        }
    }
}

