/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.ParallelPoolCloserTask;
import com.unboundid.util.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParallelPoolCloser {
    private final boolean unbind;
    private final Collection<LDAPConnection> connections;
    private final int numThreads;

    ParallelPoolCloser(Collection<LDAPConnection> collection, boolean bl, int n) {
        this.connections = collection;
        this.unbind = bl;
        this.numThreads = n;
    }

    void closeConnections() {
        int n = this.connections.size();
        ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(n);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 0L, TimeUnit.MILLISECONDS, arrayBlockingQueue);
        ArrayList arrayList = new ArrayList(n);
        for (LDAPConnection object : this.connections) {
            arrayList.add(threadPoolExecutor.submit(new ParallelPoolCloserTask(object, this.unbind)));
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        threadPoolExecutor.shutdown();
    }
}

