/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ParallelPoolConnectorTask;
import com.unboundid.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParallelPoolConnector {
    private final boolean throwOnConnectFailure;
    private final int numConnections;
    private final int numThreads;
    private final LDAPConnectionPool pool;
    private final List<LDAPConnection> connList;

    ParallelPoolConnector(LDAPConnectionPool lDAPConnectionPool, List<LDAPConnection> list, int n, int n2, boolean bl) {
        this.pool = lDAPConnectionPool;
        this.connList = list;
        this.numConnections = n;
        this.numThreads = n2;
        this.throwOnConnectFailure = bl;
    }

    void establishConnections() throws LDAPException {
        ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(this.numConnections);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 0L, TimeUnit.MILLISECONDS, arrayBlockingQueue);
        AtomicReference<LDAPException> atomicReference = new AtomicReference<LDAPException>();
        ArrayList arrayList = new ArrayList(this.numConnections);
        for (int i = 0; i < this.numConnections; ++i) {
            arrayList.add(threadPoolExecutor.submit(new ParallelPoolConnectorTask(this.pool, this.connList, atomicReference, this.throwOnConnectFailure)));
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Future future = (Future)object.next();
            try {
                future.get();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        threadPoolExecutor.shutdown();
        if (this.throwOnConnectFailure && (object = atomicReference.get()) != null) {
            for (LDAPConnection lDAPConnection : this.connList) {
                lDAPConnection.terminate(null);
            }
            this.connList.clear();
            throw object;
        }
    }
}

