/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParallelPoolConnectorTask
implements Runnable {
    private final AtomicReference<LDAPException> firstException;
    private final boolean throwOnConnectFailure;
    private final LDAPConnectionPool pool;
    private final List<LDAPConnection> connList;

    ParallelPoolConnectorTask(LDAPConnectionPool lDAPConnectionPool, List<LDAPConnection> list, AtomicReference<LDAPException> atomicReference, boolean bl) {
        this.pool = lDAPConnectionPool;
        this.connList = list;
        this.firstException = atomicReference;
        this.throwOnConnectFailure = bl;
    }

    @Override
    public void run() {
        block3: {
            try {
                if (this.throwOnConnectFailure && this.firstException.get() != null) {
                    return;
                }
                this.connList.add(this.pool.createConnection());
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                if (!this.throwOnConnectFailure) break block3;
                this.firstException.compareAndSet(null, lDAPException);
            }
        }
    }
}

