/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RDN
implements Comparable<RDN>,
Comparator<RDN>,
Serializable {
    private static final long serialVersionUID = 2923419812807188487L;
    private final ASN1OctetString[] attributeValues;
    private final Schema schema;
    private volatile String normalizedString;
    private volatile String rdnString;
    private final String[] attributeNames;

    public RDN(String string, String string2) {
        this(string, string2, null);
    }

    public RDN(String string, String string2, Schema schema) {
        Validator.ensureNotNull(string, string2);
        this.schema = schema;
        this.attributeNames = new String[]{string};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(string2)};
    }

    public RDN(String string, byte[] byArray) {
        this(string, byArray, null);
    }

    public RDN(String string, byte[] byArray, Schema schema) {
        Validator.ensureNotNull(string, byArray);
        this.schema = schema;
        this.attributeNames = new String[]{string};
        this.attributeValues = new ASN1OctetString[]{new ASN1OctetString(byArray)};
    }

    public RDN(String[] stringArray, String[] stringArray2) {
        this(stringArray, stringArray2, null);
    }

    public RDN(String[] stringArray, String[] stringArray2, Schema schema) {
        Validator.ensureNotNull(stringArray, stringArray2);
        Validator.ensureTrue(stringArray.length == stringArray2.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(stringArray.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = stringArray;
        this.schema = schema;
        this.attributeValues = new ASN1OctetString[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(stringArray2[i]);
        }
    }

    public RDN(String[] stringArray, byte[][] byArray) {
        this(stringArray, byArray, null);
    }

    public RDN(String[] stringArray, byte[][] byArray, Schema schema) {
        Validator.ensureNotNull(stringArray, byArray);
        Validator.ensureTrue(stringArray.length == byArray.length, "RDN.attributeNames and attributeValues must be the same size.");
        Validator.ensureTrue(stringArray.length > 0, "RDN.attributeNames must not be empty.");
        this.attributeNames = stringArray;
        this.schema = schema;
        this.attributeValues = new ASN1OctetString[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.attributeValues[i] = new ASN1OctetString(byArray[i]);
        }
    }

    RDN(String string, ASN1OctetString aSN1OctetString, Schema schema, String string2) {
        this.rdnString = string2;
        this.schema = schema;
        this.attributeNames = new String[]{string};
        this.attributeValues = new ASN1OctetString[]{aSN1OctetString};
    }

    RDN(String[] stringArray, ASN1OctetString[] aSN1OctetStringArray, Schema schema, String string) {
        this.rdnString = string;
        this.schema = schema;
        this.attributeNames = stringArray;
        this.attributeValues = aSN1OctetStringArray;
    }

    public RDN(String string) throws LDAPException {
        this(string, (Schema)null);
    }

    public RDN(String string, Schema schema) throws LDAPException {
        int n;
        ArrayList<String> arrayList;
        ASN1OctetString aSN1OctetString;
        char c;
        int n2;
        Validator.ensureNotNull(string);
        this.rdnString = string;
        this.schema = schema;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        int n4 = n2;
        while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '=') {
            ++n2;
        }
        String string2 = string.substring(n4, n2);
        if (string2.length() == 0) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get());
        }
        while (n2 < n3 && string.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 >= n3 || string.charAt(n2) != '=') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(string2));
        }
        ++n2;
        while (n2 < n3 && string.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 >= n3) {
            aSN1OctetString = new ASN1OctetString();
        } else if (string.charAt(n2) == '#') {
            arrayList = (ArrayList<String>)RDN.readHexString(string, ++n2);
            aSN1OctetString = new ASN1OctetString((byte[])arrayList);
            n2 += ((ArrayList<E>)arrayList).length * 2;
        } else {
            arrayList = new StringBuilder();
            n2 = RDN.readValueString(string, n2, (StringBuilder)((Object)arrayList));
            aSN1OctetString = new ASN1OctetString(((StringBuilder)((Object)arrayList)).toString());
        }
        while (n2 < n3 && string.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 >= n3) {
            this.attributeNames = new String[]{string2};
            this.attributeValues = new ASN1OctetString[]{aSN1OctetString};
            return;
        }
        arrayList = new ArrayList<String>(5);
        ArrayList<ASN1OctetString> arrayList2 = new ArrayList<ASN1OctetString>(5);
        arrayList.add(string2);
        arrayList2.add(aSN1OctetString);
        if (string.charAt(n2) != '+') {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get());
        }
        if (++n2 >= n3) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get());
        }
        int n5 = 1;
        while (n2 < n3) {
            while (n2 < n3 && string.charAt(n2) == ' ') {
                ++n2;
            }
            n4 = n2;
            while (n2 < n3 && (n = string.charAt(n2)) != 32 && n != 61) {
                ++n2;
            }
            string2 = string.substring(n4, n2);
            if (string2.length() == 0) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_ATTR_NAME.get());
            }
            while (n2 < n3 && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n3 || string.charAt(n2) != '=') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_NO_EQUAL_SIGN.get(string2));
            }
            ++n2;
            while (n2 < n3 && string.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n3) {
                aSN1OctetString = new ASN1OctetString();
            } else if (string.charAt(n2) == '#') {
                byte[] byArray = RDN.readHexString(string, ++n2);
                aSN1OctetString = new ASN1OctetString(byArray);
                n2 += byArray.length * 2;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                n2 = RDN.readValueString(string, n2, stringBuilder);
                aSN1OctetString = new ASN1OctetString(stringBuilder.toString());
            }
            while (n2 < n3 && string.charAt(n2) == ' ') {
                ++n2;
            }
            arrayList.add(string2);
            arrayList2.add(aSN1OctetString);
            ++n5;
            if (n2 >= n3) break;
            if (string.charAt(n2) != '+') {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_VALUE_NOT_FOLLOWED_BY_PLUS.get());
            }
            if (++n2 < n3) continue;
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_PLUS_NOT_FOLLOWED_BY_AVP.get());
        }
        this.attributeNames = new String[n5];
        this.attributeValues = new ASN1OctetString[n5];
        for (n = 0; n < n5; ++n) {
            this.attributeNames[n] = (String)arrayList.get(n);
            this.attributeValues[n] = (ASN1OctetString)arrayList2.get(n);
        }
    }

    static byte[] readHexString(String string, int n) throws LDAPException {
        int n2 = string.length();
        int n3 = n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 - n3);
        block37: while (n3 < n2) {
            byte by;
            switch (string.charAt(n3++)) {
                case '0': {
                    by = 0;
                    break;
                }
                case '1': {
                    by = 16;
                    break;
                }
                case '2': {
                    by = 32;
                    break;
                }
                case '3': {
                    by = 48;
                    break;
                }
                case '4': {
                    by = 64;
                    break;
                }
                case '5': {
                    by = 80;
                    break;
                }
                case '6': {
                    by = 96;
                    break;
                }
                case '7': {
                    by = 112;
                    break;
                }
                case '8': {
                    by = -128;
                    break;
                }
                case '9': {
                    by = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    by = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    by = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    by = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    by = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    by = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    by = -16;
                    break;
                }
                case ' ': 
                case '+': 
                case ',': 
                case ';': {
                    break block37;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n3 - 1)), n3 - 1));
                }
            }
            if (n3 >= n2) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get());
            }
            switch (string.charAt(n3++)) {
                case '0': {
                    break;
                }
                case '1': {
                    by = (byte)(by | 1);
                    break;
                }
                case '2': {
                    by = (byte)(by | 2);
                    break;
                }
                case '3': {
                    by = (byte)(by | 3);
                    break;
                }
                case '4': {
                    by = (byte)(by | 4);
                    break;
                }
                case '5': {
                    by = (byte)(by | 5);
                    break;
                }
                case '6': {
                    by = (byte)(by | 6);
                    break;
                }
                case '7': {
                    by = (byte)(by | 7);
                    break;
                }
                case '8': {
                    by = (byte)(by | 8);
                    break;
                }
                case '9': {
                    by = (byte)(by | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    by = (byte)(by | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    by = (byte)(by | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    by = (byte)(by | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    by = (byte)(by | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    by = (byte)(by | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    by = (byte)(by | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n3 - 1)), n3 - 1));
                }
            }
            byteBuffer.put(by);
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    static int readValueString(String string, int n, StringBuilder stringBuilder) throws LDAPException {
        char c;
        int n2;
        int n3 = stringBuilder.length();
        int n4 = string.length();
        boolean bl = false;
        block6: for (n2 = n; n2 < n4; ++n2) {
            c = string.charAt(n2);
            switch (c) {
                case '\\': {
                    if (n2 + 1 >= n4) {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_ENDS_WITH_BACKSLASH.get());
                    }
                    if (StaticUtils.isHex(c = string.charAt(++n2))) {
                        n2 = RDN.readEscapedHexString(string, n2, stringBuilder) - 1;
                        continue block6;
                    }
                    stringBuilder.append(c);
                    continue block6;
                }
                case '\"': {
                    if (bl) {
                        ++n2;
                        while (n2 < n4 && (c = string.charAt(n2)) != '+' && c != ',' && c != ';') {
                            if (c != ' ') {
                                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_CHAR_OUTSIDE_QUOTES.get(Character.valueOf(c), n2 - 1));
                            }
                            ++n2;
                        }
                        bl = false;
                        break block6;
                    }
                    if (n2 == n) {
                        bl = true;
                        continue block6;
                    }
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNEXPECTED_DOUBLE_QUOTE.get(n2));
                }
                case ' ': {
                    if (!bl && (n2 + 1 >= n4 || string.charAt(n2 + 1) == ' ')) continue block6;
                    stringBuilder.append(' ');
                    continue block6;
                }
                case '+': 
                case ',': 
                case ';': {
                    if (!bl) break block6;
                    stringBuilder.append(c);
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (bl) {
            throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_UNCLOSED_DOUBLE_QUOTE.get());
        }
        c = stringBuilder.length() - 1;
        int n5 = n2 - 2;
        while (c > '\u0000' && stringBuilder.charAt(c) == ' ' && string.charAt(n5) != '\\') {
            stringBuilder.deleteCharAt(c--);
            --n5;
        }
        return n2;
    }

    private static int readEscapedHexString(String string, int n, StringBuilder stringBuilder) throws LDAPException {
        int n2;
        int n3 = string.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 - n2);
        for (n2 = n; n2 < n3; ++n2) {
            byte by;
            switch (string.charAt(n2++)) {
                case '0': {
                    by = 0;
                    break;
                }
                case '1': {
                    by = 16;
                    break;
                }
                case '2': {
                    by = 32;
                    break;
                }
                case '3': {
                    by = 48;
                    break;
                }
                case '4': {
                    by = 64;
                    break;
                }
                case '5': {
                    by = 80;
                    break;
                }
                case '6': {
                    by = 96;
                    break;
                }
                case '7': {
                    by = 112;
                    break;
                }
                case '8': {
                    by = -128;
                    break;
                }
                case '9': {
                    by = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    by = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    by = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    by = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    by = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    by = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    by = -16;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n2 - 1)), n2 - 1));
                }
            }
            if (n2 >= n3) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_MISSING_HEX_CHAR.get());
            }
            switch (string.charAt(n2++)) {
                case '0': {
                    break;
                }
                case '1': {
                    by = (byte)(by | 1);
                    break;
                }
                case '2': {
                    by = (byte)(by | 2);
                    break;
                }
                case '3': {
                    by = (byte)(by | 3);
                    break;
                }
                case '4': {
                    by = (byte)(by | 4);
                    break;
                }
                case '5': {
                    by = (byte)(by | 5);
                    break;
                }
                case '6': {
                    by = (byte)(by | 6);
                    break;
                }
                case '7': {
                    by = (byte)(by | 7);
                    break;
                }
                case '8': {
                    by = (byte)(by | 8);
                    break;
                }
                case '9': {
                    by = (byte)(by | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    by = (byte)(by | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    by = (byte)(by | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    by = (byte)(by | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    by = (byte)(by | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    by = (byte)(by | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    by = (byte)(by | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, LDAPMessages.ERR_RDN_INVALID_HEX_CHAR.get(Character.valueOf(string.charAt(n2 - 1)), n2 - 1));
                }
            }
            byteBuffer.put(by);
            if (n2 + 1 >= n3 || string.charAt(n2) != '\\' || !StaticUtils.isHex(string.charAt(n2 + 1))) break;
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        try {
            stringBuilder.append(StaticUtils.toUTF8String(byArray));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            stringBuilder.append(new String(byArray));
        }
        return n2;
    }

    public static boolean isValidRDN(String string) {
        try {
            new RDN(string);
            return true;
        }
        catch (LDAPException lDAPException) {
            return false;
        }
    }

    public boolean isMultiValued() {
        return this.attributeNames.length != 1;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public String[] getAttributeValues() {
        String[] stringArray = new String[this.attributeValues.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.attributeValues[i].stringValue();
        }
        return stringArray;
    }

    public byte[][] getByteArrayAttributeValues() {
        byte[][] byArrayArray = new byte[this.attributeValues.length][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = this.attributeValues[i].getValue();
        }
        return byArrayArray;
    }

    Schema getSchema() {
        return this.schema;
    }

    public boolean hasAttribute(String string) {
        for (String string2 : this.attributeNames) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String string, String string2) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equalsIgnoreCase(string)) continue;
            Attribute attribute = new Attribute(string, this.schema, string2);
            Attribute attribute2 = new Attribute(string, this.schema, this.attributeValues[i].stringValue());
            if (!attribute.equals(attribute2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String string, byte[] byArray) {
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (!this.attributeNames[i].equalsIgnoreCase(string)) continue;
            Attribute attribute = new Attribute(string, this.schema, (byte[][])new byte[][]{byArray});
            Attribute attribute2 = new Attribute(string, this.schema, (byte[][])new byte[][]{this.attributeValues[i].getValue()});
            if (!attribute.equals(attribute2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.rdnString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder, false);
            this.rdnString = stringBuilder.toString();
        }
        return this.rdnString;
    }

    public String toMinimallyEncodedString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        this.toString(stringBuilder, false);
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        if (this.rdnString != null && !bl) {
            stringBuilder.append(this.rdnString);
            return;
        }
        for (int i = 0; i < this.attributeNames.length; ++i) {
            if (i > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(this.attributeNames[i]);
            stringBuilder.append('=');
            String string = this.attributeValues[i].stringValue();
            int n = string.length();
            block6: for (int j = 0; j < n; ++j) {
                char c = string.charAt(j);
                switch (c) {
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                        continue block6;
                    }
                    case ' ': {
                        if (j == 0 || j + 1 == n || j + 1 < n && string.charAt(j + 1) == ' ') {
                            stringBuilder.append("\\ ");
                            continue block6;
                        }
                        stringBuilder.append(' ');
                        continue block6;
                    }
                    case '\u0000': {
                        stringBuilder.append("\\00");
                        continue block6;
                    }
                    default: {
                        if (!(bl || c >= ' ' && c <= '~')) {
                            StaticUtils.hexEncode(c, stringBuilder);
                            continue block6;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toNormalizedString(stringBuilder);
            this.normalizedString = stringBuilder.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder stringBuilder) {
        if (this.attributeNames.length == 1) {
            String string = this.normalizeAttrName(this.attributeNames[0]);
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append((CharSequence)this.normalizeValue(string, this.attributeValues[0]));
        } else {
            int n;
            TreeMap<Object, ASN1OctetString> treeMap = new TreeMap<Object, ASN1OctetString>();
            for (n = 0; n < this.attributeNames.length; ++n) {
                String string = this.normalizeAttrName(this.attributeNames[n]);
                treeMap.put(string, this.attributeValues[n]);
            }
            n = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                if (n++ > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append((CharSequence)this.normalizeValue((String)entry.getKey(), (ASN1OctetString)entry.getValue()));
            }
        }
    }

    private String normalizeAttrName(String string) {
        AttributeTypeDefinition attributeTypeDefinition;
        String string2 = string;
        if (this.schema != null && (attributeTypeDefinition = this.schema.getAttributeType(string)) != null) {
            string2 = attributeTypeDefinition.getNameOrOID();
        }
        return StaticUtils.toLowerCase(string2);
    }

    public static String normalize(String string) throws LDAPException {
        return RDN.normalize(string, null);
    }

    public static String normalize(String string, Schema schema) throws LDAPException {
        return new RDN(string, schema).toNormalizedString();
    }

    private StringBuilder normalizeValue(String string, ASN1OctetString aSN1OctetString) {
        ASN1OctetString aSN1OctetString2;
        MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(string, this.schema);
        try {
            aSN1OctetString2 = matchingRule.normalize(aSN1OctetString);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            aSN1OctetString2 = new ASN1OctetString(StaticUtils.toLowerCase(aSN1OctetString.stringValue()));
        }
        String string2 = aSN1OctetString2.stringValue();
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block6: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block6;
                }
                case ' ': {
                    if (i == 0 || i + 1 == n || i + 1 < n && string2.charAt(i + 1) == ' ') {
                        stringBuilder.append("\\ ");
                        continue block6;
                    }
                    stringBuilder.append(' ');
                    continue block6;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        StaticUtils.hexEncode(c, stringBuilder);
                        continue block6;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder;
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        return this.toNormalizedString().equals(rDN.toNormalizedString());
    }

    public boolean equals(String string) throws LDAPException {
        if (string == null) {
            return false;
        }
        return this.equals(new RDN(string, this.schema));
    }

    public static boolean equals(String string, String string2) throws LDAPException {
        return new RDN(string).equals(new RDN(string2));
    }

    @Override
    public int compareTo(RDN rDN) {
        return this.compare(this, rDN);
    }

    @Override
    public int compare(RDN rDN, RDN rDN2) {
        Validator.ensureNotNull(rDN, rDN2);
        return rDN.toNormalizedString().compareTo(rDN2.toNormalizedString());
    }

    public static int compare(String string, String string2) throws LDAPException {
        return RDN.compare(string, string2, null);
    }

    public static int compare(String string, String string2, Schema schema) throws LDAPException {
        return new RDN(string, schema).compareTo(new RDN(string2, schema));
    }
}

