/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SASLBindRequest
extends BindRequest
implements ResponseAcceptor {
    protected static final byte CRED_TYPE_SASL = -93;
    private static final long serialVersionUID = -5842126553864908312L;
    private int messageID = -1;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();

    protected SASLBindRequest(Control[] controlArray) {
        super(controlArray);
    }

    @Override
    public String getBindType() {
        return this.getSASLMechanismName();
    }

    public abstract String getSASLMechanismName();

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    protected final BindResult sendBindRequest(LDAPConnection lDAPConnection, String string, ASN1OctetString aSN1OctetString, Control[] controlArray, long l) throws LDAPException {
        if (this.messageID == -1) {
            this.messageID = lDAPConnection.nextMessageID();
        }
        BindRequestProtocolOp bindRequestProtocolOp = new BindRequestProtocolOp(string, this.getSASLMechanismName(), aSN1OctetString);
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)bindRequestProtocolOp, controlArray);
        return this.sendMessage(lDAPConnection, lDAPMessage, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BindResult sendMessage(LDAPConnection lDAPConnection, LDAPMessage lDAPMessage, long l) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            return this.sendMessageSync(lDAPConnection, lDAPMessage, l);
        }
        int n = lDAPMessage.getMessageID();
        lDAPConnection.registerResponseAcceptor(n, this);
        try {
            LDAPResponse lDAPResponse;
            long l2 = System.nanoTime();
            lDAPConnection.getConnectionStatistics().incrementNumBindRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            try {
                lDAPResponse = l > 0L ? this.responseQueue.poll(l, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            BindResult bindResult = this.handleResponse(lDAPConnection, lDAPResponse, l2);
            return bindResult;
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(n);
        }
    }

    private BindResult sendMessageSync(LDAPConnection lDAPConnection, LDAPMessage lDAPMessage, long l) throws LDAPException {
        LDAPResponse lDAPResponse;
        try {
            lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)l);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        int n = lDAPMessage.getMessageID();
        long l2 = System.nanoTime();
        lDAPConnection.getConnectionStatistics().incrementNumBindRequests();
        lDAPConnection.sendMessage(lDAPMessage);
        while ((lDAPResponse = lDAPConnection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            IntermediateResponseListener intermediateResponseListener = this.getIntermediateResponseListener();
            if (intermediateResponseListener == null) continue;
            intermediateResponseListener.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l2);
    }

    private BindResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l) throws LDAPException {
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SASL_BIND_CLIENT_TIMEOUT.get(l2, this.getSASLMechanismName(), this.messageID, lDAPConnection.getHostPort()));
        }
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse connectionClosedResponse = (ConnectionClosedResponse)lDAPResponse;
            String string = connectionClosedResponse.getMessage();
            if (string == null) {
                throw new LDAPException(connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(connectionClosedResponse.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        lDAPConnection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - l);
        return (BindResult)lDAPResponse;
    }

    @Override
    @InternalUseOnly
    public final void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(4);
        arrayList.add(ToCodeArgHelper.createString(null, "Bind DN"));
        arrayList.add(ToCodeArgHelper.createString(this.getSASLMechanismName(), "SASL Mechanism Name"));
        arrayList.add(ToCodeArgHelper.createByteArray("---redacted-SASL-credentials".getBytes(), true, "SASL Credentials"));
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            arrayList.add(ToCodeArgHelper.createControlArray(controlArray, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(list, n, "GenericSASLBindRequest", string + "Request", "new GenericSASLBindRequest", arrayList);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string2 = stringBuilder.toString();
            list.add("");
            list.add(string2 + '{');
            list.add(string2 + "  BindResult " + string + "Result = connection.bind(" + string + "Request);");
            list.add(string2 + "  // The bind was processed successfully.");
            list.add(string2 + '}');
            list.add(string2 + "catch (SASLBindInProgressException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The SASL bind requires multiple stages.  " + "Continue it here.");
            list.add(string2 + "  // Do not attempt to use the connection for " + "any other purpose until bind processing has completed.");
            list.add(string2 + '}');
            list.add(string2 + "catch (LDAPException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The bind failed.  Maybe the following will " + "help explain why.");
            list.add(string2 + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            list.add(string2 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string2 + "  String message = e.getMessage();");
            list.add(string2 + "  String matchedDN = e.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string2 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string2 + '}');
        }
    }
}

