/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchResult
extends LDAPResult {
    private static final long serialVersionUID = 1938208530894131198L;
    private int numEntries;
    private int numReferences;
    private List<SearchResultEntry> searchEntries;
    private List<SearchResultReference> searchReferences;

    public SearchResult(int n, ResultCode resultCode, String string, String string2, String[] stringArray, int n2, int n3, Control[] controlArray) {
        super(n, resultCode, string, string2, stringArray, controlArray);
        this.numEntries = n2;
        this.numReferences = n3;
        this.searchEntries = null;
        this.searchReferences = null;
    }

    public SearchResult(int n, ResultCode resultCode, String string, String string2, String[] stringArray, List<SearchResultEntry> list, List<SearchResultReference> list2, int n2, int n3, Control[] controlArray) {
        super(n, resultCode, string, string2, stringArray, controlArray);
        this.numEntries = n2;
        this.numReferences = n3;
        this.searchEntries = list;
        this.searchReferences = list2;
    }

    static SearchResult readSearchResultFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        LDAPResult lDAPResult = LDAPResult.readLDAPResultFrom(n, aSN1StreamReaderSequence, aSN1StreamReader);
        return new SearchResult(n, lDAPResult.getResultCode(), lDAPResult.getDiagnosticMessage(), lDAPResult.getMatchedDN(), lDAPResult.getReferralURLs(), -1, -1, lDAPResult.getResponseControls());
    }

    public int getEntryCount() {
        return this.numEntries;
    }

    public int getReferenceCount() {
        return this.numReferences;
    }

    public List<SearchResultEntry> getSearchEntries() {
        if (this.searchEntries == null) {
            return null;
        }
        return Collections.unmodifiableList(this.searchEntries);
    }

    public SearchResultEntry getSearchEntry(String string) throws LDAPException {
        if (this.searchEntries == null) {
            return null;
        }
        DN dN = new DN(string);
        for (SearchResultEntry searchResultEntry : this.searchEntries) {
            if (!dN.equals(searchResultEntry.getParsedDN())) continue;
            return searchResultEntry;
        }
        return null;
    }

    public List<SearchResultReference> getSearchReferences() {
        if (this.searchReferences == null) {
            return null;
        }
        return Collections.unmodifiableList(this.searchReferences);
    }

    void setCounts(int n, List<SearchResultEntry> list, int n2, List<SearchResultReference> list2) {
        this.numEntries = n;
        this.numReferences = n2;
        this.searchEntries = list == null ? null : Collections.unmodifiableList(list);
        this.searchReferences = list2 == null ? null : Collections.unmodifiableList(list2);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        Control[] controlArray;
        String[] stringArray;
        String string;
        String string2;
        stringBuilder.append("SearchResult(resultCode=");
        stringBuilder.append(this.getResultCode());
        int n = this.getMessageID();
        if (n >= 0) {
            stringBuilder.append(", messageID=");
            stringBuilder.append(n);
        }
        if ((string2 = this.getDiagnosticMessage()) != null) {
            stringBuilder.append(", diagnosticMessage='");
            stringBuilder.append(string2);
            stringBuilder.append('\'');
        }
        if ((string = this.getMatchedDN()) != null) {
            stringBuilder.append(", matchedDN='");
            stringBuilder.append(string);
            stringBuilder.append('\'');
        }
        if ((stringArray = this.getReferralURLs()).length > 0) {
            stringBuilder.append(", referralURLs={");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(stringArray[i]);
                stringBuilder.append('\'');
            }
            stringBuilder.append('}');
        }
        if (this.numEntries >= 0) {
            stringBuilder.append(", entriesReturned=");
            stringBuilder.append(this.numEntries);
        }
        if (this.numReferences >= 0) {
            stringBuilder.append(", referencesReturned=");
            stringBuilder.append(this.numReferences);
        }
        if ((controlArray = this.getResponseControls()).length > 0) {
            stringBuilder.append(", responseControls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

