/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;

public final class SearchResultReference
implements Serializable,
LDAPResponse {
    private static final long serialVersionUID = 5675961266319346053L;
    private final Control[] controls;
    private final int messageID;
    private final String[] referralURLs;

    public SearchResultReference(String[] stringArray, Control[] controlArray) {
        this(-1, stringArray, controlArray);
    }

    public SearchResultReference(int n, String[] stringArray, Control[] controlArray) {
        Validator.ensureNotNull(stringArray);
        this.messageID = n;
        this.referralURLs = stringArray;
        this.controls = controlArray == null ? NO_CONTROLS : controlArray;
    }

    static SearchResultReference readSearchReferenceFrom(int n, ASN1StreamReaderSequence aSN1StreamReaderSequence, ASN1StreamReader aSN1StreamReader) throws LDAPException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            ASN1StreamReaderSequence aSN1StreamReaderSequence2 = aSN1StreamReader.beginSequence();
            while (aSN1StreamReaderSequence2.hasMoreElements()) {
                arrayList.add(aSN1StreamReader.readString());
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            Control[] controlArray = NO_CONTROLS;
            if (aSN1StreamReaderSequence.hasMoreElements()) {
                ArrayList<Control> arrayList2 = new ArrayList<Control>(5);
                ASN1StreamReaderSequence aSN1StreamReaderSequence3 = aSN1StreamReader.beginSequence();
                while (aSN1StreamReaderSequence3.hasMoreElements()) {
                    arrayList2.add(Control.readFrom(aSN1StreamReader));
                }
                controlArray = new Control[arrayList2.size()];
                arrayList2.toArray(controlArray);
            }
            return new SearchResultReference(n, stringArray, controlArray);
        }
        catch (LDAPException lDAPException) {
            Debug.debugException(lDAPException);
            throw lDAPException;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_SEARCH_REFERENCE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    public int getMessageID() {
        return this.messageID;
    }

    public String[] getReferralURLs() {
        return this.referralURLs;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(String string) {
        for (Control control : this.controls) {
            if (!control.getOID().equals(string)) continue;
            return control;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        int n;
        stringBuilder.append("SearchResultReference(referralURLs={");
        for (n = 0; n < this.referralURLs.length; ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.referralURLs[n]);
        }
        stringBuilder.append('}');
        if (this.messageID >= 0) {
            stringBuilder.append(", messageID=");
            stringBuilder.append(this.messageID);
        }
        stringBuilder.append(", controls={");
        for (n = 0; n < this.controls.length; ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            this.controls[n].toString(stringBuilder);
        }
        stringBuilder.append("})");
    }
}

