/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import java.io.Serializable;
import java.util.HashMap;

public final class SearchScope
implements Serializable {
    public static final int BASE_INT_VALUE = 0;
    public static final SearchScope BASE = new SearchScope("BASE", 0);
    public static final int ONE_INT_VALUE = 1;
    public static final SearchScope ONE = new SearchScope("ONE", 1);
    public static final int SUB_INT_VALUE = 2;
    public static final SearchScope SUB = new SearchScope("SUB", 2);
    public static final int SUBORDINATE_SUBTREE_INT_VALUE = 3;
    public static final SearchScope SUBORDINATE_SUBTREE = new SearchScope("SUBORDINATE_SUBTREE", 3);
    private static final HashMap<Integer, SearchScope> UNDEFINED_SCOPES = new HashMap();
    private static final long serialVersionUID = 5381929718445793181L;
    private final int intValue;
    private final String name;

    private SearchScope(int n) {
        this.intValue = n;
        this.name = String.valueOf(n);
    }

    private SearchScope(String string, int n) {
        this.name = string;
        this.intValue = n;
    }

    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchScope valueOf(int n) {
        switch (n) {
            case 0: {
                return BASE;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return SUB;
            }
            case 3: {
                return SUBORDINATE_SUBTREE;
            }
        }
        HashMap<Integer, SearchScope> hashMap = UNDEFINED_SCOPES;
        synchronized (hashMap) {
            SearchScope searchScope = UNDEFINED_SCOPES.get(n);
            if (searchScope == null) {
                searchScope = new SearchScope(n);
                UNDEFINED_SCOPES.put(n, searchScope);
            }
            return searchScope;
        }
    }

    public static SearchScope definedValueOf(int n) {
        switch (n) {
            case 0: {
                return BASE;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return SUB;
            }
            case 3: {
                return SUBORDINATE_SUBTREE;
            }
        }
        return null;
    }

    public static SearchScope[] values() {
        return new SearchScope[]{BASE, ONE, SUB, SUBORDINATE_SUBTREE};
    }

    public int hashCode() {
        return this.intValue;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof SearchScope) {
            return this.intValue == ((SearchScope)object).intValue;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

