/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.PasswordProvider;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleBindRequest
extends BindRequest
implements ResponseAcceptor,
ProtocolOp {
    private static final byte CRED_TYPE_SIMPLE = -128;
    private static final ASN1OctetString NO_BIND_DN = new ASN1OctetString();
    private static final ASN1OctetString NO_PASSWORD = new ASN1OctetString(-128);
    private static final long serialVersionUID = 4725871243149974407L;
    private int messageID = -1;
    private final ASN1OctetString bindDN;
    private final ASN1OctetString password;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private final PasswordProvider passwordProvider;

    public SimpleBindRequest() {
        this(NO_BIND_DN, NO_PASSWORD, null, NO_CONTROLS);
    }

    public SimpleBindRequest(String string, String string2) {
        this(string, string2, NO_CONTROLS);
    }

    public SimpleBindRequest(String string, byte[] byArray) {
        this(string, byArray, NO_CONTROLS);
    }

    public SimpleBindRequest(DN dN, String string) {
        this(dN, string, NO_CONTROLS);
    }

    public SimpleBindRequest(DN dN, byte[] byArray) {
        this(dN, byArray, NO_CONTROLS);
    }

    public SimpleBindRequest(String string, String string2, Control ... controlArray) {
        super(controlArray);
        this.bindDN = string == null ? NO_BIND_DN : new ASN1OctetString(string);
        this.password = string2 == null ? NO_PASSWORD : new ASN1OctetString(-128, string2);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(String string, byte[] byArray, Control ... controlArray) {
        super(controlArray);
        this.bindDN = string == null ? NO_BIND_DN : new ASN1OctetString(string);
        this.password = byArray == null ? NO_PASSWORD : new ASN1OctetString(-128, byArray);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(DN dN, String string, Control ... controlArray) {
        super(controlArray);
        this.bindDN = dN == null ? NO_BIND_DN : new ASN1OctetString(dN.toString());
        this.password = string == null ? NO_PASSWORD : new ASN1OctetString(-128, string);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(DN dN, byte[] byArray, Control ... controlArray) {
        super(controlArray);
        this.bindDN = dN == null ? NO_BIND_DN : new ASN1OctetString(dN.toString());
        this.password = byArray == null ? NO_PASSWORD : new ASN1OctetString(-128, byArray);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(String string, PasswordProvider passwordProvider, Control ... controlArray) {
        super(controlArray);
        this.bindDN = new ASN1OctetString(string);
        this.passwordProvider = passwordProvider;
        this.password = null;
    }

    public SimpleBindRequest(DN dN, PasswordProvider passwordProvider, Control ... controlArray) {
        super(controlArray);
        this.bindDN = new ASN1OctetString(dN.toString());
        this.passwordProvider = passwordProvider;
        this.password = null;
    }

    private SimpleBindRequest(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, PasswordProvider passwordProvider, Control ... controlArray) {
        super(controlArray);
        this.bindDN = aSN1OctetString;
        this.password = aSN1OctetString2;
        this.passwordProvider = passwordProvider;
    }

    public String getBindDN() {
        return this.bindDN.stringValue();
    }

    public ASN1OctetString getPassword() {
        return this.password;
    }

    public PasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    @Override
    public byte getProtocolOpType() {
        return 96;
    }

    @Override
    public void writeTo(ASN1Buffer aSN1Buffer) {
        ASN1BufferSequence aSN1BufferSequence = aSN1Buffer.beginSequence((byte)96);
        aSN1Buffer.addElement(VERSION_ELEMENT);
        aSN1Buffer.addElement(this.bindDN);
        if (this.passwordProvider == null) {
            aSN1Buffer.addElement(this.password);
        } else {
            byte[] byArray;
            try {
                byArray = this.passwordProvider.getPasswordBytes();
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                throw new LDAPRuntimeException(lDAPException);
            }
            ASN1OctetString aSN1OctetString = new ASN1OctetString(-128, byArray);
            aSN1Buffer.addElement(aSN1OctetString);
            aSN1Buffer.setZeroBufferOnClear();
            Arrays.fill(byArray, (byte)0);
        }
        aSN1BufferSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() throws LDAPSDKUsageException {
        if (this.password == null) {
            throw new LDAPSDKUsageException(LDAPMessages.ERR_SIMPLE_BIND_ENCODE_PROTOCOL_OP_WITH_PROVIDER.get());
        }
        return new ASN1Sequence(96, new ASN1Integer(3), this.bindDN, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BindResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            boolean bl = lDAPConnection.getConnectionOptions().autoReconnect();
            return this.processSync(lDAPConnection, bl);
        }
        if (this.password != null && this.bindDN.getValue().length > 0 && this.password.getValue().length == 0 && lDAPConnection.getConnectionOptions().bindWithDNRequiresPassword()) {
            LDAPException lDAPException = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_SIMPLE_BIND_DN_WITHOUT_PASSWORD.get());
            Debug.debugCodingError(lDAPException);
            throw lDAPException;
        }
        this.messageID = lDAPConnection.nextMessageID();
        LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        lDAPConnection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse lDAPResponse;
            Debug.debugLDAPRequest(this);
            long l = System.nanoTime();
            lDAPConnection.getConnectionStatistics().incrementNumBindRequests();
            lDAPConnection.sendMessage(lDAPMessage);
            try {
                long l2 = this.getResponseTimeoutMillis(lDAPConnection);
                lDAPResponse = l2 > 0L ? this.responseQueue.poll(l2, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Debug.debugException(interruptedException);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(lDAPConnection.getHostPort()), interruptedException);
            }
            BindResult bindResult = this.handleResponse(lDAPConnection, lDAPResponse, l, false);
            return bindResult;
        }
        finally {
            lDAPConnection.deregisterResponseAcceptor(this.messageID);
        }
    }

    private BindResult processSync(LDAPConnection lDAPConnection, boolean bl) throws LDAPException {
        LDAPResponse lDAPResponse;
        Serializable serializable;
        long l;
        block5: {
            this.messageID = lDAPConnection.nextMessageID();
            LDAPMessage lDAPMessage = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
            try {
                lDAPConnection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(lDAPConnection));
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            l = System.nanoTime();
            Debug.debugLDAPRequest(this);
            lDAPConnection.getConnectionStatistics().incrementNumBindRequests();
            try {
                lDAPConnection.sendMessage(lDAPMessage);
            }
            catch (LDAPException lDAPException) {
                Debug.debugException(lDAPException);
                if (!bl || (serializable = this.reconnectAndRetry(lDAPConnection, lDAPException.getResultCode())) == null) break block5;
                return serializable;
            }
        }
        while ((lDAPResponse = lDAPConnection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            serializable = this.getIntermediateResponseListener();
            if (serializable == null) continue;
            serializable.intermediateResponseReturned((IntermediateResponse)lDAPResponse);
        }
        return this.handleResponse(lDAPConnection, lDAPResponse, l, bl);
    }

    private BindResult handleResponse(LDAPConnection lDAPConnection, LDAPResponse lDAPResponse, long l, boolean bl) throws LDAPException {
        BindResult bindResult;
        if (lDAPResponse == null) {
            long l2 = StaticUtils.nanosToMillis(System.nanoTime() - l);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SIMPLE_BIND_CLIENT_TIMEOUT.get(l2, this.messageID, this.bindDN.stringValue(), lDAPConnection.getHostPort()));
        }
        lDAPConnection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - l);
        if (lDAPResponse instanceof ConnectionClosedResponse) {
            Serializable serializable;
            if (bl && (serializable = this.reconnectAndRetry(lDAPConnection, ResultCode.SERVER_DOWN)) != null) {
                return serializable;
            }
            serializable = (ConnectionClosedResponse)lDAPResponse;
            String string = ((ConnectionClosedResponse)serializable).getMessage();
            if (string == null) {
                throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(lDAPConnection.getHostPort(), this.toString()));
            }
            throw new LDAPException(((ConnectionClosedResponse)serializable).getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(lDAPConnection.getHostPort(), this.toString(), string));
        }
        BindResult bindResult2 = (BindResult)lDAPResponse;
        if (bl && (bindResult = this.reconnectAndRetry(lDAPConnection, bindResult2.getResultCode())) != null) {
            return bindResult;
        }
        return bindResult2;
    }

    private BindResult reconnectAndRetry(LDAPConnection lDAPConnection, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    lDAPConnection.reconnect();
                    return this.processSync(lDAPConnection, false);
                }
            }
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return null;
    }

    @Override
    public SimpleBindRequest getRebindRequest(String string, int n) {
        return new SimpleBindRequest(this.bindDN, this.password, this.passwordProvider, this.getControls());
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse lDAPResponse) throws LDAPException {
        try {
            this.responseQueue.put(lDAPResponse);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @Override
    public String getBindType() {
        return "SIMPLE";
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public SimpleBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public SimpleBindRequest duplicate(Control[] controlArray) {
        SimpleBindRequest simpleBindRequest = new SimpleBindRequest(this.bindDN, this.password, this.passwordProvider, controlArray);
        simpleBindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return simpleBindRequest;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("SimpleBindRequest(dn='");
        stringBuilder.append(this.bindDN);
        stringBuilder.append('\'');
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    @Override
    public void toCode(List<String> list, String string, int n, boolean bl) {
        ArrayList<ToCodeArgHelper> arrayList = new ArrayList<ToCodeArgHelper>(3);
        arrayList.add(ToCodeArgHelper.createString(this.bindDN.stringValue(), "Bind DN"));
        arrayList.add(ToCodeArgHelper.createString("---redacted-password---", "Bind Password"));
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            arrayList.add(ToCodeArgHelper.createControlArray(controlArray, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(list, n, "SimpleBindRequest", string + "Request", "new SimpleBindRequest", arrayList);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            String string2 = stringBuilder.toString();
            list.add("");
            list.add(string2 + "try");
            list.add(string2 + '{');
            list.add(string2 + "  BindResult " + string + "Result = connection.bind(" + string + "Request);");
            list.add(string2 + "  // The bind was processed successfully.");
            list.add(string2 + '}');
            list.add(string2 + "catch (LDAPException e)");
            list.add(string2 + '{');
            list.add(string2 + "  // The bind failed.  Maybe the following will " + "help explain why.");
            list.add(string2 + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            list.add(string2 + "  ResultCode resultCode = e.getResultCode();");
            list.add(string2 + "  String message = e.getMessage();");
            list.add(string2 + "  String matchedDN = e.getMatchedDN();");
            list.add(string2 + "  String[] referralURLs = e.getReferralURLs();");
            list.add(string2 + "  Control[] responseControls = " + "e.getResponseControls();");
            list.add(string2 + '}');
        }
    }
}

