/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Validator;
import javax.net.SocketFactory;

public final class SingleServerSet
extends ServerSet {
    private final int port;
    private final LDAPConnectionOptions connectionOptions;
    private final SocketFactory socketFactory;
    private final String address;

    public SingleServerSet(String string, int n) {
        this(string, n, null, null);
    }

    public SingleServerSet(String string, int n, LDAPConnectionOptions lDAPConnectionOptions) {
        this(string, n, null, lDAPConnectionOptions);
    }

    public SingleServerSet(String string, int n, SocketFactory socketFactory) {
        this(string, n, socketFactory, null);
    }

    public SingleServerSet(String string, int n, SocketFactory socketFactory, LDAPConnectionOptions lDAPConnectionOptions) {
        Validator.ensureNotNull(string);
        Validator.ensureTrue(n > 0 && n < 65536, "SingleServerSet.port must be between 1 and 65535.");
        this.address = string;
        this.port = n;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = lDAPConnectionOptions == null ? new LDAPConnectionOptions() : lDAPConnectionOptions;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return new LDAPConnection(this.socketFactory, this.connectionOptions, this.address, this.port);
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("SingleServerSet(server=");
        stringBuilder.append(this.address);
        stringBuilder.append(':');
        stringBuilder.append(this.port);
        stringBuilder.append(')');
    }
}

