/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class ToCodeArgHelper {
    private final List<String> argStrings;
    private final String comment;

    private ToCodeArgHelper(String string, String string2) {
        this.argStrings = Arrays.asList(string);
        this.comment = string2;
    }

    private ToCodeArgHelper(List<String> list, String string) {
        this.argStrings = list;
        this.comment = string;
    }

    public static ToCodeArgHelper createByte(byte by, boolean bl) {
        String string = "0x" + StaticUtils.toHex(by);
        if ((by & 0x80) != 0) {
            string = "(byte) " + string;
        }
        String string2 = bl && StaticUtils.isPrintableString(new byte[]{by}) ? "\"" + (char)by + '\"' : null;
        return new ToCodeArgHelper(string, string2);
    }

    public static ToCodeArgHelper createByteArray(byte[] byArray, boolean bl, String string) {
        return new ToCodeArgHelper(ToCodeArgHelper.getByteArrayLines(byArray, bl), string);
    }

    private static List<String> getByteArrayLines(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return Arrays.asList("(byte[]) null");
        }
        if (byArray.length == 0) {
            return Arrays.asList("new byte[0]");
        }
        ArrayList<String> arrayList = new ArrayList<String>(3 + byArray.length);
        arrayList.add("new byte[]");
        arrayList.add("{");
        byte[] byArray2 = new byte[1];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.setLength(0);
            stringBuilder.append("  ");
            if ((byArray[i] & 0x80) != 0) {
                stringBuilder.append("(byte) 0x");
                StaticUtils.toHex(byArray[i], stringBuilder);
                if (i < byArray.length - 1) {
                    stringBuilder.append(',');
                }
            } else {
                stringBuilder.append("0x");
                StaticUtils.toHex(byArray[i], stringBuilder);
                if (i < byArray.length - 1) {
                    stringBuilder.append(',');
                }
                byArray2[0] = byArray[i];
                if (bl && StaticUtils.isPrintableString(byArray2)) {
                    stringBuilder.append(" // \"");
                    stringBuilder.append((char)byArray[i]);
                    stringBuilder.append('\"');
                }
            }
            arrayList.add(stringBuilder.toString());
        }
        arrayList.add("}");
        return arrayList;
    }

    public static ToCodeArgHelper createBoolean(boolean bl, String string) {
        return new ToCodeArgHelper(bl ? "true" : "false", string);
    }

    public static ToCodeArgHelper createInteger(long l, String string) {
        String string2 = String.valueOf(l);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            string2 = string2 + 'L';
        }
        return new ToCodeArgHelper(string2, string);
    }

    public static ToCodeArgHelper createString(String string, String string2) {
        if (string == null) {
            return new ToCodeArgHelper("(String) null", string2);
        }
        return new ToCodeArgHelper('\"' + string.replace("\"", "\\\"") + '\"', string2);
    }

    public static ToCodeArgHelper createASN1OctetString(ASN1OctetString aSN1OctetString, String string) {
        if (aSN1OctetString == null) {
            return new ToCodeArgHelper("(ASN1OctetString) null", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        boolean bl = aSN1OctetString.getType() == 4;
        byte[] byArray = aSN1OctetString.getValue();
        if (byArray.length == 0) {
            if (bl) {
                arrayList.add("new ASN1OctetString()");
            } else {
                arrayList.add("new ASN1OctetString(");
                arrayList.add("     (byte) 0x" + StaticUtils.toHex(aSN1OctetString.getType()) + ')');
            }
        } else {
            boolean bl2;
            arrayList.add("new ASN1OctetString(");
            if (!bl) {
                arrayList.add("     (byte) 0x" + StaticUtils.toHex(aSN1OctetString.getType()) + ',');
            }
            if (bl2 = StaticUtils.isPrintableString(byArray)) {
                arrayList.add("     \"" + aSN1OctetString.stringValue() + "\")");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(byArray, true).iterator();
                while (iterator.hasNext()) {
                    stringBuilder.setLength(0);
                    stringBuilder.append("     ");
                    stringBuilder.append(iterator.next());
                    if (!iterator.hasNext()) {
                        stringBuilder.append(')');
                    }
                    arrayList.add(stringBuilder.toString());
                }
            }
        }
        return new ToCodeArgHelper(arrayList, string);
    }

    public static ToCodeArgHelper createModificationType(ModificationType modificationType, String string) {
        if (modificationType == null) {
            return new ToCodeArgHelper("(ModificationType) null", string);
        }
        ModificationType modificationType2 = ModificationType.definedValueOf(modificationType.intValue());
        if (modificationType2 == null) {
            return new ToCodeArgHelper("ModificationType.valueOf(" + modificationType.intValue() + ')', string);
        }
        return new ToCodeArgHelper("ModificationType." + modificationType2.getName(), string);
    }

    public static ToCodeArgHelper createScope(SearchScope searchScope, String string) {
        if (searchScope == null) {
            return new ToCodeArgHelper("(SearchScope) null", string);
        }
        SearchScope searchScope2 = SearchScope.definedValueOf(searchScope.intValue());
        if (searchScope2 == null) {
            return new ToCodeArgHelper("SearchScope.valueOf(" + searchScope.intValue() + ')', string);
        }
        return new ToCodeArgHelper("SearchScope." + searchScope2.getName(), string);
    }

    public static ToCodeArgHelper createDerefPolicy(DereferencePolicy dereferencePolicy, String string) {
        if (dereferencePolicy == null) {
            return new ToCodeArgHelper("(DereferencePolicy) null", string);
        }
        DereferencePolicy dereferencePolicy2 = DereferencePolicy.definedValueOf(dereferencePolicy.intValue());
        if (dereferencePolicy2 == null) {
            return new ToCodeArgHelper("DereferencePolicy.valueOf(" + dereferencePolicy.intValue() + ')', string);
        }
        return new ToCodeArgHelper("DereferencePolicy." + dereferencePolicy2.getName(), string);
    }

    public static ToCodeArgHelper createAttribute(Attribute attribute, String string) {
        if (attribute == null) {
            return new ToCodeArgHelper("(Attribute) null", string);
        }
        if (!attribute.hasValue()) {
            return new ToCodeArgHelper("new Attribute(\"" + attribute.getName() + "\")", string);
        }
        ASN1OctetString[] aSN1OctetStringArray = attribute.getRawValues();
        ArrayList<String> arrayList = new ArrayList<String>(2 + aSN1OctetStringArray.length);
        arrayList.add("new Attribute(");
        arrayList.add("     \"" + attribute.getName() + "\",");
        if (StaticUtils.isSensitiveToCodeAttribute(attribute.getName())) {
            if (aSN1OctetStringArray.length == 1) {
                arrayList.add("     \"---redacted-value---\")");
            } else {
                for (int i = 1; i <= aSN1OctetStringArray.length; ++i) {
                    String string2 = i == aSN1OctetStringArray.length ? ")" : ",";
                    arrayList.add("     \"---redacted-value-" + i + "---\"" + string2);
                }
            }
        } else if (ToCodeArgHelper.allPrintable(aSN1OctetStringArray)) {
            for (int i = 0; i < aSN1OctetStringArray.length; ++i) {
                String string3 = i == aSN1OctetStringArray.length - 1 ? ")" : ",";
                arrayList.add("     \"" + aSN1OctetStringArray[i].stringValue().replace("\"", "\\\"") + '\"' + string3);
            }
        } else {
            for (int i = 0; i < aSN1OctetStringArray.length; ++i) {
                String string4 = i < aSN1OctetStringArray.length - 1 ? "," : ")";
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(aSN1OctetStringArray[i].getValue(), true).iterator();
                while (iterator.hasNext()) {
                    String string5 = iterator.next();
                    if (iterator.hasNext()) {
                        arrayList.add("     " + string5);
                        continue;
                    }
                    arrayList.add("     " + string5 + string4);
                }
            }
        }
        return new ToCodeArgHelper(arrayList, string);
    }

    public static ToCodeArgHelper createModification(Modification modification, String string) {
        if (modification == null) {
            return new ToCodeArgHelper("(Modification) null", string);
        }
        ASN1OctetString[] aSN1OctetStringArray = modification.getRawValues();
        ArrayList<String> arrayList = new ArrayList<String>(3 + aSN1OctetStringArray.length);
        arrayList.add("new Modification(");
        arrayList.add("     " + ToCodeArgHelper.createModificationType(modification.getModificationType(), null).getLines().get(0) + ',');
        if (aSN1OctetStringArray.length == 0) {
            arrayList.add("     \"" + modification.getAttributeName() + "\")");
        } else {
            arrayList.add("     \"" + modification.getAttributeName() + "\",");
            if (StaticUtils.isSensitiveToCodeAttribute(modification.getAttributeName())) {
                if (aSN1OctetStringArray.length == 1) {
                    arrayList.add("     \"---redacted-value---\")");
                } else {
                    for (int i = 1; i <= aSN1OctetStringArray.length; ++i) {
                        String string2 = i == aSN1OctetStringArray.length ? ")" : ",";
                        arrayList.add("     \"---redacted-value-" + i + "---\"" + string2);
                    }
                }
            } else if (ToCodeArgHelper.allPrintable(aSN1OctetStringArray)) {
                for (int i = 0; i < aSN1OctetStringArray.length; ++i) {
                    String string3 = i == aSN1OctetStringArray.length - 1 ? ")" : ",";
                    arrayList.add("     \"" + aSN1OctetStringArray[i].stringValue().replace("\"", "\\\"") + '\"' + string3);
                }
            } else {
                for (int i = 0; i < aSN1OctetStringArray.length; ++i) {
                    String string4 = i == aSN1OctetStringArray.length - 1 ? ")" : ",";
                    Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(aSN1OctetStringArray[i].getValue(), true).iterator();
                    while (iterator.hasNext()) {
                        String string5 = iterator.next();
                        if (iterator.hasNext()) {
                            arrayList.add("     " + string5);
                            continue;
                        }
                        arrayList.add("     " + string5 + string4);
                    }
                }
            }
        }
        return new ToCodeArgHelper(arrayList, string);
    }

    public static ToCodeArgHelper createFilter(Filter filter, String string) {
        if (filter == null) {
            return new ToCodeArgHelper("(Filter) null", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        ToCodeArgHelper.addFilterLines(arrayList, filter, "", "");
        return new ToCodeArgHelper(arrayList, string);
    }

    private static void addFilterLines(List<String> list, Filter filter, String string, String string2) {
        String string3 = string + "     ";
        switch (filter.getFilterType()) {
            case -96: 
            case -95: {
                Filter[] filterArray = filter.getComponents();
                if (filter.getFilterType() == -96) {
                    if (filterArray.length == 0) {
                        list.add(string + "Filter.createANDFilter()" + string2);
                        return;
                    }
                    list.add(string + "Filter.createANDFilter(");
                } else {
                    if (filterArray.length == 0) {
                        list.add(string + "Filter.createORFilter()" + string2);
                        return;
                    }
                    list.add(string + "Filter.createORFilter(");
                }
                for (int i = 0; i < filterArray.length; ++i) {
                    if (i == filterArray.length - 1) {
                        ToCodeArgHelper.addFilterLines(list, filterArray[i], string3, ')' + string2);
                        continue;
                    }
                    ToCodeArgHelper.addFilterLines(list, filterArray[i], string3, ",");
                }
                break;
            }
            case -94: {
                list.add(string + "Filter.createNOTFilter(");
                ToCodeArgHelper.addFilterLines(list, filter.getNOTComponent(), string3, ')' + string2);
                break;
            }
            case -121: {
                list.add(string + "Filter.createPresenceFilter(");
                list.add(string3 + '\"' + filter.getAttributeName() + "\")" + string2);
                break;
            }
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                switch (filter.getFilterType()) {
                    case -93: {
                        list.add(string + "Filter.createEqualityFilter(");
                        break;
                    }
                    case -91: {
                        list.add(string + "Filter.createGreaterOrEqualFilter(");
                        break;
                    }
                    case -90: {
                        list.add(string + "Filter.createLessOrEqualFilter(");
                        break;
                    }
                    case -88: {
                        list.add(string + "Filter.createApproximateMatchFilter(");
                    }
                }
                list.add(string3 + '\"' + filter.getAttributeName() + "\",");
                if (StaticUtils.isSensitiveToCodeAttribute(filter.getAttributeName())) {
                    list.add(string3 + "\"---redacted-value---\")" + string2);
                    break;
                }
                if (StaticUtils.isPrintableString(filter.getAssertionValueBytes())) {
                    list.add(string3 + '\"' + filter.getAssertionValue() + "\")" + string2);
                    break;
                }
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(filter.getAssertionValueBytes(), true).iterator();
                while (iterator.hasNext()) {
                    String string4 = iterator.next();
                    if (iterator.hasNext()) {
                        list.add(string3 + string4);
                        continue;
                    }
                    list.add(string3 + string4 + ')' + string2);
                }
                break;
            }
            case -92: {
                int n;
                Object object;
                boolean bl;
                list.add(string + "Filter.createSubstringFilter(");
                list.add(string3 + '\"' + filter.getAttributeName() + "\",");
                if (StaticUtils.isSensitiveToCodeAttribute(filter.getAttributeName())) {
                    if (filter.getRawSubInitialValue() == null) {
                        list.add(string3 + "null,");
                    } else {
                        list.add(string3 + "\"---redacted-subInitial---\",");
                    }
                    if (filter.getRawSubAnyValues().length == 0) {
                        list.add(string3 + "null,");
                    } else if (filter.getRawSubAnyValues().length == 1) {
                        list.add(string3 + "new String[]");
                        list.add(string3 + '{');
                        list.add(string3 + "  \"---redacted-subAny---\"");
                        list.add(string3 + "},");
                    } else {
                        list.add(string3 + "new String[]");
                        list.add(string3 + '{');
                        for (int i = 1; i <= filter.getRawSubAnyValues().length; ++i) {
                            String string5 = i == filter.getRawSubAnyValues().length ? "" : ",";
                            list.add(string3 + "  \"---redacted-subAny-" + i + "---\"" + string5);
                        }
                        list.add(string3 + "},");
                    }
                    if (filter.getRawSubFinalValue() == null) {
                        list.add(string3 + "null)" + string2);
                        break;
                    }
                    list.add(string3 + "\"---redacted-subFinal---\")" + string2);
                    break;
                }
                boolean bl2 = bl = !(filter.getRawSubInitialValue() != null && !StaticUtils.isPrintableString(filter.getSubInitialBytes()) || filter.getRawSubFinalValue() != null && !StaticUtils.isPrintableString(filter.getSubFinalBytes()));
                if (bl && filter.getRawSubAnyValues().length > 0) {
                    for (byte[] iterator : filter.getSubAnyBytes()) {
                        if (StaticUtils.isPrintableString(iterator)) continue;
                        bl = false;
                        break;
                    }
                }
                if (filter.getRawSubInitialValue() == null) {
                    list.add(string3 + "null,");
                } else if (bl) {
                    list.add(string3 + '\"' + filter.getSubInitialString().replace("\"", "\\\"") + "\",");
                } else {
                    object = ToCodeArgHelper.getByteArrayLines(filter.getSubInitialBytes(), true).iterator();
                    while (object.hasNext()) {
                        String string6 = (String)object.next();
                        if (object.hasNext()) {
                            list.add(string3 + string6);
                            continue;
                        }
                        list.add(string3 + string6 + ',');
                    }
                }
                if (filter.getRawSubAnyValues().length == 0) {
                    list.add(string3 + "null,");
                } else if (bl) {
                    list.add(string3 + "new String[]");
                    list.add(string3 + '{');
                    object = filter.getSubAnyStrings();
                    for (n = 0; n < ((Object)object).length; ++n) {
                        String string7 = n == ((Object)object).length - 1 ? "" : ",";
                        list.add(string3 + "  \"" + (String)object[n] + '\"' + string7);
                    }
                    list.add(string3 + "},");
                } else {
                    list.add(string3 + "new byte[][]");
                    list.add(string3 + '{');
                    object = filter.getSubAnyBytes();
                    for (n = 0; n < ((Object)object).length; ++n) {
                        String string8 = n == ((Object)object).length - 1 ? "" : ",";
                        Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines((byte[])object[n], true).iterator();
                        while (iterator.hasNext()) {
                            String string4 = iterator.next();
                            if (iterator.hasNext()) {
                                list.add(string3 + "  " + string4);
                                continue;
                            }
                            list.add(string3 + "  " + string4 + string8);
                        }
                    }
                    list.add(string3 + "},");
                }
                if (filter.getRawSubFinalValue() == null) {
                    list.add(string3 + "null)" + string2);
                    break;
                }
                if (bl) {
                    list.add(string3 + '\"' + filter.getSubFinalString().replace("\"", "\\\"") + "\")" + string2);
                    break;
                }
                object = ToCodeArgHelper.getByteArrayLines(filter.getSubFinalBytes(), true).iterator();
                while (object.hasNext()) {
                    String string10 = (String)object.next();
                    if (object.hasNext()) {
                        list.add(string3 + string10);
                        continue;
                    }
                    list.add(string3 + string10 + ')' + string2);
                }
                break;
            }
            case -87: {
                list.add(string + "Filter.createExtensibleMatchFilter(");
                if (filter.getAttributeName() == null) {
                    list.add(string3 + "null,");
                } else {
                    list.add(string3 + '\"' + filter.getAttributeName() + "\",");
                }
                if (filter.getMatchingRuleID() == null) {
                    list.add(string3 + "null,");
                } else {
                    list.add(string3 + '\"' + filter.getMatchingRuleID() + "\",");
                }
                list.add(string3 + filter.getDNAttributes() + ',');
                if (filter.getAttributeName() != null && StaticUtils.isSensitiveToCodeAttribute(filter.getAttributeName())) {
                    list.add(string3 + "\"---redacted-value---\")" + string2);
                    break;
                }
                if (StaticUtils.isPrintableString(filter.getAssertionValueBytes())) {
                    list.add(string3 + '\"' + filter.getAssertionValue().replace("\"", "\\\"") + "\")" + string2);
                    break;
                }
                Iterator<String> iterator = ToCodeArgHelper.getByteArrayLines(filter.getAssertionValueBytes(), true).iterator();
                while (iterator.hasNext()) {
                    String string11 = iterator.next();
                    if (iterator.hasNext()) {
                        list.add(string3 + string11);
                        continue;
                    }
                    list.add(string3 + string11 + ')' + string2);
                }
                break;
            }
        }
    }

    public static ToCodeArgHelper createControl(Control control, String string) {
        if (control == null) {
            return new ToCodeArgHelper("(Control) null", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add("new Control(");
        arrayList.add("     \"" + control.getOID() + "\",");
        if (control.hasValue()) {
            arrayList.add("     " + control.isCritical() + ',');
            List<String> list = ToCodeArgHelper.createASN1OctetString((ASN1OctetString)control.getValue(), null).argStrings;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (iterator.hasNext()) {
                    arrayList.add("     " + string2);
                    continue;
                }
                arrayList.add("     " + string2 + ')');
            }
        } else {
            arrayList.add("     " + control.isCritical() + ')');
        }
        return new ToCodeArgHelper(arrayList, string);
    }

    public static ToCodeArgHelper createControlArray(Control[] controlArray, String string) {
        if (controlArray == null) {
            return new ToCodeArgHelper("(Control[]) null", string);
        }
        if (controlArray.length == 0) {
            return new ToCodeArgHelper("new Control[0]", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add("new Control[]");
        arrayList.add("{");
        for (int i = 0; i < controlArray.length; ++i) {
            ToCodeArgHelper toCodeArgHelper = ToCodeArgHelper.createControl(controlArray[i], null);
            List<String> list = toCodeArgHelper.argStrings;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (!iterator.hasNext() && i < controlArray.length - 1) {
                    arrayList.add("  " + string2 + ',');
                    continue;
                }
                arrayList.add("  " + string2);
            }
        }
        arrayList.add("}");
        return new ToCodeArgHelper(arrayList, string);
    }

    public static ToCodeArgHelper createRaw(String string, String string2) {
        return new ToCodeArgHelper(string, string2);
    }

    public static ToCodeArgHelper createRaw(List<String> list, String string) {
        return new ToCodeArgHelper(list, string);
    }

    private static boolean allPrintable(ASN1OctetString ... aSN1OctetStringArray) {
        for (ASN1OctetString aSN1OctetString : aSN1OctetStringArray) {
            if (StaticUtils.isPrintableString(aSN1OctetString.getValue())) continue;
            return false;
        }
        return true;
    }

    public List<String> getLines() {
        return this.argStrings;
    }

    public String getComment() {
        return this.comment;
    }
}

