/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.util.Validator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdatableLDAPRequest
extends LDAPRequest {
    private static final long serialVersionUID = 2487230102594573848L;

    protected UpdatableLDAPRequest(Control[] controlArray) {
        super(controlArray);
    }

    public final void setControls(Control ... controlArray) {
        if (controlArray == null) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            this.setControlsInternal(controlArray);
        }
    }

    public final void setControls(List<Control> list) {
        if (list == null || list.isEmpty()) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            Control[] controlArray = new Control[list.size()];
            this.setControlsInternal(list.toArray(controlArray));
        }
    }

    public final void clearControls() {
        this.setControlsInternal(NO_CONTROLS);
    }

    public final void addControl(Control control) {
        Validator.ensureNotNull(control);
        Control[] controlArray = this.getControls();
        Control[] controlArray2 = new Control[controlArray.length + 1];
        System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
        controlArray2[controlArray.length] = control;
        this.setControlsInternal(controlArray2);
    }

    public final void addControls(Control ... controlArray) {
        if (controlArray == null || controlArray.length == 0) {
            return;
        }
        Control[] controlArray2 = this.getControls();
        Control[] controlArray3 = new Control[controlArray2.length + controlArray.length];
        System.arraycopy(controlArray2, 0, controlArray3, 0, controlArray2.length);
        System.arraycopy(controlArray, 0, controlArray3, controlArray2.length, controlArray.length);
        this.setControlsInternal(controlArray3);
    }

    public final Control removeControl(String string) {
        Validator.ensureNotNull(string);
        Control[] controlArray = this.getControls();
        int n = -1;
        Control control = null;
        for (int i = 0; i < controlArray.length; ++i) {
            if (!controlArray[i].getOID().equals(string)) continue;
            control = controlArray[i];
            n = i;
            break;
        }
        if (n < 0) {
            return null;
        }
        if (controlArray.length == 1) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            Control[] controlArray2 = new Control[controlArray.length - 1];
            int n2 = 0;
            for (int i = 0; i < controlArray.length; ++i) {
                if (i == n) continue;
                controlArray2[n2++] = controlArray[i];
            }
            this.setControlsInternal(controlArray2);
        }
        return control;
    }

    public final boolean removeControl(Control control) {
        Validator.ensureNotNull(control);
        Control[] controlArray = this.getControls();
        int n = -1;
        for (int i = 0; i < controlArray.length; ++i) {
            if (!controlArray[i].equals(control)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return false;
        }
        if (controlArray.length == 1) {
            this.setControlsInternal(NO_CONTROLS);
        } else {
            Control[] controlArray2 = new Control[controlArray.length - 1];
            int n2 = 0;
            for (int i = 0; i < controlArray.length; ++i) {
                if (i == n) continue;
                controlArray2[n2++] = controlArray[i];
            }
            this.setControlsInternal(controlArray2);
        }
        return true;
    }

    public final Control replaceControl(Control control) {
        Validator.ensureNotNull(control);
        return this.replaceControl(control.getOID(), control);
    }

    public final Control replaceControl(String string, Control control) {
        Validator.ensureNotNull(string);
        if (control == null) {
            return this.removeControl(string);
        }
        Control[] controlArray = this.getControls();
        for (int i = 0; i < controlArray.length; ++i) {
            if (!controlArray[i].getOID().equals(string)) continue;
            Control control2 = controlArray[i];
            controlArray[i] = control;
            this.setControlsInternal(controlArray);
            return control2;
        }
        Control[] controlArray2 = new Control[controlArray.length + 1];
        System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
        controlArray2[controlArray.length] = control;
        this.setControlsInternal(controlArray2);
        return null;
    }
}

