/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.Debug;

public final class CancelExtendedRequest
extends ExtendedRequest {
    public static final String CANCEL_REQUEST_OID = "1.3.6.1.1.8";
    private static final long serialVersionUID = -7170687636394194183L;
    private final int targetMessageID;

    public CancelExtendedRequest(AsyncRequestID asyncRequestID) {
        this(asyncRequestID.getMessageID(), null);
    }

    public CancelExtendedRequest(int n) {
        this(n, null);
    }

    public CancelExtendedRequest(AsyncRequestID asyncRequestID, Control[] controlArray) {
        this(asyncRequestID.getMessageID(), controlArray);
    }

    public CancelExtendedRequest(int n, Control[] controlArray) {
        super(CANCEL_REQUEST_OID, CancelExtendedRequest.encodeValue(n), controlArray);
        this.targetMessageID = n;
    }

    public CancelExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString aSN1OctetString = extendedRequest.getValue();
        if (aSN1OctetString == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CANCEL_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element aSN1Element = ASN1Element.decode(aSN1OctetString.getValue());
            ASN1Element[] aSN1ElementArray = ASN1Sequence.decodeAsSequence(aSN1Element).elements();
            this.targetMessageID = ASN1Integer.decodeAsInteger(aSN1ElementArray[0]).intValue();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_CANCEL_REQUEST_CANNOT_DECODE.get(exception), exception);
        }
    }

    private static ASN1OctetString encodeValue(int n) {
        ASN1Element[] aSN1ElementArray = new ASN1Element[]{new ASN1Integer(n)};
        return new ASN1OctetString(new ASN1Sequence(aSN1ElementArray).encode());
    }

    protected ExtendedResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        if (lDAPConnection.synchronousMode()) {
            throw new LDAPException(ResultCode.NOT_SUPPORTED, ExtOpMessages.ERR_CANCEL_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE.get());
        }
        return super.process(lDAPConnection, n);
    }

    public int getTargetMessageID() {
        return this.targetMessageID;
    }

    public CancelExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public CancelExtendedRequest duplicate(Control[] controlArray) {
        CancelExtendedRequest cancelExtendedRequest = new CancelExtendedRequest(this.targetMessageID, controlArray);
        cancelExtendedRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return cancelExtendedRequest;
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_CANCEL.get();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("CancelExtendedRequest(targetMessageID=");
        stringBuilder.append(this.targetMessageID);
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append(", controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

