/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ExtOpMessages {
    ERR_CANCEL_NOT_SUPPORTED_IN_SYNCHRONOUS_MODE("Cancel operations are not supported on connections operating in synchronous mode"),
    ERR_CANCEL_REQUEST_CANNOT_DECODE("The provided extended request cannot be decoded as a cancel request because an error occurred while attempting to parse the value:  {0}"),
    ERR_CANCEL_REQUEST_NO_VALUE("The provided extended request cannot be decoded as a cancel request because it does not have a value."),
    ERR_STARTTLS_REQUEST_CANNOT_CREATE_DEFAULT_CONTEXT("An error occurred while attempting to create a default SSL context:  {0}"),
    ERR_STARTTLS_REQUEST_HAS_VALUE("The provided extended cannot request be decoded as a StartTLS request because it has a value."),
    INFO_EXTENDED_REQUEST_NAME_CANCEL("Cancel Extended Request"),
    INFO_EXTENDED_REQUEST_NAME_START_TLS("StartTLS Extended Request"),
    INFO_EXTENDED_RESULT_NAME_NOTICE_OF_DISCONNECT("Notice Of Disconnection Extended Result");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<ExtOpMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<ExtOpMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private ExtOpMessages(String string2) {
        this.defaultText = string2;
    }

    public String get() {
        String string = MESSAGE_STRINGS.get((Object)this);
        if (string == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                string = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception exception) {
                string = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... objectArray) {
        MessageFormat messageFormat = MESSAGES.get((Object)this);
        if (messageFormat == null) {
            if (RESOURCE_BUNDLE == null) {
                messageFormat = new MessageFormat(this.defaultText);
            } else {
                try {
                    messageFormat = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception exception) {
                    messageFormat = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, messageFormat);
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(objectArray);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("unboundid-ldapsdk-extop");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = resourceBundle;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

