/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPExtendedOperationException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.ssl.SSLUtil;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public final class StartTLSExtendedRequest
extends ExtendedRequest {
    public static final String STARTTLS_REQUEST_OID = "1.3.6.1.4.1.1466.20037";
    private static final long serialVersionUID = -3234194603452821233L;
    private final SSLSocketFactory sslSocketFactory;

    public StartTLSExtendedRequest() throws LDAPException {
        this((SSLSocketFactory)null, null);
    }

    public StartTLSExtendedRequest(Control[] controlArray) throws LDAPException {
        this((SSLSocketFactory)null, controlArray);
    }

    public StartTLSExtendedRequest(SSLContext sSLContext) throws LDAPException {
        this(sSLContext, null);
    }

    public StartTLSExtendedRequest(SSLSocketFactory sSLSocketFactory) throws LDAPException {
        this(sSLSocketFactory, null);
    }

    public StartTLSExtendedRequest(SSLContext sSLContext, Control[] controlArray) throws LDAPException {
        super(STARTTLS_REQUEST_OID, controlArray);
        if (sSLContext == null) {
            try {
                SSLContext sSLContext2 = SSLContext.getInstance(SSLUtil.getDefaultSSLProtocol());
                sSLContext2.init(null, null, null);
                this.sslSocketFactory = sSLContext2.getSocketFactory();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ExtOpMessages.ERR_STARTTLS_REQUEST_CANNOT_CREATE_DEFAULT_CONTEXT.get(exception), exception);
            }
        } else {
            this.sslSocketFactory = sSLContext.getSocketFactory();
        }
    }

    public StartTLSExtendedRequest(SSLSocketFactory sSLSocketFactory, Control[] controlArray) throws LDAPException {
        super(STARTTLS_REQUEST_OID, controlArray);
        if (sSLSocketFactory == null) {
            try {
                SSLContext sSLContext = SSLContext.getInstance(SSLUtil.getDefaultSSLProtocol());
                sSLContext.init(null, null, null);
                this.sslSocketFactory = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ExtOpMessages.ERR_STARTTLS_REQUEST_CANNOT_CREATE_DEFAULT_CONTEXT.get(exception), exception);
            }
        } else {
            this.sslSocketFactory = sSLSocketFactory;
        }
    }

    public StartTLSExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        this(extendedRequest.getControls());
        if (extendedRequest.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STARTTLS_REQUEST_HAS_VALUE.get());
        }
    }

    public ExtendedResult process(LDAPConnection lDAPConnection, int n) throws LDAPException {
        InternalSDKHelper.setSoTimeout(lDAPConnection, 50);
        ExtendedResult extendedResult = super.process(lDAPConnection, n);
        if (extendedResult.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPExtendedOperationException(extendedResult);
        }
        InternalSDKHelper.convertToTLS(lDAPConnection, this.sslSocketFactory);
        return extendedResult;
    }

    public StartTLSExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public StartTLSExtendedRequest duplicate(Control[] controlArray) {
        try {
            StartTLSExtendedRequest startTLSExtendedRequest = new StartTLSExtendedRequest(this.sslSocketFactory, controlArray);
            startTLSExtendedRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
            return startTLSExtendedRequest;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return null;
        }
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_START_TLS.get();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("StartTLSExtendedRequest(");
        Control[] controlArray = this.getControls();
        if (controlArray.length > 0) {
            stringBuilder.append("controls={");
            for (int i = 0; i < controlArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(controlArray[i]);
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

