/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeSyntaxDefinition
extends SchemaElement {
    private static final long serialVersionUID = 8593718232711987488L;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String attributeSyntaxString;
    private final String oid;

    public AttributeSyntaxDefinition(String string) throws LDAPException {
        LinkedHashMap<String, String[]> linkedHashMap;
        String string2;
        block9: {
            String string3;
            Validator.ensureNotNull(string);
            this.attributeSyntaxString = string.trim();
            int n = this.attributeSyntaxString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_EMPTY.get());
            }
            if (this.attributeSyntaxString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_NO_OPENING_PAREN.get(this.attributeSyntaxString));
            }
            int n2 = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = AttributeSyntaxDefinition.readOID(this.attributeSyntaxString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            string2 = null;
            linkedHashMap = new LinkedHashMap<String, String[]>();
            while (true) {
                int n3 = n2 = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, n2, n);
                while (n2 < n && this.attributeSyntaxString.charAt(n2) != ' ') {
                    ++n2;
                }
                string3 = this.attributeSyntaxString.substring(n3, n2);
                String string4 = StaticUtils.toLowerCase(string3);
                if (string4.equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_CLOSE_NOT_AT_END.get(this.attributeSyntaxString));
                    }
                    break block9;
                }
                if (string4.equals("desc")) {
                    if (string2 == null) {
                        n2 = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = AttributeSyntaxDefinition.readQDString(this.attributeSyntaxString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_MULTIPLE_DESC.get(this.attributeSyntaxString));
                }
                if (!string4.startsWith("x-")) break;
                n2 = AttributeSyntaxDefinition.skipSpaces(this.attributeSyntaxString, n2, n);
                ArrayList<String> arrayList = new ArrayList<String>();
                n2 = AttributeSyntaxDefinition.readQDStrings(this.attributeSyntaxString, n2, n, arrayList);
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                if (linkedHashMap.containsKey(string3)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_DUP_EXT.get(this.attributeSyntaxString, string3));
                }
                linkedHashMap.put(string3, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_ATTRSYNTAX_DECODE_UNEXPECTED_TOKEN.get(this.attributeSyntaxString, string3));
        }
        this.description = string2;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public AttributeSyntaxDefinition(String string, String string2, Map<String, String[]> map) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.description = string2;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.attributeSyntaxString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            AttributeSyntaxDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        for (Map.Entry<String, String[]> entry : this.extensions.entrySet()) {
            String string = entry.getKey();
            String[] stringArray = entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                AttributeSyntaxDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                AttributeSyntaxDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AttributeSyntaxDefinition)) {
            return false;
        }
        AttributeSyntaxDefinition attributeSyntaxDefinition = (AttributeSyntaxDefinition)object;
        return this.oid.equals(attributeSyntaxDefinition.oid) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, attributeSyntaxDefinition.description) && AttributeSyntaxDefinition.extensionsEqual(this.extensions, attributeSyntaxDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.attributeSyntaxString;
    }
}

