/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DITContentRuleDefinition
extends SchemaElement {
    private static final long serialVersionUID = 3224440505307817586L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String ditContentRuleString;
    private final String oid;
    private final String[] auxiliaryClasses;
    private final String[] names;
    private final String[] optionalAttributes;
    private final String[] prohibitedAttributes;
    private final String[] requiredAttributes;

    public DITContentRuleDefinition(String string) throws LDAPException {
        String string2;
        Boolean bl;
        LinkedHashMap<String, String[]> linkedHashMap;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList<String> arrayList4;
        ArrayList<String> arrayList5;
        block22: {
            String string3;
            Validator.ensureNotNull(string);
            this.ditContentRuleString = string.trim();
            int n = this.ditContentRuleString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_EMPTY.get());
            }
            if (this.ditContentRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_NO_OPENING_PAREN.get(this.ditContentRuleString));
            }
            int n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = DITContentRuleDefinition.readOID(this.ditContentRuleString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            arrayList5 = new ArrayList<String>(1);
            arrayList4 = new ArrayList<String>();
            arrayList3 = new ArrayList<String>();
            arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            linkedHashMap = new LinkedHashMap<String, String[]>();
            bl = null;
            string2 = null;
            while (true) {
                String string4;
                int n3 = n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                while (n2 < n && this.ditContentRuleString.charAt(n2) != ' ') {
                    ++n2;
                }
                string3 = this.ditContentRuleString.substring(n3, n2);
                if (string3.length() > 1 && string3.endsWith(")")) {
                    string3 = string3.substring(0, string3.length() - 1);
                    --n2;
                }
                if ((string4 = StaticUtils.toLowerCase(string3)).equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_CLOSE_NOT_AT_END.get(this.ditContentRuleString));
                    }
                    break block22;
                }
                if (string4.equals("name")) {
                    if (arrayList5.isEmpty()) {
                        n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                        n2 = DITContentRuleDefinition.readQDStrings(this.ditContentRuleString, n2, n, arrayList5);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "NAME"));
                }
                if (string4.equals("desc")) {
                    if (string2 == null) {
                        n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = DITContentRuleDefinition.readQDString(this.ditContentRuleString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "DESC"));
                }
                if (string4.equals("obsolete")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "OBSOLETE"));
                }
                if (string4.equals("aux")) {
                    if (arrayList.isEmpty()) {
                        n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                        n2 = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, n2, n, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "AUX"));
                }
                if (string4.equals("must")) {
                    if (arrayList4.isEmpty()) {
                        n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                        n2 = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, n2, n, arrayList4);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "MUST"));
                }
                if (string4.equals("may")) {
                    if (arrayList3.isEmpty()) {
                        n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                        n2 = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, n2, n, arrayList3);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "MAY"));
                }
                if (string4.equals("not")) {
                    if (arrayList2.isEmpty()) {
                        n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                        n2 = DITContentRuleDefinition.readOIDs(this.ditContentRuleString, n2, n, arrayList2);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_MULTIPLE_ELEMENTS.get(this.ditContentRuleString, "NOT"));
                }
                if (!string4.startsWith("x-")) break;
                n2 = DITContentRuleDefinition.skipSpaces(this.ditContentRuleString, n2, n);
                ArrayList<String> arrayList6 = new ArrayList<String>();
                n2 = DITContentRuleDefinition.readQDStrings(this.ditContentRuleString, n2, n, arrayList6);
                String[] stringArray = new String[arrayList6.size()];
                arrayList6.toArray(stringArray);
                if (linkedHashMap.containsKey(string3)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_DUP_EXT.get(this.ditContentRuleString, string3));
                }
                linkedHashMap.put(string3, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DCR_DECODE_DUP_EXT.get(this.ditContentRuleString, string3));
        }
        this.description = string2;
        this.names = new String[arrayList5.size()];
        arrayList5.toArray(this.names);
        this.auxiliaryClasses = new String[arrayList.size()];
        arrayList.toArray(this.auxiliaryClasses);
        this.requiredAttributes = new String[arrayList4.size()];
        arrayList4.toArray(this.requiredAttributes);
        this.optionalAttributes = new String[arrayList3.size()];
        arrayList3.toArray(this.optionalAttributes);
        this.prohibitedAttributes = new String[arrayList2.size()];
        arrayList2.toArray(this.prohibitedAttributes);
        this.isObsolete = bl != null;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public DITContentRuleDefinition(String string, String[] stringArray, String string2, boolean bl, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, Map<String, String[]> map) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.isObsolete = bl;
        this.description = string2;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.auxiliaryClasses = stringArray2 == null ? StaticUtils.NO_STRINGS : stringArray2;
        this.requiredAttributes = stringArray3 == null ? StaticUtils.NO_STRINGS : stringArray3;
        this.optionalAttributes = stringArray4 == null ? StaticUtils.NO_STRINGS : stringArray4;
        this.prohibitedAttributes = stringArray5 == null ? StaticUtils.NO_STRINGS : stringArray5;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.ditContentRuleString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String stringArray : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(stringArray);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            DITContentRuleDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (this.auxiliaryClasses.length == 1) {
            stringBuilder.append(" AUX ");
            stringBuilder.append(this.auxiliaryClasses[0]);
        } else if (this.auxiliaryClasses.length > 1) {
            stringBuilder.append(" AUX (");
            for (int i = 0; i < this.auxiliaryClasses.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.auxiliaryClasses[i]);
            }
            stringBuilder.append(" )");
        }
        if (this.requiredAttributes.length == 1) {
            stringBuilder.append(" MUST ");
            stringBuilder.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            stringBuilder.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.requiredAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            stringBuilder.append(" MAY ");
            stringBuilder.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            stringBuilder.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.optionalAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        if (this.prohibitedAttributes.length == 1) {
            stringBuilder.append(" NOT ");
            stringBuilder.append(this.prohibitedAttributes[0]);
        } else if (this.prohibitedAttributes.length > 1) {
            stringBuilder.append(" NOT (");
            for (int i = 0; i < this.prohibitedAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.prohibitedAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                DITContentRuleDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                DITContentRuleDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getAuxiliaryClasses() {
        return this.auxiliaryClasses;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public String[] getProhibitedAttributes() {
        return this.prohibitedAttributes;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof DITContentRuleDefinition)) {
            return false;
        }
        DITContentRuleDefinition dITContentRuleDefinition = (DITContentRuleDefinition)object;
        return this.oid.equals(dITContentRuleDefinition.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, dITContentRuleDefinition.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.auxiliaryClasses, dITContentRuleDefinition.auxiliaryClasses) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.requiredAttributes, dITContentRuleDefinition.requiredAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.optionalAttributes, dITContentRuleDefinition.optionalAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.prohibitedAttributes, dITContentRuleDefinition.prohibitedAttributes) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, dITContentRuleDefinition.description) && this.isObsolete == dITContentRuleDefinition.isObsolete && DITContentRuleDefinition.extensionsEqual(this.extensions, dITContentRuleDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.ditContentRuleString;
    }
}

