/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchingRuleUseDefinition
extends SchemaElement {
    private static final long serialVersionUID = 2366143311976256897L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String matchingRuleUseString;
    private final String oid;
    private final String[] applicableTypes;
    private final String[] names;

    public MatchingRuleUseDefinition(String string) throws LDAPException {
        LinkedHashMap<String, String[]> linkedHashMap;
        Boolean bl;
        String string2;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        block17: {
            String string3;
            Validator.ensureNotNull(string);
            this.matchingRuleUseString = string.trim();
            int n = this.matchingRuleUseString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_EMPTY.get());
            }
            if (this.matchingRuleUseString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_NO_OPENING_PAREN.get(this.matchingRuleUseString));
            }
            int n2 = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = MatchingRuleUseDefinition.readOID(this.matchingRuleUseString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            arrayList2 = new ArrayList<String>(1);
            arrayList = new ArrayList<String>(1);
            string2 = null;
            bl = null;
            linkedHashMap = new LinkedHashMap<String, String[]>();
            while (true) {
                String string4;
                int n3 = n2 = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, n2, n);
                while (n2 < n && this.matchingRuleUseString.charAt(n2) != ' ') {
                    ++n2;
                }
                string3 = this.matchingRuleUseString.substring(n3, n2);
                if (string3.length() > 1 && string3.endsWith(")")) {
                    string3 = string3.substring(0, string3.length() - 1);
                    --n2;
                }
                if ((string4 = StaticUtils.toLowerCase(string3)).equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_CLOSE_NOT_AT_END.get(this.matchingRuleUseString));
                    }
                    break block17;
                }
                if (string4.equals("name")) {
                    if (arrayList2.isEmpty()) {
                        n2 = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, n2, n);
                        n2 = MatchingRuleUseDefinition.readQDStrings(this.matchingRuleUseString, n2, n, arrayList2);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "NAME"));
                }
                if (string4.equals("desc")) {
                    if (string2 == null) {
                        n2 = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = MatchingRuleUseDefinition.readQDString(this.matchingRuleUseString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "DESC"));
                }
                if (string4.equals("obsolete")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "OBSOLETE"));
                }
                if (string4.equals("applies")) {
                    if (arrayList.isEmpty()) {
                        n2 = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, n2, n);
                        n2 = MatchingRuleUseDefinition.readOIDs(this.matchingRuleUseString, n2, n, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleUseString, "APPLIES"));
                }
                if (!string4.startsWith("x-")) break;
                n2 = MatchingRuleUseDefinition.skipSpaces(this.matchingRuleUseString, n2, n);
                ArrayList<String> arrayList3 = new ArrayList<String>();
                n2 = MatchingRuleUseDefinition.readQDStrings(this.matchingRuleUseString, n2, n, arrayList3);
                String[] stringArray = new String[arrayList3.size()];
                arrayList3.toArray(stringArray);
                if (linkedHashMap.containsKey(string3)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_DUP_EXT.get(this.matchingRuleUseString, string3));
                }
                linkedHashMap.put(string3, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_UNEXPECTED_TOKEN.get(this.matchingRuleUseString, string3));
        }
        this.description = string2;
        this.names = new String[arrayList2.size()];
        arrayList2.toArray(this.names);
        if (arrayList.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MRU_DECODE_NO_APPLIES.get(this.matchingRuleUseString));
        }
        this.applicableTypes = new String[arrayList.size()];
        arrayList.toArray(this.applicableTypes);
        this.isObsolete = bl != null;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public MatchingRuleUseDefinition(String string, String[] stringArray, String string2, boolean bl, String[] stringArray2, Map<String, String[]> map) {
        Validator.ensureNotNull(string, stringArray2);
        Validator.ensureFalse(stringArray2.length == 0);
        this.oid = string;
        this.description = string2;
        this.isObsolete = bl;
        this.applicableTypes = stringArray2;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.matchingRuleUseString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String stringArray : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(stringArray);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            MatchingRuleUseDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (this.applicableTypes.length == 1) {
            stringBuilder.append(" APPLIES ");
            stringBuilder.append(this.applicableTypes[0]);
        } else if (this.applicableTypes.length > 1) {
            stringBuilder.append(" APPLIES (");
            for (int i = 0; i < this.applicableTypes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $");
                }
                stringBuilder.append(' ');
                stringBuilder.append(this.applicableTypes[i]);
            }
            stringBuilder.append(" )");
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                MatchingRuleUseDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                MatchingRuleUseDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getApplicableAttributeTypes() {
        return this.applicableTypes;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MatchingRuleUseDefinition)) {
            return false;
        }
        MatchingRuleUseDefinition matchingRuleUseDefinition = (MatchingRuleUseDefinition)object;
        return this.oid.equals(matchingRuleUseDefinition.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, matchingRuleUseDefinition.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.applicableTypes, matchingRuleUseDefinition.applicableTypes) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, matchingRuleUseDefinition.description) && this.isObsolete == matchingRuleUseDefinition.isObsolete && MatchingRuleUseDefinition.extensionsEqual(this.extensions, matchingRuleUseDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.matchingRuleUseString;
    }
}

