/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameFormDefinition
extends SchemaElement {
    private static final long serialVersionUID = -816231530223449984L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String nameFormString;
    private final String oid;
    private final String[] names;
    private final String structuralClass;
    private final String[] optionalAttributes;
    private final String[] requiredAttributes;

    public NameFormDefinition(String string) throws LDAPException {
        String string2;
        String string3;
        Boolean bl;
        LinkedHashMap<String, String[]> linkedHashMap;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        block22: {
            String string4;
            Validator.ensureNotNull(string);
            this.nameFormString = string.trim();
            int n = this.nameFormString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_EMPTY.get());
            }
            if (this.nameFormString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_NO_OPENING_PAREN.get(this.nameFormString));
            }
            int n2 = NameFormDefinition.skipSpaces(this.nameFormString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = NameFormDefinition.readOID(this.nameFormString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            arrayList3 = new ArrayList<String>(1);
            arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            linkedHashMap = new LinkedHashMap<String, String[]>();
            bl = null;
            string3 = null;
            string2 = null;
            while (true) {
                String string5;
                int n3 = n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                while (n2 < n && this.nameFormString.charAt(n2) != ' ') {
                    ++n2;
                }
                string4 = this.nameFormString.substring(n3, n2);
                if (string4.length() > 1 && string4.endsWith(")")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    --n2;
                }
                if ((string5 = StaticUtils.toLowerCase(string4)).equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_CLOSE_NOT_AT_END.get(this.nameFormString));
                    }
                    break block22;
                }
                if (string5.equals("name")) {
                    if (arrayList3.isEmpty()) {
                        n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                        n2 = NameFormDefinition.readQDStrings(this.nameFormString, n2, n, arrayList3);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "NAME"));
                }
                if (string5.equals("desc")) {
                    if (string3 == null) {
                        n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = NameFormDefinition.readQDString(this.nameFormString, n2, n, stringBuilder);
                        string3 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "DESC"));
                }
                if (string5.equals("obsolete")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "OBSOLETE"));
                }
                if (string5.equals("oc")) {
                    if (string2 == null) {
                        n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = NameFormDefinition.readOID(this.nameFormString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "OC"));
                }
                if (string5.equals("must")) {
                    if (arrayList2.isEmpty()) {
                        n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                        n2 = NameFormDefinition.readOIDs(this.nameFormString, n2, n, arrayList2);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "MUST"));
                }
                if (string5.equals("may")) {
                    if (arrayList.isEmpty()) {
                        n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                        n2 = NameFormDefinition.readOIDs(this.nameFormString, n2, n, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_MULTIPLE_ELEMENTS.get(this.nameFormString, "MAY"));
                }
                if (!string5.startsWith("x-")) break;
                n2 = NameFormDefinition.skipSpaces(this.nameFormString, n2, n);
                ArrayList<String> arrayList4 = new ArrayList<String>();
                n2 = NameFormDefinition.readQDStrings(this.nameFormString, n2, n, arrayList4);
                String[] stringArray = new String[arrayList4.size()];
                arrayList4.toArray(stringArray);
                if (linkedHashMap.containsKey(string4)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_DUP_EXT.get(this.nameFormString, string4));
                }
                linkedHashMap.put(string4, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_UNEXPECTED_TOKEN.get(this.nameFormString, string4));
        }
        this.description = string3;
        this.structuralClass = string2;
        if (this.structuralClass == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_NO_OC.get(this.nameFormString));
        }
        this.names = new String[arrayList3.size()];
        arrayList3.toArray(this.names);
        this.requiredAttributes = new String[arrayList2.size()];
        arrayList2.toArray(this.requiredAttributes);
        if (arrayList2.isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_NF_DECODE_NO_MUST.get(this.nameFormString));
        }
        this.optionalAttributes = new String[arrayList.size()];
        arrayList.toArray(this.optionalAttributes);
        this.isObsolete = bl != null;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public NameFormDefinition(String string, String[] stringArray, String string2, boolean bl, String string3, String[] stringArray2, String[] stringArray3, Map<String, String[]> map) {
        Validator.ensureNotNull(string, string3, stringArray2);
        Validator.ensureFalse(stringArray2.length == 0);
        this.oid = string;
        this.isObsolete = bl;
        this.description = string2;
        this.structuralClass = string3;
        this.requiredAttributes = stringArray2;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.optionalAttributes = stringArray3 == null ? StaticUtils.NO_STRINGS : stringArray3;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.nameFormString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String stringArray : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(stringArray);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            NameFormDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        stringBuilder.append(" OC ");
        stringBuilder.append(this.structuralClass);
        if (this.requiredAttributes.length == 1) {
            stringBuilder.append(" MUST ");
            stringBuilder.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            stringBuilder.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.requiredAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            stringBuilder.append(" MAY ");
            stringBuilder.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            stringBuilder.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.optionalAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                NameFormDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                NameFormDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getStructuralClass() {
        return this.structuralClass;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof NameFormDefinition)) {
            return false;
        }
        NameFormDefinition nameFormDefinition = (NameFormDefinition)object;
        return this.oid.equals(nameFormDefinition.oid) && this.structuralClass.equalsIgnoreCase(nameFormDefinition.structuralClass) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, nameFormDefinition.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.requiredAttributes, nameFormDefinition.requiredAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.optionalAttributes, nameFormDefinition.optionalAttributes) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, nameFormDefinition.description) && this.isObsolete == nameFormDefinition.isObsolete && NameFormDefinition.extensionsEqual(this.extensions, nameFormDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.nameFormString;
    }
}

