/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectClassDefinition
extends SchemaElement {
    private static final long serialVersionUID = -3024333376249332728L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final ObjectClassType objectClassType;
    private final String description;
    private final String objectClassString;
    private final String oid;
    private final String[] names;
    private final String[] optionalAttributes;
    private final String[] requiredAttributes;
    private final String[] superiorClasses;

    public ObjectClassDefinition(String string) throws LDAPException {
        String string2;
        ObjectClassType objectClassType;
        Boolean bl;
        LinkedHashMap<String, String[]> linkedHashMap;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList<String> arrayList4;
        block26: {
            String string3;
            Validator.ensureNotNull(string);
            this.objectClassString = string.trim();
            int n = this.objectClassString.length();
            if (n == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_EMPTY.get());
            }
            if (this.objectClassString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_NO_OPENING_PAREN.get(this.objectClassString));
            }
            int n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, 1, n);
            StringBuilder stringBuilder = new StringBuilder();
            n2 = ObjectClassDefinition.readOID(this.objectClassString, n2, n, stringBuilder);
            this.oid = stringBuilder.toString();
            arrayList4 = new ArrayList<String>(1);
            arrayList3 = new ArrayList<String>(1);
            arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            linkedHashMap = new LinkedHashMap<String, String[]>();
            bl = null;
            objectClassType = null;
            string2 = null;
            while (true) {
                String string4;
                int n3 = n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                while (n2 < n && this.objectClassString.charAt(n2) != ' ') {
                    ++n2;
                }
                string3 = this.objectClassString.substring(n3, n2);
                if (string3.length() > 1 && string3.endsWith(")")) {
                    string3 = string3.substring(0, string3.length() - 1);
                    --n2;
                }
                if ((string4 = StaticUtils.toLowerCase(string3)).equals(")")) {
                    if (n2 < n) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_CLOSE_NOT_AT_END.get(this.objectClassString));
                    }
                    break block26;
                }
                if (string4.equals("name")) {
                    if (arrayList4.isEmpty()) {
                        n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                        n2 = ObjectClassDefinition.readQDStrings(this.objectClassString, n2, n, arrayList4);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "NAME"));
                }
                if (string4.equals("desc")) {
                    if (string2 == null) {
                        n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                        stringBuilder = new StringBuilder();
                        n2 = ObjectClassDefinition.readQDString(this.objectClassString, n2, n, stringBuilder);
                        string2 = stringBuilder.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "DESC"));
                }
                if (string4.equals("obsolete")) {
                    if (bl == null) {
                        bl = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "OBSOLETE"));
                }
                if (string4.equals("sup")) {
                    if (arrayList3.isEmpty()) {
                        n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                        n2 = ObjectClassDefinition.readOIDs(this.objectClassString, n2, n, arrayList3);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "SUP"));
                }
                if (string4.equals("abstract")) {
                    if (objectClassType == null) {
                        objectClassType = ObjectClassType.ABSTRACT;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_OC_TYPES.get(this.objectClassString));
                }
                if (string4.equals("structural")) {
                    if (objectClassType == null) {
                        objectClassType = ObjectClassType.STRUCTURAL;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_OC_TYPES.get(this.objectClassString));
                }
                if (string4.equals("auxiliary")) {
                    if (objectClassType == null) {
                        objectClassType = ObjectClassType.AUXILIARY;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_OC_TYPES.get(this.objectClassString));
                }
                if (string4.equals("must")) {
                    if (arrayList2.isEmpty()) {
                        n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                        n2 = ObjectClassDefinition.readOIDs(this.objectClassString, n2, n, arrayList2);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "MUST"));
                }
                if (string4.equals("may")) {
                    if (arrayList.isEmpty()) {
                        n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                        n2 = ObjectClassDefinition.readOIDs(this.objectClassString, n2, n, arrayList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_MULTIPLE_ELEMENTS.get(this.objectClassString, "MAY"));
                }
                if (!string4.startsWith("x-")) break;
                n2 = ObjectClassDefinition.skipSpaces(this.objectClassString, n2, n);
                ArrayList<String> arrayList5 = new ArrayList<String>();
                n2 = ObjectClassDefinition.readQDStrings(this.objectClassString, n2, n, arrayList5);
                String[] stringArray = new String[arrayList5.size()];
                arrayList5.toArray(stringArray);
                if (linkedHashMap.containsKey(string3)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_DUP_EXT.get(this.objectClassString, string3));
                }
                linkedHashMap.put(string3, stringArray);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_OC_DECODE_UNEXPECTED_TOKEN.get(this.objectClassString, string3));
        }
        this.description = string2;
        this.names = new String[arrayList4.size()];
        arrayList4.toArray(this.names);
        this.superiorClasses = new String[arrayList3.size()];
        arrayList3.toArray(this.superiorClasses);
        this.requiredAttributes = new String[arrayList2.size()];
        arrayList2.toArray(this.requiredAttributes);
        this.optionalAttributes = new String[arrayList.size()];
        arrayList.toArray(this.optionalAttributes);
        this.isObsolete = bl != null;
        this.objectClassType = objectClassType;
        this.extensions = Collections.unmodifiableMap(linkedHashMap);
    }

    public ObjectClassDefinition(String string, String[] stringArray, String string2, boolean bl, String[] stringArray2, ObjectClassType objectClassType, String[] stringArray3, String[] stringArray4, Map<String, String[]> map) {
        Validator.ensureNotNull(string);
        this.oid = string;
        this.isObsolete = bl;
        this.description = string2;
        this.objectClassType = objectClassType;
        this.names = stringArray == null ? StaticUtils.NO_STRINGS : stringArray;
        this.superiorClasses = stringArray2 == null ? StaticUtils.NO_STRINGS : stringArray2;
        this.requiredAttributes = stringArray3 == null ? StaticUtils.NO_STRINGS : stringArray3;
        this.optionalAttributes = stringArray4 == null ? StaticUtils.NO_STRINGS : stringArray4;
        this.extensions = map == null ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        StringBuilder stringBuilder = new StringBuilder();
        this.createDefinitionString(stringBuilder);
        this.objectClassString = stringBuilder.toString();
    }

    private void createDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (this.names.length == 1) {
            stringBuilder.append(" NAME '");
            stringBuilder.append(this.names[0]);
            stringBuilder.append('\'');
        } else if (this.names.length > 1) {
            stringBuilder.append(" NAME (");
            for (String stringArray : this.names) {
                stringBuilder.append(" '");
                stringBuilder.append(stringArray);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        if (this.description != null) {
            stringBuilder.append(" DESC '");
            ObjectClassDefinition.encodeValue(this.description, stringBuilder);
            stringBuilder.append('\'');
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (this.superiorClasses.length == 1) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorClasses[0]);
        } else if (this.superiorClasses.length > 1) {
            stringBuilder.append(" SUP (");
            for (int i = 0; i < this.superiorClasses.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.superiorClasses[i]);
            }
            stringBuilder.append(" )");
        }
        if (this.objectClassType != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.objectClassType.getName());
        }
        if (this.requiredAttributes.length == 1) {
            stringBuilder.append(" MUST ");
            stringBuilder.append(this.requiredAttributes[0]);
        } else if (this.requiredAttributes.length > 1) {
            stringBuilder.append(" MUST (");
            for (int i = 0; i < this.requiredAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.requiredAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        if (this.optionalAttributes.length == 1) {
            stringBuilder.append(" MAY ");
            stringBuilder.append(this.optionalAttributes[0]);
        } else if (this.optionalAttributes.length > 1) {
            stringBuilder.append(" MAY (");
            for (int i = 0; i < this.optionalAttributes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" $ ");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.optionalAttributes[i]);
            }
            stringBuilder.append(" )");
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            if (stringArray.length == 1) {
                stringBuilder.append(' ');
                stringBuilder.append(string);
                stringBuilder.append(" '");
                ObjectClassDefinition.encodeValue(stringArray[0], stringBuilder);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(' ');
            stringBuilder.append(string);
            stringBuilder.append(" (");
            for (String string2 : stringArray) {
                stringBuilder.append(" '");
                ObjectClassDefinition.encodeValue(string2, stringBuilder);
                stringBuilder.append('\'');
            }
            stringBuilder.append(" )");
        }
        stringBuilder.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String string) {
        for (String string2 : this.names) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return string.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getSuperiorClasses() {
        return this.superiorClasses;
    }

    public Set<ObjectClassDefinition> getSuperiorClasses(Schema schema, boolean bl) {
        LinkedHashSet<ObjectClassDefinition> linkedHashSet = new LinkedHashSet<ObjectClassDefinition>();
        for (String string : this.superiorClasses) {
            ObjectClassDefinition objectClassDefinition = schema.getObjectClass(string);
            if (objectClassDefinition == null) continue;
            linkedHashSet.add(objectClassDefinition);
            if (!bl) continue;
            ObjectClassDefinition.getSuperiorClasses(schema, objectClassDefinition, linkedHashSet);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    private static void getSuperiorClasses(Schema schema, ObjectClassDefinition objectClassDefinition, Set<ObjectClassDefinition> set) {
        for (String string : objectClassDefinition.superiorClasses) {
            ObjectClassDefinition objectClassDefinition2 = schema.getObjectClass(string);
            if (objectClassDefinition2 == null) continue;
            set.add(objectClassDefinition2);
            ObjectClassDefinition.getSuperiorClasses(schema, objectClassDefinition2, set);
        }
    }

    public ObjectClassType getObjectClassType() {
        return this.objectClassType;
    }

    public ObjectClassType getObjectClassType(Schema schema) {
        if (this.objectClassType != null) {
            return this.objectClassType;
        }
        for (String string : this.superiorClasses) {
            ObjectClassDefinition objectClassDefinition = schema.getObjectClass(string);
            if (objectClassDefinition == null) continue;
            return objectClassDefinition.getObjectClassType(schema);
        }
        return ObjectClassType.STRUCTURAL;
    }

    public String[] getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public Set<AttributeTypeDefinition> getRequiredAttributes(Schema schema, boolean bl) {
        SchemaElement schemaElement;
        HashSet<AttributeTypeDefinition> hashSet = new HashSet<AttributeTypeDefinition>();
        for (String string : this.requiredAttributes) {
            schemaElement = schema.getAttributeType(string);
            if (schemaElement == null) continue;
            hashSet.add((AttributeTypeDefinition)schemaElement);
        }
        if (bl) {
            for (String string : this.superiorClasses) {
                schemaElement = schema.getObjectClass(string);
                if (schemaElement == null) continue;
                ObjectClassDefinition.getSuperiorRequiredAttributes(schema, (ObjectClassDefinition)schemaElement, hashSet);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static void getSuperiorRequiredAttributes(Schema schema, ObjectClassDefinition objectClassDefinition, Set<AttributeTypeDefinition> set) {
        SchemaElement schemaElement;
        for (String string : objectClassDefinition.requiredAttributes) {
            schemaElement = schema.getAttributeType(string);
            if (schemaElement == null) continue;
            set.add((AttributeTypeDefinition)schemaElement);
        }
        for (String string : objectClassDefinition.superiorClasses) {
            schemaElement = schema.getObjectClass(string);
            if (schemaElement == null) continue;
            ObjectClassDefinition.getSuperiorRequiredAttributes(schema, (ObjectClassDefinition)schemaElement, set);
        }
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeTypeDefinition> getOptionalAttributes(Schema schema, boolean bl) {
        HashSet<AttributeTypeDefinition> hashSet = new HashSet<AttributeTypeDefinition>();
        for (String string : this.optionalAttributes) {
            AttributeTypeDefinition object = schema.getAttributeType(string);
            if (object == null) continue;
            hashSet.add(object);
        }
        if (bl) {
            Set<AttributeTypeDefinition> set = this.getRequiredAttributes(schema, true);
            String[] stringArray = set.iterator();
            while (stringArray.hasNext()) {
                AttributeTypeDefinition attributeTypeDefinition = (AttributeTypeDefinition)stringArray.next();
                hashSet.remove(attributeTypeDefinition);
            }
            for (String string : this.superiorClasses) {
                ObjectClassDefinition objectClassDefinition = schema.getObjectClass(string);
                if (objectClassDefinition == null) continue;
                ObjectClassDefinition.getSuperiorOptionalAttributes(schema, objectClassDefinition, hashSet, set);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static void getSuperiorOptionalAttributes(Schema schema, ObjectClassDefinition objectClassDefinition, Set<AttributeTypeDefinition> set, Set<AttributeTypeDefinition> set2) {
        SchemaElement schemaElement;
        for (String string : objectClassDefinition.optionalAttributes) {
            schemaElement = schema.getAttributeType(string);
            if (schemaElement == null || set2.contains(schemaElement)) continue;
            set.add((AttributeTypeDefinition)schemaElement);
        }
        for (String string : objectClassDefinition.superiorClasses) {
            schemaElement = schema.getObjectClass(string);
            if (schemaElement == null) continue;
            ObjectClassDefinition.getSuperiorOptionalAttributes(schema, (ObjectClassDefinition)schemaElement, set, set2);
        }
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectClassDefinition)) {
            return false;
        }
        ObjectClassDefinition objectClassDefinition = (ObjectClassDefinition)object;
        return this.oid.equals(objectClassDefinition.oid) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, objectClassDefinition.names) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.requiredAttributes, objectClassDefinition.requiredAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.optionalAttributes, objectClassDefinition.optionalAttributes) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.superiorClasses, objectClassDefinition.superiorClasses) && StaticUtils.bothNullOrEqual((Object)this.objectClassType, (Object)objectClassDefinition.objectClassType) && StaticUtils.bothNullOrEqualIgnoreCase(this.description, objectClassDefinition.description) && this.isObsolete == objectClassDefinition.isObsolete && ObjectClassDefinition.extensionsEqual(this.extensions, objectClassDefinition.extensions);
    }

    @Override
    public String toString() {
        return this.objectClassString;
    }
}

