/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.DITContentRuleDefinition;
import com.unboundid.ldap.sdk.schema.DITStructureRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.NameFormDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Schema
implements Serializable {
    public static final String ATTR_ATTRIBUTE_SYNTAX = "ldapSyntaxes";
    public static final String ATTR_ATTRIBUTE_TYPE = "attributeTypes";
    public static final String ATTR_DIT_CONTENT_RULE = "dITContentRules";
    public static final String ATTR_DIT_STRUCTURE_RULE = "dITStructureRules";
    public static final String ATTR_MATCHING_RULE = "matchingRules";
    public static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    public static final String ATTR_NAME_FORM = "nameForms";
    public static final String ATTR_OBJECT_CLASS = "objectClasses";
    public static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    private static final AtomicReference<Schema> DEFAULT_STANDARD_SCHEMA = new AtomicReference();
    private static final String[] SCHEMA_REQUEST_ATTRS = new String[]{"*", "ldapSyntaxes", "attributeTypes", "dITContentRules", "dITStructureRules", "matchingRules", "matchingRuleUse", "nameForms", "objectClasses"};
    private static final String[] SUBSCHEMA_SUBENTRY_REQUEST_ATTRS = new String[]{"subschemaSubentry"};
    private static final String DEFAULT_SCHEMA_RESOURCE_PATH = "com/unboundid/ldap/sdk/schema/standard-schema.ldif";
    private static final long serialVersionUID = 8081839633831517925L;
    private final Map<AttributeTypeDefinition, List<AttributeTypeDefinition>> subordinateAttributeTypes;
    private final Map<String, AttributeSyntaxDefinition> asMap;
    private final Map<String, AttributeTypeDefinition> atMap;
    private final Map<String, DITContentRuleDefinition> dcrMap;
    private final Map<Integer, DITStructureRuleDefinition> dsrMapByID;
    private final Map<String, DITStructureRuleDefinition> dsrMapByName;
    private final Map<String, DITStructureRuleDefinition> dsrMapByNameForm;
    private final Map<String, MatchingRuleDefinition> mrMap;
    private final Map<String, MatchingRuleUseDefinition> mruMap;
    private final Map<String, NameFormDefinition> nfMapByName;
    private final Map<String, NameFormDefinition> nfMapByOC;
    private final Map<String, ObjectClassDefinition> ocMap;
    private final ReadOnlyEntry schemaEntry;
    private final Set<AttributeSyntaxDefinition> asSet;
    private final Set<AttributeTypeDefinition> atSet;
    private final Set<AttributeTypeDefinition> operationalATSet;
    private final Set<AttributeTypeDefinition> userATSet;
    private final Set<DITContentRuleDefinition> dcrSet;
    private final Set<DITStructureRuleDefinition> dsrSet;
    private final Set<MatchingRuleDefinition> mrSet;
    private final Set<MatchingRuleUseDefinition> mruSet;
    private final Set<NameFormDefinition> nfSet;
    private final Set<ObjectClassDefinition> ocSet;
    private final Set<ObjectClassDefinition> abstractOCSet;
    private final Set<ObjectClassDefinition> auxiliaryOCSet;
    private final Set<ObjectClassDefinition> structuralOCSet;

    /*
     * WARNING - void declaration
     */
    public Schema(Entry entry) {
        Object object2;
        LinkedHashMap<String, ObjectClassDefinition> linkedHashMap;
        this.schemaEntry = new ReadOnlyEntry(entry);
        String[] stringArray = entry.getAttributeValues(ATTR_ATTRIBUTE_SYNTAX);
        if (stringArray == null) {
            this.asMap = Collections.emptyMap();
            this.asSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap<String, ObjectClassDefinition>(stringArray.length);
            object2 = new LinkedHashSet<AttributeSyntaxDefinition>(stringArray.length);
            for (String string : stringArray) {
                try {
                    AttributeSyntaxDefinition attributeSyntaxDefinition = new AttributeSyntaxDefinition(string);
                    ((HashSet)object2).add(attributeSyntaxDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(attributeSyntaxDefinition.getOID()), (ObjectClassDefinition)((Object)attributeSyntaxDefinition));
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.asMap = Collections.unmodifiableMap(linkedHashMap);
            this.asSet = Collections.unmodifiableSet(object2);
        }
        stringArray = entry.getAttributeValues(ATTR_ATTRIBUTE_TYPE);
        if (stringArray == null) {
            this.atMap = Collections.emptyMap();
            this.atSet = Collections.emptySet();
            this.operationalATSet = Collections.emptySet();
            this.userATSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap(2 * stringArray.length);
            object2 = new LinkedHashSet(stringArray.length);
            LinkedHashSet<AttributeTypeDefinition> linkedHashSet = new LinkedHashSet<AttributeTypeDefinition>(stringArray.length);
            LinkedHashSet<AttributeTypeDefinition> linkedHashSet2 = new LinkedHashSet<AttributeTypeDefinition>(stringArray.length);
            for (String string : stringArray) {
                try {
                    AttributeTypeDefinition attributeTypeDefinition = new AttributeTypeDefinition(string);
                    ((HashSet)object2).add(attributeTypeDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(attributeTypeDefinition.getOID()), (ObjectClassDefinition)((Object)attributeTypeDefinition));
                    String[] stringArray2 = attributeTypeDefinition.getNames();
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = stringArray2[i];
                        linkedHashMap.put(StaticUtils.toLowerCase(string2), (ObjectClassDefinition)((Object)attributeTypeDefinition));
                    }
                    if (attributeTypeDefinition.isOperational()) {
                        linkedHashSet2.add(attributeTypeDefinition);
                        continue;
                    }
                    linkedHashSet.add(attributeTypeDefinition);
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.atMap = Collections.unmodifiableMap(linkedHashMap);
            this.atSet = Collections.unmodifiableSet(object2);
            this.operationalATSet = Collections.unmodifiableSet(linkedHashSet2);
            this.userATSet = Collections.unmodifiableSet(linkedHashSet);
        }
        stringArray = entry.getAttributeValues(ATTR_DIT_CONTENT_RULE);
        if (stringArray == null) {
            this.dcrMap = Collections.emptyMap();
            this.dcrSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap(2 * stringArray.length);
            object2 = new LinkedHashSet(stringArray.length);
            for (String string : stringArray) {
                try {
                    DITContentRuleDefinition dITContentRuleDefinition = new DITContentRuleDefinition(string);
                    ((HashSet)object2).add(dITContentRuleDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(dITContentRuleDefinition.getOID()), (ObjectClassDefinition)((Object)dITContentRuleDefinition));
                    for (String string3 : dITContentRuleDefinition.getNames()) {
                        linkedHashMap.put(StaticUtils.toLowerCase(string3), (ObjectClassDefinition)((Object)dITContentRuleDefinition));
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.dcrMap = Collections.unmodifiableMap(linkedHashMap);
            this.dcrSet = Collections.unmodifiableSet(object2);
        }
        stringArray = entry.getAttributeValues(ATTR_DIT_STRUCTURE_RULE);
        if (stringArray == null) {
            this.dsrMapByID = Collections.emptyMap();
            this.dsrMapByName = Collections.emptyMap();
            this.dsrMapByNameForm = Collections.emptyMap();
            this.dsrSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap(stringArray.length);
            object2 = new LinkedHashMap(stringArray.length);
            LinkedHashMap<String, DITStructureRuleDefinition> linkedHashMap2 = new LinkedHashMap<String, DITStructureRuleDefinition>(stringArray.length);
            LinkedHashSet<DITStructureRuleDefinition> linkedHashSet = new LinkedHashSet<DITStructureRuleDefinition>(stringArray.length);
            for (String string : stringArray) {
                try {
                    DITStructureRuleDefinition dITStructureRuleDefinition = new DITStructureRuleDefinition(string);
                    linkedHashSet.add(dITStructureRuleDefinition);
                    linkedHashMap.put((String)((Object)Integer.valueOf(dITStructureRuleDefinition.getRuleID())), (ObjectClassDefinition)((Object)dITStructureRuleDefinition));
                    linkedHashMap2.put(StaticUtils.toLowerCase(dITStructureRuleDefinition.getNameFormID()), dITStructureRuleDefinition);
                    for (String string2 : dITStructureRuleDefinition.getNames()) {
                        ((HashMap)object2).put(StaticUtils.toLowerCase(string2), dITStructureRuleDefinition);
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.dsrMapByID = Collections.unmodifiableMap(linkedHashMap);
            this.dsrMapByName = Collections.unmodifiableMap(object2);
            this.dsrMapByNameForm = Collections.unmodifiableMap(linkedHashMap2);
            this.dsrSet = Collections.unmodifiableSet(linkedHashSet);
        }
        stringArray = entry.getAttributeValues(ATTR_MATCHING_RULE);
        if (stringArray == null) {
            this.mrMap = Collections.emptyMap();
            this.mrSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap(2 * stringArray.length);
            object2 = new LinkedHashSet(stringArray.length);
            for (String string : stringArray) {
                try {
                    MatchingRuleDefinition matchingRuleDefinition = new MatchingRuleDefinition(string);
                    ((HashSet)object2).add(matchingRuleDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(matchingRuleDefinition.getOID()), (ObjectClassDefinition)((Object)matchingRuleDefinition));
                    for (String string4 : matchingRuleDefinition.getNames()) {
                        linkedHashMap.put(StaticUtils.toLowerCase(string4), (ObjectClassDefinition)((Object)matchingRuleDefinition));
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.mrMap = Collections.unmodifiableMap(linkedHashMap);
            this.mrSet = Collections.unmodifiableSet(object2);
        }
        stringArray = entry.getAttributeValues(ATTR_MATCHING_RULE_USE);
        if (stringArray == null) {
            this.mruMap = Collections.emptyMap();
            this.mruSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap(2 * stringArray.length);
            object2 = new LinkedHashSet(stringArray.length);
            for (String string : stringArray) {
                try {
                    MatchingRuleUseDefinition matchingRuleUseDefinition = new MatchingRuleUseDefinition(string);
                    ((HashSet)object2).add(matchingRuleUseDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(matchingRuleUseDefinition.getOID()), (ObjectClassDefinition)((Object)matchingRuleUseDefinition));
                    for (String string5 : matchingRuleUseDefinition.getNames()) {
                        linkedHashMap.put(StaticUtils.toLowerCase(string5), (ObjectClassDefinition)((Object)matchingRuleUseDefinition));
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.mruMap = Collections.unmodifiableMap(linkedHashMap);
            this.mruSet = Collections.unmodifiableSet(object2);
        }
        stringArray = entry.getAttributeValues(ATTR_NAME_FORM);
        if (stringArray == null) {
            this.nfMapByName = Collections.emptyMap();
            this.nfMapByOC = Collections.emptyMap();
            this.nfSet = Collections.emptySet();
        } else {
            linkedHashMap = new LinkedHashMap(2 * stringArray.length);
            object2 = new LinkedHashMap(stringArray.length);
            LinkedHashSet<NameFormDefinition> linkedHashSet = new LinkedHashSet<NameFormDefinition>(stringArray.length);
            for (String string : stringArray) {
                try {
                    NameFormDefinition nameFormDefinition = new NameFormDefinition(string);
                    linkedHashSet.add(nameFormDefinition);
                    ((HashMap)object2).put(StaticUtils.toLowerCase(nameFormDefinition.getStructuralClass()), nameFormDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(nameFormDefinition.getOID()), (ObjectClassDefinition)((Object)nameFormDefinition));
                    for (String string6 : nameFormDefinition.getNames()) {
                        linkedHashMap.put(StaticUtils.toLowerCase(string6), (ObjectClassDefinition)((Object)nameFormDefinition));
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
            }
            this.nfMapByName = Collections.unmodifiableMap(linkedHashMap);
            this.nfMapByOC = Collections.unmodifiableMap(object2);
            this.nfSet = Collections.unmodifiableSet(linkedHashSet);
        }
        stringArray = entry.getAttributeValues(ATTR_OBJECT_CLASS);
        if (stringArray == null) {
            this.ocMap = Collections.emptyMap();
            this.ocSet = Collections.emptySet();
            this.abstractOCSet = Collections.emptySet();
            this.auxiliaryOCSet = Collections.emptySet();
            this.structuralOCSet = Collections.emptySet();
        } else {
            void var10_73;
            linkedHashMap = new LinkedHashMap(2 * stringArray.length);
            object2 = new LinkedHashSet(stringArray.length);
            LinkedHashSet<ObjectClassDefinition> linkedHashSet = new LinkedHashSet<ObjectClassDefinition>(stringArray.length);
            LinkedHashSet<ObjectClassDefinition> linkedHashSet3 = new LinkedHashSet<ObjectClassDefinition>(stringArray.length);
            LinkedHashSet<ObjectClassDefinition> linkedHashSet4 = new LinkedHashSet<ObjectClassDefinition>(stringArray.length);
            String[] stringArray3 = stringArray;
            int n = stringArray3.length;
            boolean bl = false;
            while (var10_73 < n) {
                String string = stringArray3[var10_73];
                try {
                    ObjectClassDefinition objectClassDefinition = new ObjectClassDefinition(string);
                    ((HashSet)object2).add(objectClassDefinition);
                    linkedHashMap.put(StaticUtils.toLowerCase(objectClassDefinition.getOID()), objectClassDefinition);
                    for (String string7 : objectClassDefinition.getNames()) {
                        linkedHashMap.put(StaticUtils.toLowerCase(string7), objectClassDefinition);
                    }
                    switch (Schema.getOCType(objectClassDefinition, linkedHashMap)) {
                        case ABSTRACT: {
                            linkedHashSet.add(objectClassDefinition);
                            break;
                        }
                        case AUXILIARY: {
                            linkedHashSet3.add(objectClassDefinition);
                            break;
                        }
                        case STRUCTURAL: {
                            linkedHashSet4.add(objectClassDefinition);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.debugException(lDAPException);
                }
                ++var10_73;
            }
            this.ocMap = Collections.unmodifiableMap(linkedHashMap);
            this.ocSet = Collections.unmodifiableSet(object2);
            this.abstractOCSet = Collections.unmodifiableSet(linkedHashSet);
            this.auxiliaryOCSet = Collections.unmodifiableSet(linkedHashSet3);
            this.structuralOCSet = Collections.unmodifiableSet(linkedHashSet4);
        }
        linkedHashMap = new LinkedHashMap(this.atSet.size());
        for (AttributeTypeDefinition attributeTypeDefinition : this.atSet) {
            for (AttributeTypeDefinition attributeTypeDefinition2 = attributeTypeDefinition.getSuperiorType(this); attributeTypeDefinition2 != null; attributeTypeDefinition2 = attributeTypeDefinition2.getSuperiorType(this)) {
                ArrayList<AttributeTypeDefinition> arrayList = (ArrayList<AttributeTypeDefinition>)linkedHashMap.get(attributeTypeDefinition2);
                if (arrayList == null) {
                    arrayList = new ArrayList<AttributeTypeDefinition>(1);
                    linkedHashMap.put((String)((Object)attributeTypeDefinition2), (ObjectClassDefinition)((Object)arrayList));
                }
                arrayList.add(attributeTypeDefinition);
            }
        }
        this.subordinateAttributeTypes = Collections.unmodifiableMap(linkedHashMap);
    }

    public static Schema getSchema(LDAPConnection lDAPConnection) throws LDAPException {
        return Schema.getSchema(lDAPConnection, "");
    }

    public static Schema getSchema(LDAPConnection lDAPConnection, String string) throws LDAPException {
        Validator.ensureNotNull(lDAPConnection);
        String string2 = string == null ? Schema.getSubschemaSubentryDN(lDAPConnection, "") : Schema.getSubschemaSubentryDN(lDAPConnection, string);
        if (string2 == null) {
            return null;
        }
        SearchResultEntry searchResultEntry = lDAPConnection.searchForEntry(string2, SearchScope.BASE, Filter.createEqualityFilter("objectClass", "subschema"), SCHEMA_REQUEST_ATTRS);
        if (searchResultEntry == null) {
            return null;
        }
        return new Schema(searchResultEntry);
    }

    public static Schema getSchema(String ... stringArray) throws IOException, LDIFException {
        Validator.ensureNotNull(stringArray);
        Validator.ensureFalse(stringArray.length == 0);
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new File(string));
        }
        return Schema.getSchema(arrayList);
    }

    public static Schema getSchema(File ... fileArray) throws IOException, LDIFException {
        Validator.ensureNotNull(fileArray);
        Validator.ensureFalse(fileArray.length == 0);
        return Schema.getSchema(Arrays.asList(fileArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getSchema(List<File> list) throws IOException, LDIFException {
        Validator.ensureNotNull(list);
        Validator.ensureFalse(list.isEmpty());
        Entry entry = null;
        for (File file : list) {
            LDIFReader lDIFReader = new LDIFReader(file);
            try {
                Entry entry2 = lDIFReader.readEntry();
                if (entry2 == null) continue;
                entry2.addAttribute("objectClass", "top", "ldapSubentry", "subschema");
                if (entry == null) {
                    entry = entry2;
                    continue;
                }
                for (Attribute attribute : entry2.getAttributes()) {
                    entry.addAttribute(attribute);
                }
            }
            finally {
                lDIFReader.close();
            }
        }
        if (entry == null) {
            return null;
        }
        return new Schema(entry);
    }

    public static Schema mergeSchemas(Schema ... schemaArray) {
        if (schemaArray == null || schemaArray.length == 0) {
            return null;
        }
        if (schemaArray.length == 1) {
            return schemaArray[0];
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap3 = new LinkedHashMap<String, String>();
        LinkedHashMap<Integer, String> linkedHashMap4 = new LinkedHashMap<Integer, String>();
        LinkedHashMap<String, String> linkedHashMap5 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap6 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap7 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap8 = new LinkedHashMap<String, String>();
        for (Schema schema : schemaArray) {
            for (AttributeSyntaxDefinition attributeSyntaxDefinition : schema.asSet) {
                linkedHashMap.put(StaticUtils.toLowerCase(attributeSyntaxDefinition.getOID()), attributeSyntaxDefinition.toString());
            }
            for (AttributeTypeDefinition attributeTypeDefinition : schema.atSet) {
                linkedHashMap2.put(StaticUtils.toLowerCase(attributeTypeDefinition.getOID()), attributeTypeDefinition.toString());
            }
            for (DITContentRuleDefinition dITContentRuleDefinition : schema.dcrSet) {
                linkedHashMap3.put(StaticUtils.toLowerCase(dITContentRuleDefinition.getOID()), dITContentRuleDefinition.toString());
            }
            for (DITStructureRuleDefinition dITStructureRuleDefinition : schema.dsrSet) {
                linkedHashMap4.put(dITStructureRuleDefinition.getRuleID(), dITStructureRuleDefinition.toString());
            }
            for (MatchingRuleDefinition matchingRuleDefinition : schema.mrSet) {
                linkedHashMap5.put(StaticUtils.toLowerCase(matchingRuleDefinition.getOID()), matchingRuleDefinition.toString());
            }
            for (MatchingRuleUseDefinition matchingRuleUseDefinition : schema.mruSet) {
                linkedHashMap6.put(StaticUtils.toLowerCase(matchingRuleUseDefinition.getOID()), matchingRuleUseDefinition.toString());
            }
            for (NameFormDefinition nameFormDefinition : schema.nfSet) {
                linkedHashMap7.put(StaticUtils.toLowerCase(nameFormDefinition.getOID()), nameFormDefinition.toString());
            }
            for (ObjectClassDefinition objectClassDefinition : schema.ocSet) {
                linkedHashMap8.put(StaticUtils.toLowerCase(objectClassDefinition.getOID()), objectClassDefinition.toString());
            }
        }
        Entry entry = new Entry(schemaArray[0].getSchemaEntry().getDN());
        Attribute attribute = schemaArray[0].getSchemaEntry().getObjectClassAttribute();
        if (attribute == null) {
            entry.addAttribute("objectClass", "top", "ldapSubEntry", "subschema");
        } else {
            entry.addAttribute(attribute);
        }
        if (!linkedHashMap.isEmpty()) {
            String[] stringArray = new String[linkedHashMap.size()];
            entry.addAttribute(ATTR_ATTRIBUTE_SYNTAX, linkedHashMap.values().toArray(stringArray));
        }
        if (!linkedHashMap5.isEmpty()) {
            String[] stringArray = new String[linkedHashMap5.size()];
            entry.addAttribute(ATTR_MATCHING_RULE, linkedHashMap5.values().toArray(stringArray));
        }
        if (!linkedHashMap2.isEmpty()) {
            String[] stringArray = new String[linkedHashMap2.size()];
            entry.addAttribute(ATTR_ATTRIBUTE_TYPE, linkedHashMap2.values().toArray(stringArray));
        }
        if (!linkedHashMap8.isEmpty()) {
            String[] stringArray = new String[linkedHashMap8.size()];
            entry.addAttribute(ATTR_OBJECT_CLASS, linkedHashMap8.values().toArray(stringArray));
        }
        if (!linkedHashMap3.isEmpty()) {
            String[] stringArray = new String[linkedHashMap3.size()];
            entry.addAttribute(ATTR_DIT_CONTENT_RULE, linkedHashMap3.values().toArray(stringArray));
        }
        if (!linkedHashMap4.isEmpty()) {
            String[] stringArray = new String[linkedHashMap4.size()];
            entry.addAttribute(ATTR_DIT_STRUCTURE_RULE, linkedHashMap4.values().toArray(stringArray));
        }
        if (!linkedHashMap7.isEmpty()) {
            String[] stringArray = new String[linkedHashMap7.size()];
            entry.addAttribute(ATTR_NAME_FORM, linkedHashMap7.values().toArray(stringArray));
        }
        if (!linkedHashMap6.isEmpty()) {
            String[] stringArray = new String[linkedHashMap6.size()];
            entry.addAttribute(ATTR_MATCHING_RULE_USE, linkedHashMap6.values().toArray(stringArray));
        }
        return new Schema(entry);
    }

    public ReadOnlyEntry getSchemaEntry() {
        return this.schemaEntry;
    }

    private static ObjectClassType getOCType(ObjectClassDefinition objectClassDefinition, Map<String, ObjectClassDefinition> map) {
        ObjectClassType objectClassType = objectClassDefinition.getObjectClassType();
        if (objectClassType != null) {
            return objectClassType;
        }
        for (String string : objectClassDefinition.getSuperiorClasses()) {
            ObjectClassDefinition objectClassDefinition2 = map.get(StaticUtils.toLowerCase(string));
            if (objectClassDefinition2 == null || (objectClassType = Schema.getOCType(objectClassDefinition2, map)) == null) continue;
            return objectClassType;
        }
        return ObjectClassType.STRUCTURAL;
    }

    public static String getSubschemaSubentryDN(LDAPConnection lDAPConnection, String string) throws LDAPException {
        Validator.ensureNotNull(lDAPConnection);
        SearchResultEntry searchResultEntry = string == null ? lDAPConnection.getEntry("", SUBSCHEMA_SUBENTRY_REQUEST_ATTRS) : lDAPConnection.getEntry(string, SUBSCHEMA_SUBENTRY_REQUEST_ATTRS);
        if (searchResultEntry == null) {
            return null;
        }
        return searchResultEntry.getAttributeValue(ATTR_SUBSCHEMA_SUBENTRY);
    }

    public Set<AttributeSyntaxDefinition> getAttributeSyntaxes() {
        return this.asSet;
    }

    public AttributeSyntaxDefinition getAttributeSyntax(String string) {
        Validator.ensureNotNull(string);
        String string2 = StaticUtils.toLowerCase(string);
        int n = string2.indexOf(123);
        if (n > 0) {
            return this.asMap.get(string2.substring(0, n));
        }
        return this.asMap.get(string2);
    }

    public Set<AttributeTypeDefinition> getAttributeTypes() {
        return this.atSet;
    }

    public Set<AttributeTypeDefinition> getOperationalAttributeTypes() {
        return this.operationalATSet;
    }

    public Set<AttributeTypeDefinition> getUserAttributeTypes() {
        return this.userATSet;
    }

    public AttributeTypeDefinition getAttributeType(String string) {
        Validator.ensureNotNull(string);
        return this.atMap.get(StaticUtils.toLowerCase(string));
    }

    public List<AttributeTypeDefinition> getSubordinateAttributeTypes(AttributeTypeDefinition attributeTypeDefinition) {
        Validator.ensureNotNull(attributeTypeDefinition);
        List<AttributeTypeDefinition> list = this.subordinateAttributeTypes.get(attributeTypeDefinition);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public Set<DITContentRuleDefinition> getDITContentRules() {
        return this.dcrSet;
    }

    public DITContentRuleDefinition getDITContentRule(String string) {
        Validator.ensureNotNull(string);
        return this.dcrMap.get(StaticUtils.toLowerCase(string));
    }

    public Set<DITStructureRuleDefinition> getDITStructureRules() {
        return this.dsrSet;
    }

    public DITStructureRuleDefinition getDITStructureRuleByID(int n) {
        return this.dsrMapByID.get(n);
    }

    public DITStructureRuleDefinition getDITStructureRuleByName(String string) {
        Validator.ensureNotNull(string);
        return this.dsrMapByName.get(StaticUtils.toLowerCase(string));
    }

    public DITStructureRuleDefinition getDITStructureRuleByNameForm(String string) {
        Validator.ensureNotNull(string);
        return this.dsrMapByNameForm.get(StaticUtils.toLowerCase(string));
    }

    public Set<MatchingRuleDefinition> getMatchingRules() {
        return this.mrSet;
    }

    public MatchingRuleDefinition getMatchingRule(String string) {
        Validator.ensureNotNull(string);
        return this.mrMap.get(StaticUtils.toLowerCase(string));
    }

    public Set<MatchingRuleUseDefinition> getMatchingRuleUses() {
        return this.mruSet;
    }

    public MatchingRuleUseDefinition getMatchingRuleUse(String string) {
        Validator.ensureNotNull(string);
        return this.mruMap.get(StaticUtils.toLowerCase(string));
    }

    public Set<NameFormDefinition> getNameForms() {
        return this.nfSet;
    }

    public NameFormDefinition getNameFormByName(String string) {
        Validator.ensureNotNull(string);
        return this.nfMapByName.get(StaticUtils.toLowerCase(string));
    }

    public NameFormDefinition getNameFormByObjectClass(String string) {
        Validator.ensureNotNull(string);
        return this.nfMapByOC.get(StaticUtils.toLowerCase(string));
    }

    public Set<ObjectClassDefinition> getObjectClasses() {
        return this.ocSet;
    }

    public Set<ObjectClassDefinition> getAbstractObjectClasses() {
        return this.abstractOCSet;
    }

    public Set<ObjectClassDefinition> getAuxiliaryObjectClasses() {
        return this.auxiliaryOCSet;
    }

    public Set<ObjectClassDefinition> getStructuralObjectClasses() {
        return this.structuralOCSet;
    }

    public ObjectClassDefinition getObjectClass(String string) {
        Validator.ensureNotNull(string);
        return this.ocMap.get(StaticUtils.toLowerCase(string));
    }

    public int hashCode() {
        int n;
        try {
            n = this.schemaEntry.getParsedDN().hashCode();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            n = StaticUtils.toLowerCase(this.schemaEntry.getDN()).hashCode();
        }
        Attribute attribute = this.schemaEntry.getAttribute(ATTR_ATTRIBUTE_SYNTAX);
        if (attribute != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_MATCHING_RULE)) != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_ATTRIBUTE_TYPE)) != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_OBJECT_CLASS)) != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_NAME_FORM)) != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_DIT_CONTENT_RULE)) != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_DIT_STRUCTURE_RULE)) != null) {
            n += attribute.hashCode();
        }
        if ((attribute = this.schemaEntry.getAttribute(ATTR_MATCHING_RULE_USE)) != null) {
            n += attribute.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        Schema schema;
        block6: {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Schema)) {
                return false;
            }
            schema = (Schema)object;
            try {
                if (!this.schemaEntry.getParsedDN().equals(schema.schemaEntry.getParsedDN())) {
                    return false;
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                if (this.schemaEntry.getDN().equalsIgnoreCase(schema.schemaEntry.getDN())) break block6;
                return false;
            }
        }
        return ((Object)this.asSet).equals(schema.asSet) && ((Object)this.mrSet).equals(schema.mrSet) && ((Object)this.atSet).equals(schema.atSet) && ((Object)this.ocSet).equals(schema.ocSet) && ((Object)this.nfSet).equals(schema.nfSet) && ((Object)this.dcrSet).equals(schema.dcrSet) && ((Object)this.dsrSet).equals(schema.dsrSet) && ((Object)this.mruSet).equals(schema.mruSet);
    }

    public String toString() {
        return this.schemaEntry.toString();
    }
}

