/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaElement
implements Serializable {
    private static final long serialVersionUID = -8249972237068748580L;

    static int skipSpaces(String string, int n, int n2) throws LDAPException {
        int n3;
        for (n3 = n; n3 < n2 && string.charAt(n3) == ' '; ++n3) {
        }
        if (n3 >= n2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_SKIP_SPACES_NO_CLOSE_PAREN.get(string));
        }
        return n3;
    }

    private static int readEscapedHexString(String string, int n, int n2, StringBuilder stringBuilder) throws LDAPException {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 - n3);
        for (n3 = n; n3 < n2; ++n3) {
            byte by;
            switch (string.charAt(n3++)) {
                case '0': {
                    by = 0;
                    break;
                }
                case '1': {
                    by = 16;
                    break;
                }
                case '2': {
                    by = 32;
                    break;
                }
                case '3': {
                    by = 48;
                    break;
                }
                case '4': {
                    by = 64;
                    break;
                }
                case '5': {
                    by = 80;
                    break;
                }
                case '6': {
                    by = 96;
                    break;
                }
                case '7': {
                    by = 112;
                    break;
                }
                case '8': {
                    by = -128;
                    break;
                }
                case '9': {
                    by = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    by = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    by = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    by = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    by = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    by = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    by = -16;
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, SchemaMessages.ERR_SCHEMA_ELEM_INVALID_HEX_CHAR.get(string, Character.valueOf(string.charAt(n3 - 1)), n3 - 1));
                }
            }
            if (n3 >= n2) {
                throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, SchemaMessages.ERR_SCHEMA_ELEM_MISSING_HEX_CHAR.get(string));
            }
            switch (string.charAt(n3++)) {
                case '0': {
                    break;
                }
                case '1': {
                    by = (byte)(by | 1);
                    break;
                }
                case '2': {
                    by = (byte)(by | 2);
                    break;
                }
                case '3': {
                    by = (byte)(by | 3);
                    break;
                }
                case '4': {
                    by = (byte)(by | 4);
                    break;
                }
                case '5': {
                    by = (byte)(by | 5);
                    break;
                }
                case '6': {
                    by = (byte)(by | 6);
                    break;
                }
                case '7': {
                    by = (byte)(by | 7);
                    break;
                }
                case '8': {
                    by = (byte)(by | 8);
                    break;
                }
                case '9': {
                    by = (byte)(by | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    by = (byte)(by | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    by = (byte)(by | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    by = (byte)(by | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    by = (byte)(by | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    by = (byte)(by | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    by = (byte)(by | 0xF);
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, SchemaMessages.ERR_SCHEMA_ELEM_INVALID_HEX_CHAR.get(string, Character.valueOf(string.charAt(n3 - 1)), n3 - 1));
                }
            }
            byteBuffer.put(by);
            if (n3 + 1 >= n2 || string.charAt(n3) != '\\' || !StaticUtils.isHex(string.charAt(n3 + 1))) break;
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        try {
            stringBuilder.append(StaticUtils.toUTF8String(byArray));
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            stringBuilder.append(new String(byArray));
        }
        return n3;
    }

    static int readQDString(String string, int n, int n2, StringBuilder stringBuilder) throws LDAPException {
        char c;
        if (string.charAt(n) != '\'') {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EXPECTED_SINGLE_QUOTE.get(string, n));
        }
        int n3 = n + 1;
        while (n3 < n2 && (c = string.charAt(n3++)) != '\'') {
            if (c == '\\') {
                if (n3 >= n2) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_ENDS_WITH_BACKSLASH.get(string));
                }
                n3 = SchemaElement.readEscapedHexString(string, n3, n2, stringBuilder);
                continue;
            }
            stringBuilder.append(c);
        }
        if (n3 >= n2 || string.charAt(n3) != ' ' && string.charAt(n3) != ')') {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_CLOSING_PAREN.get(string));
        }
        if (stringBuilder.length() == 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_QUOTES.get(string));
        }
        return n3;
    }

    static int readQDStrings(String string, int n, int n2, ArrayList<String> arrayList) throws LDAPException {
        char c = string.charAt(n);
        if (c == '\'') {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = SchemaElement.readQDString(string, n, n2, stringBuilder);
            arrayList.add(stringBuilder.toString());
            return n3;
        }
        if (c == '(') {
            int n4;
            block6: {
                n4 = n + 1;
                while (true) {
                    if ((c = string.charAt(n4 = SchemaElement.skipSpaces(string, n4, n2))) == ')') {
                        ++n4;
                        break block6;
                    }
                    if (c != '\'') break;
                    StringBuilder stringBuilder = new StringBuilder();
                    n4 = SchemaElement.readQDString(string, n4, n2, stringBuilder);
                    arrayList.add(stringBuilder.toString());
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EXPECTED_QUOTE_OR_PAREN.get(string, n));
            }
            if (arrayList.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_STRING_LIST.get(string));
            }
            if (n4 >= n2 || string.charAt(n4) != ' ' && string.charAt(n4) != ')') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_SPACE_AFTER_QUOTE.get(string));
            }
            return n4;
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EXPECTED_QUOTE_OR_PAREN.get(string, n));
    }

    static int readOID(String string, int n, int n2, StringBuilder stringBuilder) throws LDAPException {
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '$' || c == ')') {
                if (stringBuilder.length() == 0) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_OID.get(string));
                }
                return i;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '{' || c == '}') {
                if (bl) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_UNEXPECTED_CHAR_IN_OID.get(string, i - 1));
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\'') {
                if (stringBuilder.length() == 0) continue;
                bl = true;
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_UNEXPECTED_CHAR_IN_OID.get(string, i));
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_SPACE_AFTER_OID.get(string));
    }

    static int readOIDs(String string, int n, int n2, ArrayList<String> arrayList) throws LDAPException {
        char c = string.charAt(n);
        if (c == '(') {
            int n3;
            block6: {
                n3 = n + 1;
                while (true) {
                    StringBuilder stringBuilder;
                    if ((c = string.charAt(n3 = SchemaElement.skipSpaces(string, n3, n2))) == ')') {
                        ++n3;
                        break block6;
                    }
                    if (c == '$') {
                        ++n3;
                        n3 = SchemaElement.skipSpaces(string, n3, n2);
                        stringBuilder = new StringBuilder();
                        n3 = SchemaElement.readOID(string, n3, n2, stringBuilder);
                        arrayList.add(stringBuilder.toString());
                        continue;
                    }
                    if (!arrayList.isEmpty()) break;
                    stringBuilder = new StringBuilder();
                    n3 = SchemaElement.readOID(string, n3, n2, stringBuilder);
                    arrayList.add(stringBuilder.toString());
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_UNEXPECTED_CHAR_IN_OID_LIST.get(string, n3));
            }
            if (arrayList.isEmpty()) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_EMPTY_OID_LIST.get(string));
            }
            if (n3 >= n2) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_SCHEMA_ELEM_NO_SPACE_AFTER_OID_LIST.get(string));
            }
            return n3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = SchemaElement.readOID(string, n, n2, stringBuilder);
        arrayList.add(stringBuilder.toString());
        return n4;
    }

    static void encodeValue(String string, StringBuilder stringBuilder) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' || c > '~' || c == '\\' || c == '\'') {
                StaticUtils.hexEncode(c, stringBuilder);
                continue;
            }
            stringBuilder.append(c);
        }
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    protected static boolean extensionsEqual(Map<String, String[]> map, Map<String, String[]> map2) {
        if (map.isEmpty()) {
            return map2.isEmpty();
        }
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] stringArray;
            String[] stringArray2 = entry.getValue();
            if (StaticUtils.arraysEqualOrderIndependent(stringArray2, stringArray = map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public abstract String toString();
}

