/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFAddChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 4722916031463878423L;
    private final Attribute[] attributes;

    public LDIFAddChangeRecord(String string, Attribute ... attributeArray) {
        this(string, attributeArray, (List<Control>)null);
    }

    public LDIFAddChangeRecord(String string, Attribute[] attributeArray, List<Control> list) {
        super(string, list);
        Validator.ensureNotNull(attributeArray);
        Validator.ensureTrue(attributeArray.length > 0, "LDIFAddChangeRecord.attributes must not be empty.");
        this.attributes = attributeArray;
    }

    public LDIFAddChangeRecord(String string, List<Attribute> list) {
        this(string, list, null);
    }

    public LDIFAddChangeRecord(String string, List<Attribute> list, List<Control> list2) {
        super(string, list2);
        Validator.ensureNotNull(list);
        Validator.ensureFalse(list.isEmpty(), "LDIFAddChangeRecord.attributes must not be empty.");
        this.attributes = new Attribute[list.size()];
        list.toArray(this.attributes);
    }

    public LDIFAddChangeRecord(Entry entry) {
        this(entry, null);
    }

    public LDIFAddChangeRecord(Entry entry, List<Control> list) {
        super(entry.getDN(), list);
        Collection<Attribute> collection = entry.getAttributes();
        this.attributes = new Attribute[collection.size()];
        Iterator<Attribute> iterator = collection.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = iterator.next();
        }
    }

    public LDIFAddChangeRecord(AddRequest addRequest) {
        super(addRequest.getDN(), addRequest.getControlList());
        List<Attribute> list = addRequest.getAttributes();
        this.attributes = new Attribute[list.size()];
        Iterator<Attribute> iterator = list.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = iterator.next();
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public Entry getEntryToAdd() {
        return new Entry(this.getDN(), this.attributes);
    }

    public AddRequest toAddRequest() {
        return this.toAddRequest(true);
    }

    public AddRequest toAddRequest(boolean bl) {
        AddRequest addRequest = new AddRequest(this.getDN(), this.attributes);
        if (bl) {
            addRequest.setControls(this.getControls());
        }
        return addRequest;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.ADD;
    }

    @Override
    public LDAPResult processChange(LDAPInterface lDAPInterface, boolean bl) throws LDAPException {
        return lDAPInterface.add(this.toAddRequest(bl));
    }

    @Override
    public String[] toLDIF(int n) {
        List<String> list = new ArrayList<String>(2 * this.attributes.length);
        list.add(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())));
        for (Control control : this.getControls()) {
            list.add(LDIFWriter.encodeNameAndValue("control", LDIFAddChangeRecord.encodeControlString(control)));
        }
        list.add("changetype: add");
        for (Attribute attribute : this.attributes) {
            String string = attribute.getName();
            for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                list.add(LDIFWriter.encodeNameAndValue(string, aSN1OctetString));
            }
        }
        if (n > 2) {
            list = LDIFWriter.wrapLines(n, list);
        }
        Object[] objectArray = new String[list.size()];
        list.toArray(objectArray);
        return objectArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer byteStringBuffer, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        for (Control control : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFAddChangeRecord.encodeControlString(control), byteStringBuffer, n);
            byteStringBuffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("add"), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        for (Attribute attribute : this.attributes) {
            String string = attribute.getName();
            for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                LDIFWriter.encodeNameAndValue(string, aSN1OctetString, byteStringBuffer, n);
                byteStringBuffer.append(StaticUtils.EOL_BYTES);
            }
        }
    }

    @Override
    public void toLDIFString(StringBuilder stringBuilder, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        for (Control control : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFAddChangeRecord.encodeControlString(control), stringBuilder, n);
            stringBuilder.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("add"), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        for (Attribute attribute : this.attributes) {
            String string = attribute.getName();
            for (ASN1OctetString aSN1OctetString : attribute.getRawValues()) {
                LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder, n);
                stringBuilder.append(StaticUtils.EOL);
            }
        }
    }

    @Override
    public int hashCode() {
        try {
            int n = this.getParsedDN().hashCode();
            for (Attribute attribute : this.attributes) {
                n += attribute.hashCode();
            }
            return n;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return new Entry(this.getDN(), this.attributes).hashCode();
        }
    }

    @Override
    public boolean equals(Object object) {
        HashSet<Control> hashSet;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof LDIFAddChangeRecord)) {
            return false;
        }
        LDIFAddChangeRecord lDIFAddChangeRecord = (LDIFAddChangeRecord)object;
        HashSet<Control> hashSet2 = new HashSet<Control>(this.getControls());
        if (!hashSet2.equals(hashSet = new HashSet<Control>(lDIFAddChangeRecord.getControls()))) {
            return false;
        }
        Entry entry = new Entry(this.getDN(), this.attributes);
        Entry entry2 = new Entry(lDIFAddChangeRecord.getDN(), lDIFAddChangeRecord.attributes);
        return entry.equals(entry2);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDIFAddChangeRecord(dn='");
        stringBuilder.append(this.getDN());
        stringBuilder.append("', attrs={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.attributes[i].toString(stringBuilder);
        }
        stringBuilder.append('}');
        List<Control> list = this.getControls();
        if (!list.isEmpty()) {
            stringBuilder.append(", controls={");
            Iterator<Control> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(stringBuilder);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

