/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.DuplicateValueBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;

class LDIFAttribute
implements Serializable {
    private static final long serialVersionUID = -3771917482408643188L;
    private LinkedHashSet<ASN1OctetString> normalizedValues;
    private final ArrayList<ASN1OctetString> values;
    private final MatchingRule matchingRule;
    private final String name;

    LDIFAttribute(String string, MatchingRule matchingRule, ASN1OctetString aSN1OctetString) {
        this.name = string;
        this.matchingRule = matchingRule;
        this.values = new ArrayList(5);
        this.values.add(aSN1OctetString);
        this.normalizedValues = null;
    }

    boolean addValue(ASN1OctetString aSN1OctetString, DuplicateValueBehavior duplicateValueBehavior) throws LDAPException {
        if (this.normalizedValues == null) {
            this.normalizedValues = new LinkedHashSet();
            for (ASN1OctetString aSN1OctetString2 : this.values) {
                this.normalizedValues.add(this.matchingRule.normalize(aSN1OctetString2));
            }
        }
        if (this.normalizedValues.add(this.matchingRule.normalize(aSN1OctetString))) {
            this.values.add(aSN1OctetString);
            return true;
        }
        if (duplicateValueBehavior == DuplicateValueBehavior.RETAIN) {
            this.values.add(aSN1OctetString);
            return true;
        }
        return false;
    }

    Attribute toAttribute() {
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[this.values.size()];
        this.values.toArray(aSN1OctetStringArray);
        return new Attribute(this.name, this.matchingRule, aSN1OctetStringArray);
    }
}

