/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Validator;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LDIFChangeRecord
implements LDIFRecord {
    private static final long serialVersionUID = 6917212392170911115L;
    private final List<Control> controls;
    private volatile DN parsedDN;
    private final String dn;

    protected LDIFChangeRecord(String string, List<Control> list) {
        Validator.ensureNotNull(string);
        this.dn = string;
        this.parsedDN = null;
        this.controls = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Override
    public final String getDN() {
        return this.dn;
    }

    @Override
    public final DN getParsedDN() throws LDAPException {
        if (this.parsedDN == null) {
            this.parsedDN = new DN(this.dn);
        }
        return this.parsedDN;
    }

    public abstract ChangeType getChangeType();

    public List<Control> getControls() {
        return this.controls;
    }

    public final LDAPResult processChange(LDAPInterface lDAPInterface) throws LDAPException {
        return this.processChange(lDAPInterface, true);
    }

    public abstract LDAPResult processChange(LDAPInterface var1, boolean var2) throws LDAPException;

    final Entry toEntry() throws LDIFException {
        return new Entry(this.toLDIF());
    }

    @Override
    public final String[] toLDIF() {
        return this.toLDIF(0);
    }

    @Override
    public abstract String[] toLDIF(int var1);

    @Override
    public final void toLDIF(ByteStringBuffer byteStringBuffer) {
        this.toLDIF(byteStringBuffer, 0);
    }

    @Override
    public abstract void toLDIF(ByteStringBuffer var1, int var2);

    @Override
    public final String toLDIFString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIFString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    @Override
    public final String toLDIFString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIFString(stringBuilder, n);
        return stringBuilder.toString();
    }

    @Override
    public final void toLDIFString(StringBuilder stringBuilder) {
        this.toLDIFString(stringBuilder, 0);
    }

    @Override
    public abstract void toLDIFString(StringBuilder var1, int var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static ASN1OctetString encodeControlString(Control control) {
        ByteStringBuffer byteStringBuffer = new ByteStringBuffer();
        byteStringBuffer.append(control.getOID());
        if (control.isCritical()) {
            byteStringBuffer.append(" true");
        } else {
            byteStringBuffer.append(" false");
        }
        ASN1OctetString aSN1OctetString = control.getValue();
        if (aSN1OctetString != null) {
            LDIFWriter.encodeValue(aSN1OctetString, byteStringBuffer);
        }
        return byteStringBuffer.toByteString().toASN1OctetString();
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public abstract void toString(StringBuilder var1);
}

