/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFDeleteChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 9173178539060889790L;

    public LDIFDeleteChangeRecord(String string) {
        this(string, null);
    }

    public LDIFDeleteChangeRecord(String string, List<Control> list) {
        super(string, list);
    }

    public LDIFDeleteChangeRecord(DeleteRequest deleteRequest) {
        super(deleteRequest.getDN(), deleteRequest.getControlList());
    }

    public DeleteRequest toDeleteRequest() {
        return this.toDeleteRequest(true);
    }

    public DeleteRequest toDeleteRequest(boolean bl) {
        DeleteRequest deleteRequest = new DeleteRequest(this.getDN());
        if (bl) {
            deleteRequest.setControls(this.getControls());
        }
        return deleteRequest;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.DELETE;
    }

    @Override
    public LDAPResult processChange(LDAPInterface lDAPInterface, boolean bl) throws LDAPException {
        return lDAPInterface.delete(this.toDeleteRequest(bl));
    }

    @Override
    public String[] toLDIF(int n) {
        List<String> list = new ArrayList<String>(5);
        list.add(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())));
        for (Control control : this.getControls()) {
            list.add(LDIFWriter.encodeNameAndValue("control", LDIFDeleteChangeRecord.encodeControlString(control)));
        }
        list.add("changetype: delete");
        if (n > 2) {
            list = LDIFWriter.wrapLines(n, list);
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer byteStringBuffer, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        for (Control control : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFDeleteChangeRecord.encodeControlString(control), byteStringBuffer, n);
            byteStringBuffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("delete"), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
    }

    @Override
    public void toLDIFString(StringBuilder stringBuilder, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        for (Control control : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFDeleteChangeRecord.encodeControlString(control), stringBuilder, n);
            stringBuilder.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("delete"), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
    }

    @Override
    public int hashCode() {
        try {
            return this.getParsedDN().hashCode();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return StaticUtils.toLowerCase(this.getDN()).hashCode();
        }
    }

    @Override
    public boolean equals(Object object) {
        HashSet<Control> hashSet;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof LDIFDeleteChangeRecord)) {
            return false;
        }
        LDIFDeleteChangeRecord lDIFDeleteChangeRecord = (LDIFDeleteChangeRecord)object;
        HashSet<Control> hashSet2 = new HashSet<Control>(this.getControls());
        if (!hashSet2.equals(hashSet = new HashSet<Control>(lDIFDeleteChangeRecord.getControls()))) {
            return false;
        }
        try {
            return this.getParsedDN().equals(lDIFDeleteChangeRecord.getParsedDN());
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(lDIFDeleteChangeRecord.getDN()));
        }
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDIFDeleteChangeRecord(dn='");
        stringBuilder.append(this.getDN());
        stringBuilder.append('\'');
        List<Control> list = this.getControls();
        if (!list.isEmpty()) {
            stringBuilder.append(", controls={");
            Iterator<Control> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(stringBuilder);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }
}

