/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFModifyChangeRecord
extends LDIFChangeRecord {
    public static final String PROPERTY_ALWAYS_INCLUDE_TRAILING_DASH = "com.unboundid.ldif.modify.alwaysIncludeTrailingDash";
    private static boolean alwaysIncludeTrailingDash = true;
    private static final long serialVersionUID = -7558098319600288036L;
    private final Modification[] modifications;

    public LDIFModifyChangeRecord(String string, Modification ... modificationArray) {
        this(string, modificationArray, (List<Control>)null);
    }

    public LDIFModifyChangeRecord(String string, Modification[] modificationArray, List<Control> list) {
        super(string, list);
        Validator.ensureNotNull(modificationArray);
        Validator.ensureTrue(modificationArray.length > 0, "LDIFModifyChangeRecord.modifications must not be empty.");
        this.modifications = modificationArray;
    }

    public LDIFModifyChangeRecord(String string, List<Modification> list) {
        this(string, list, null);
    }

    public LDIFModifyChangeRecord(String string, List<Modification> list, List<Control> list2) {
        super(string, list2);
        Validator.ensureNotNull(list);
        Validator.ensureFalse(list.isEmpty(), "LDIFModifyChangeRecord.modifications must not be empty.");
        this.modifications = new Modification[list.size()];
        list.toArray(this.modifications);
    }

    public LDIFModifyChangeRecord(ModifyRequest modifyRequest) {
        super(modifyRequest.getDN(), modifyRequest.getControlList());
        List<Modification> list = modifyRequest.getModifications();
        this.modifications = new Modification[list.size()];
        Iterator<Modification> iterator = list.iterator();
        for (int i = 0; i < this.modifications.length; ++i) {
            this.modifications[i] = iterator.next();
        }
    }

    public static boolean alwaysIncludeTrailingDash() {
        return alwaysIncludeTrailingDash;
    }

    public static void setAlwaysIncludeTrailingDash(boolean bl) {
        alwaysIncludeTrailingDash = bl;
    }

    public Modification[] getModifications() {
        return this.modifications;
    }

    public ModifyRequest toModifyRequest() {
        return this.toModifyRequest(true);
    }

    public ModifyRequest toModifyRequest(boolean bl) {
        ModifyRequest modifyRequest = new ModifyRequest(this.getDN(), this.modifications);
        if (bl) {
            modifyRequest.setControls(this.getControls());
        }
        return modifyRequest;
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY;
    }

    @Override
    public LDAPResult processChange(LDAPInterface lDAPInterface, boolean bl) throws LDAPException {
        return lDAPInterface.modify(this.toModifyRequest(bl));
    }

    @Override
    public String[] toLDIF(int n) {
        List<String> list = new ArrayList<String>(this.modifications.length * 4);
        list.add(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())));
        for (Control object : this.getControls()) {
            list.add(LDIFWriter.encodeNameAndValue("control", LDIFModifyChangeRecord.encodeControlString(object)));
        }
        list.add("changetype: modify");
        block7: for (int i = 0; i < this.modifications.length; ++i) {
            String string = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    list.add("add: " + string);
                    break;
                }
                case 1: {
                    list.add("delete: " + string);
                    break;
                }
                case 2: {
                    list.add("replace: " + string);
                    break;
                }
                case 3: {
                    list.add("increment: " + string);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            for (ASN1OctetString aSN1OctetString : this.modifications[i].getRawValues()) {
                list.add(LDIFWriter.encodeNameAndValue(string, aSN1OctetString));
            }
            if (!alwaysIncludeTrailingDash && i >= this.modifications.length - 1) continue;
            list.add("-");
        }
        if (n > 2) {
            list = LDIFWriter.wrapLines(n, list);
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer byteStringBuffer, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        for (Control object : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFModifyChangeRecord.encodeControlString(object), byteStringBuffer, n);
            byteStringBuffer.append(StaticUtils.EOL_BYTES);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("modify"), byteStringBuffer, n);
        byteStringBuffer.append(StaticUtils.EOL_BYTES);
        block7: for (int i = 0; i < this.modifications.length; ++i) {
            String string = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    LDIFWriter.encodeNameAndValue("add", new ASN1OctetString(string), byteStringBuffer, n);
                    byteStringBuffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 1: {
                    LDIFWriter.encodeNameAndValue("delete", new ASN1OctetString(string), byteStringBuffer, n);
                    byteStringBuffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 2: {
                    LDIFWriter.encodeNameAndValue("replace", new ASN1OctetString(string), byteStringBuffer, n);
                    byteStringBuffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 3: {
                    LDIFWriter.encodeNameAndValue("increment", new ASN1OctetString(string), byteStringBuffer, n);
                    byteStringBuffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            for (ASN1OctetString aSN1OctetString : this.modifications[i].getRawValues()) {
                LDIFWriter.encodeNameAndValue(string, aSN1OctetString, byteStringBuffer, n);
                byteStringBuffer.append(StaticUtils.EOL_BYTES);
            }
            if (!alwaysIncludeTrailingDash && i >= this.modifications.length - 1) continue;
            byteStringBuffer.append('-');
            byteStringBuffer.append(StaticUtils.EOL_BYTES);
        }
    }

    @Override
    public void toLDIFString(StringBuilder stringBuilder, int n) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        for (Control object : this.getControls()) {
            LDIFWriter.encodeNameAndValue("control", LDIFModifyChangeRecord.encodeControlString(object), stringBuilder, n);
            stringBuilder.append(StaticUtils.EOL);
        }
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("modify"), stringBuilder, n);
        stringBuilder.append(StaticUtils.EOL);
        block7: for (int i = 0; i < this.modifications.length; ++i) {
            String string = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    LDIFWriter.encodeNameAndValue("add", new ASN1OctetString(string), stringBuilder, n);
                    stringBuilder.append(StaticUtils.EOL);
                    break;
                }
                case 1: {
                    LDIFWriter.encodeNameAndValue("delete", new ASN1OctetString(string), stringBuilder, n);
                    stringBuilder.append(StaticUtils.EOL);
                    break;
                }
                case 2: {
                    LDIFWriter.encodeNameAndValue("replace", new ASN1OctetString(string), stringBuilder, n);
                    stringBuilder.append(StaticUtils.EOL);
                    break;
                }
                case 3: {
                    LDIFWriter.encodeNameAndValue("increment", new ASN1OctetString(string), stringBuilder, n);
                    stringBuilder.append(StaticUtils.EOL);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            for (ASN1OctetString aSN1OctetString : this.modifications[i].getRawValues()) {
                LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder, n);
                stringBuilder.append(StaticUtils.EOL);
            }
            if (!alwaysIncludeTrailingDash && i >= this.modifications.length - 1) continue;
            stringBuilder.append('-');
            stringBuilder.append(StaticUtils.EOL);
        }
    }

    @Override
    public int hashCode() {
        int n;
        try {
            n = this.getParsedDN().hashCode();
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            n = StaticUtils.toLowerCase(this.getDN()).hashCode();
        }
        for (Modification modification : this.modifications) {
            n += modification.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        LDIFModifyChangeRecord lDIFModifyChangeRecord;
        block9: {
            HashSet<Control> hashSet;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof LDIFModifyChangeRecord)) {
                return false;
            }
            lDIFModifyChangeRecord = (LDIFModifyChangeRecord)object;
            HashSet<Control> hashSet2 = new HashSet<Control>(this.getControls());
            if (!hashSet2.equals(hashSet = new HashSet<Control>(lDIFModifyChangeRecord.getControls()))) {
                return false;
            }
            try {
                if (!this.getParsedDN().equals(lDIFModifyChangeRecord.getParsedDN())) {
                    return false;
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                if (StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(lDIFModifyChangeRecord.getDN()))) break block9;
                return false;
            }
        }
        if (this.modifications.length != lDIFModifyChangeRecord.modifications.length) {
            return false;
        }
        for (int i = 0; i < this.modifications.length; ++i) {
            if (this.modifications[i].equals(lDIFModifyChangeRecord.modifications[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("LDIFModifyChangeRecord(dn='");
        stringBuilder.append(this.getDN());
        stringBuilder.append("', mods={");
        for (int i = 0; i < this.modifications.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.modifications[i].toString(stringBuilder);
        }
        stringBuilder.append('}');
        List<Control> list = this.getControls();
        if (!list.isEmpty()) {
            stringBuilder.append(", controls={");
            Iterator<Control> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().toString(stringBuilder);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append('}');
        }
        stringBuilder.append(')');
    }

    static {
        String string = System.getProperty(PROPERTY_ALWAYS_INCLUDE_TRAILING_DASH);
        if (string != null && string.equalsIgnoreCase("false")) {
            alwaysIncludeTrailingDash = false;
        }
    }
}

