/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriterChangeRecordTranslator;
import com.unboundid.ldif.LDIFWriterEntryTranslator;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDIFWriter {
    private static final byte[] VERSION_1_HEADER_BYTES = StaticUtils.getBytes("version: 1" + StaticUtils.EOL);
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final BufferedOutputStream writer;
    private final ByteStringBuffer buffer;
    private final LDIFWriterChangeRecordTranslator changeRecordTranslator;
    private final LDIFWriterEntryTranslator entryTranslator;
    private int wrapColumn = 0;
    private int wrapColumnMinusTwo = -2;
    private final ParallelProcessor<LDIFRecord, ByteStringBuffer> toLdifBytesInvoker;

    public LDIFWriter(String string) throws IOException {
        this(new FileOutputStream(string));
    }

    public LDIFWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public LDIFWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public LDIFWriter(OutputStream outputStream, int n) {
        this(outputStream, n, null);
    }

    public LDIFWriter(OutputStream outputStream, int n, LDIFWriterEntryTranslator lDIFWriterEntryTranslator) {
        this(outputStream, n, lDIFWriterEntryTranslator, null);
    }

    public LDIFWriter(OutputStream outputStream, int n, final LDIFWriterEntryTranslator lDIFWriterEntryTranslator, final LDIFWriterChangeRecordTranslator lDIFWriterChangeRecordTranslator) {
        Validator.ensureNotNull(outputStream);
        Validator.ensureTrue(n >= 0, "LDIFWriter.parallelThreads must not be negative.");
        this.entryTranslator = lDIFWriterEntryTranslator;
        this.changeRecordTranslator = lDIFWriterChangeRecordTranslator;
        this.buffer = new ByteStringBuffer();
        this.writer = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 131072);
        if (n == 0) {
            this.toLdifBytesInvoker = null;
        } else {
            LDAPSDKThreadFactory lDAPSDKThreadFactory = new LDAPSDKThreadFactory("LDIFWriter Worker", true, null);
            this.toLdifBytesInvoker = new ParallelProcessor<LDIFRecord, ByteStringBuffer>(new Processor<LDIFRecord, ByteStringBuffer>(){

                @Override
                public ByteStringBuffer process(LDIFRecord lDIFRecord) throws IOException {
                    LDIFRecord lDIFRecord2;
                    if (lDIFWriterEntryTranslator != null && lDIFRecord instanceof Entry) {
                        lDIFRecord2 = lDIFWriterEntryTranslator.translateEntryToWrite((Entry)lDIFRecord);
                        if (lDIFRecord2 == null) {
                            return null;
                        }
                    } else if (lDIFWriterChangeRecordTranslator != null && lDIFRecord instanceof LDIFChangeRecord) {
                        lDIFRecord2 = lDIFWriterChangeRecordTranslator.translateChangeRecordToWrite((LDIFChangeRecord)lDIFRecord);
                        if (lDIFRecord2 == null) {
                            return null;
                        }
                    } else {
                        lDIFRecord2 = lDIFRecord;
                    }
                    ByteStringBuffer byteStringBuffer = new ByteStringBuffer(200);
                    lDIFRecord2.toLDIF(byteStringBuffer, LDIFWriter.this.wrapColumn);
                    return byteStringBuffer;
                }
            }, lDAPSDKThreadFactory, n, 5);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.toLdifBytesInvoker != null) {
                try {
                    this.toLdifBytesInvoker.shutdown();
                }
                catch (InterruptedException interruptedException) {
                    Debug.debugException(interruptedException);
                }
            }
        }
        finally {
            this.writer.close();
        }
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int n) {
        this.wrapColumn = n;
        this.wrapColumnMinusTwo = n - 2;
    }

    public void writeVersionHeader() throws IOException {
        this.writer.write(VERSION_1_HEADER_BYTES);
    }

    public void writeEntry(Entry entry) throws IOException {
        this.writeEntry(entry, null);
    }

    public void writeEntry(Entry entry, String string) throws IOException {
        Entry entry2;
        Validator.ensureNotNull(entry);
        if (this.entryTranslator == null) {
            entry2 = entry;
        } else {
            entry2 = this.entryTranslator.translateEntryToWrite(entry);
            if (entry2 == null) {
                return;
            }
        }
        if (string != null) {
            this.writeComment(string, false, false);
        }
        Debug.debugLDIFWrite(entry2);
        this.writeLDIF(entry2);
    }

    public void writeChangeRecord(LDIFChangeRecord lDIFChangeRecord) throws IOException {
        this.writeChangeRecord(lDIFChangeRecord, null);
    }

    public void writeChangeRecord(LDIFChangeRecord lDIFChangeRecord, String string) throws IOException {
        LDIFChangeRecord lDIFChangeRecord2;
        Validator.ensureNotNull(lDIFChangeRecord);
        if (this.changeRecordTranslator == null) {
            lDIFChangeRecord2 = lDIFChangeRecord;
        } else {
            lDIFChangeRecord2 = this.changeRecordTranslator.translateChangeRecordToWrite(lDIFChangeRecord);
            if (lDIFChangeRecord2 == null) {
                return;
            }
        }
        if (string != null) {
            this.writeComment(string, false, false);
        }
        Debug.debugLDIFWrite(lDIFChangeRecord2);
        this.writeLDIF(lDIFChangeRecord2);
    }

    public void writeLDIFRecord(LDIFRecord lDIFRecord) throws IOException {
        this.writeLDIFRecord(lDIFRecord, null);
    }

    public void writeLDIFRecord(LDIFRecord lDIFRecord, String string) throws IOException {
        LDIFRecord lDIFRecord2;
        Validator.ensureNotNull(lDIFRecord);
        if (this.entryTranslator != null && lDIFRecord instanceof Entry) {
            lDIFRecord2 = this.entryTranslator.translateEntryToWrite((Entry)lDIFRecord);
            if (lDIFRecord2 == null) {
                return;
            }
        } else if (this.changeRecordTranslator != null && lDIFRecord instanceof LDIFChangeRecord) {
            lDIFRecord2 = this.changeRecordTranslator.translateChangeRecordToWrite((LDIFChangeRecord)lDIFRecord);
            if (lDIFRecord2 == null) {
                return;
            }
        } else {
            lDIFRecord2 = lDIFRecord;
        }
        Debug.debugLDIFWrite(lDIFRecord2);
        if (string != null) {
            this.writeComment(string, false, false);
        }
        this.writeLDIF(lDIFRecord2);
    }

    public void writeLDIFRecords(List<? extends LDIFRecord> list) throws IOException, InterruptedException {
        if (this.toLdifBytesInvoker == null) {
            for (LDIFRecord lDIFRecord : list) {
                this.writeLDIFRecord(lDIFRecord);
            }
        } else {
            ArrayList<Result<? extends LDIFRecord, ByteStringBuffer>> arrayList = this.toLdifBytesInvoker.processAll(list);
            for (Result result : arrayList) {
                LDIFWriter.rethrow(result.getFailureCause());
                ByteStringBuffer byteStringBuffer = (ByteStringBuffer)result.getOutput();
                if (byteStringBuffer == null) continue;
                byteStringBuffer.write(this.writer);
                this.writer.write(StaticUtils.EOL_BYTES);
            }
        }
    }

    public void writeComment(String string, boolean bl, boolean bl2) throws IOException {
        Validator.ensureNotNull(string);
        if (bl) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
        if (string.indexOf(10) < 0) {
            this.writeSingleLineComment(string);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\r?\\n")) {
                this.writeSingleLineComment(string2);
            }
        }
        if (bl2) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
    }

    private void writeSingleLineComment(String string) throws IOException {
        int n = this.wrapColumn <= 0 ? 77 : this.wrapColumnMinusTwo;
        this.buffer.clear();
        int n2 = string.length();
        if (n2 <= n) {
            this.buffer.append("# ");
            this.buffer.append(string);
            this.buffer.append(StaticUtils.EOL_BYTES);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                if (n2 - n3 <= n) {
                    this.buffer.append("# ");
                    this.buffer.append(string.substring(n3));
                    this.buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                boolean bl = false;
                for (n5 = n4 = n3 + n; n5 > n3; --n5) {
                    if (string.charAt(n5) != ' ') continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (n5 = n4 + 1; n5 < n2; ++n5) {
                        if (string.charAt(n5) != ' ') continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.buffer.append("# ");
                        this.buffer.append(string.substring(n3));
                        this.buffer.append(StaticUtils.EOL_BYTES);
                        break;
                    }
                }
                this.buffer.append("# ");
                this.buffer.append(string.substring(n3, n5));
                this.buffer.append(StaticUtils.EOL_BYTES);
                for (n3 = n5 + 1; n3 < n2 && string.charAt(n3) == ' '; ++n3) {
                }
            }
        }
        this.buffer.write(this.writer);
    }

    private void writeLDIF(LDIFRecord lDIFRecord) throws IOException {
        this.buffer.clear();
        lDIFRecord.toLDIF(this.buffer, this.wrapColumn);
        this.buffer.append(StaticUtils.EOL_BYTES);
        this.buffer.write(this.writer);
    }

    public static List<String> wrapLines(int n, String ... stringArray) {
        return LDIFWriter.wrapLines(n, Arrays.asList(stringArray));
    }

    public static List<String> wrapLines(int n, List<String> list) {
        if (n <= 2) {
            return new ArrayList<String>(list);
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        block0: for (String string : list) {
            int n2 = string.length();
            if (n2 <= n) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(string.substring(0, n));
            for (int i = n; i < n2; i += n - 1) {
                if (n2 - i + 1 <= n) {
                    arrayList.add(' ' + string.substring(i));
                    continue block0;
                }
                arrayList.add(' ' + string.substring(i, i + n - 1));
            }
        }
        return arrayList;
    }

    public static String encodeNameAndValue(String string, ASN1OctetString aSN1OctetString) {
        StringBuilder stringBuilder = new StringBuilder();
        LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder);
        return stringBuilder.toString();
    }

    public static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, StringBuilder stringBuilder) {
        LDIFWriter.encodeNameAndValue(string, aSN1OctetString, stringBuilder, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, StringBuilder stringBuilder, int n) {
        int n2 = stringBuilder.length();
        try {
            stringBuilder.append(string);
            stringBuilder.append(':');
            byte[] byArray = aSN1OctetString.getValue();
            int n3 = byArray.length;
            if (n3 == 0) {
                stringBuilder.append(' ');
                Object var9_7 = null;
                if (n <= 2) return;
                int n4 = stringBuilder.length() - n2;
                if (n4 <= n) return;
                String string2 = StaticUtils.EOL + ' ';
                stringBuilder.insert(n2 + n, string2);
                for (int i = n2 + 2 * n + string2.length() - 1; i < stringBuilder.length(); i += n - 1 + string2.length()) {
                    stringBuilder.insert(i, string2);
                }
                return;
            }
            switch (byArray[0]) {
                case 32: 
                case 58: 
                case 60: {
                    stringBuilder.append(": ");
                    Base64.encode(byArray, stringBuilder);
                    Object var9_8 = null;
                    if (n <= 2) return;
                    int n5 = stringBuilder.length() - n2;
                    if (n5 <= n) return;
                    String string3 = StaticUtils.EOL + ' ';
                    stringBuilder.insert(n2 + n, string3);
                    for (int i = n2 + 2 * n + string3.length() - 1; i < stringBuilder.length(); i += n - 1 + string3.length()) {
                        stringBuilder.insert(i, string3);
                    }
                    return;
                }
            }
            if (byArray[n3 - 1] == 32) {
                stringBuilder.append(": ");
                Base64.encode(byArray, stringBuilder);
                Object var9_9 = null;
                if (n <= 2) return;
                int n6 = stringBuilder.length() - n2;
                if (n6 <= n) return;
                String string4 = StaticUtils.EOL + ' ';
                stringBuilder.insert(n2 + n, string4);
                for (int i = n2 + 2 * n + string4.length() - 1; i < stringBuilder.length(); i += n - 1 + string4.length()) {
                    stringBuilder.insert(i, string4);
                }
                return;
            }
            for (int i = 0; i < n3; ++i) {
                if ((byArray[i] & 0x7F) != (byArray[i] & 0xFF)) {
                    stringBuilder.append(": ");
                    Base64.encode(byArray, stringBuilder);
                    Object var9_10 = null;
                    if (n <= 2) return;
                    int n7 = stringBuilder.length() - n2;
                    if (n7 <= n) return;
                    String string5 = StaticUtils.EOL + ' ';
                    stringBuilder.insert(n2 + n, string5);
                    for (int j = n2 + 2 * n + string5.length() - 1; j < stringBuilder.length(); j += n - 1 + string5.length()) {
                        stringBuilder.insert(j, string5);
                    }
                    return;
                }
                switch (byArray[i]) {
                    case 0: 
                    case 10: 
                    case 13: {
                        stringBuilder.append(": ");
                        Base64.encode(byArray, stringBuilder);
                        Object var9_11 = null;
                        if (n <= 2) return;
                        int n8 = stringBuilder.length() - n2;
                        if (n8 <= n) return;
                        String string6 = StaticUtils.EOL + ' ';
                        stringBuilder.insert(n2 + n, string6);
                        for (int j = n2 + 2 * n + string6.length() - 1; j < stringBuilder.length(); j += n - 1 + string6.length()) {
                            stringBuilder.insert(j, string6);
                        }
                        return;
                    }
                }
            }
            stringBuilder.append(' ');
            stringBuilder.append(aSN1OctetString.stringValue());
            Object var9_12 = null;
            if (n <= 2) return;
        }
        catch (Throwable throwable) {
            int n9;
            Object var9_13 = null;
            if (n <= 2 || (n9 = stringBuilder.length() - n2) <= n) throw throwable;
            String string7 = StaticUtils.EOL + ' ';
            stringBuilder.insert(n2 + n, string7);
            for (int i = n2 + 2 * n + string7.length() - 1; i < stringBuilder.length(); i += n - 1 + string7.length()) {
                stringBuilder.insert(i, string7);
            }
            throw throwable;
        }
        int n10 = stringBuilder.length() - n2;
        if (n10 <= n) return;
        String string8 = StaticUtils.EOL + ' ';
        stringBuilder.insert(n2 + n, string8);
        for (int i = n2 + 2 * n + string8.length() - 1; i < stringBuilder.length(); i += n - 1 + string8.length()) {
            stringBuilder.insert(i, string8);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void encodeNameAndValue(String string, ASN1OctetString aSN1OctetString, ByteStringBuffer byteStringBuffer, int n) {
        int n2 = byteStringBuffer.length();
        try {
            byteStringBuffer.append(string);
            LDIFWriter.encodeValue(aSN1OctetString, byteStringBuffer);
            Object var6_5 = null;
            if (n <= 2) return;
            int n3 = byteStringBuffer.length() - n2;
            if (n3 <= n) return;
        }
        catch (Throwable throwable) {
            int n4;
            Object var6_6 = null;
            if (n <= 2 || (n4 = byteStringBuffer.length() - n2) <= n) throw throwable;
            byte[] byArray = new byte[StaticUtils.EOL_BYTES.length + 1];
            System.arraycopy(StaticUtils.EOL_BYTES, 0, byArray, 0, StaticUtils.EOL_BYTES.length);
            byArray[StaticUtils.EOL_BYTES.length] = 32;
            byteStringBuffer.insert(n2 + n, byArray);
            for (int i = n2 + 2 * n + byArray.length - 1; i < byteStringBuffer.length(); i += n - 1 + byArray.length) {
                byteStringBuffer.insert(i, byArray);
            }
            throw throwable;
        }
        byte[] byArray = new byte[StaticUtils.EOL_BYTES.length + 1];
        System.arraycopy(StaticUtils.EOL_BYTES, 0, byArray, 0, StaticUtils.EOL_BYTES.length);
        byArray[StaticUtils.EOL_BYTES.length] = 32;
        byteStringBuffer.insert(n2 + n, byArray);
        for (int i = n2 + 2 * n + byArray.length - 1; i < byteStringBuffer.length(); i += n - 1 + byArray.length) {
            byteStringBuffer.insert(i, byArray);
        }
        return;
    }

    static void encodeValue(ASN1OctetString aSN1OctetString, ByteStringBuffer byteStringBuffer) {
        byteStringBuffer.append(':');
        byte[] byArray = aSN1OctetString.getValue();
        int n = byArray.length;
        if (n == 0) {
            byteStringBuffer.append(' ');
            return;
        }
        switch (byArray[0]) {
            case 32: 
            case 58: 
            case 60: {
                byteStringBuffer.append(':');
                byteStringBuffer.append(' ');
                Base64.encode(byArray, byteStringBuffer);
                return;
            }
        }
        if (byArray[n - 1] == 32) {
            byteStringBuffer.append(':');
            byteStringBuffer.append(' ');
            Base64.encode(byArray, byteStringBuffer);
            return;
        }
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0x7F) != (byArray[i] & 0xFF)) {
                byteStringBuffer.append(':');
                byteStringBuffer.append(' ');
                Base64.encode(byArray, byteStringBuffer);
                return;
            }
            switch (byArray[i]) {
                case 0: 
                case 10: 
                case 13: {
                    byteStringBuffer.append(':');
                    byteStringBuffer.append(' ');
                    Base64.encode(byArray, byteStringBuffer);
                    return;
                }
            }
        }
        byteStringBuffer.append(' ');
        byteStringBuffer.append(byArray);
    }

    static void rethrow(Throwable throwable) throws IOException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw StaticUtils.createIOExceptionWithCause(null, throwable);
    }
}

