/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregateInputStream
extends InputStream {
    private volatile InputStream activeInputStream;
    private final Iterator<InputStream> streamIterator;

    public AggregateInputStream(InputStream ... inputStreamArray) {
        this(StaticUtils.toList(inputStreamArray));
    }

    public AggregateInputStream(Collection<? extends InputStream> collection) {
        Validator.ensureNotNull(collection);
        ArrayList<? extends InputStream> arrayList = new ArrayList<InputStream>(collection);
        this.streamIterator = arrayList.iterator();
        this.activeInputStream = null;
    }

    public AggregateInputStream(File ... fileArray) throws IOException {
        Validator.ensureNotNull(fileArray);
        ArrayList<FileInputStream> arrayList = new ArrayList<FileInputStream>(fileArray.length);
        IOException iOException = null;
        for (File file : fileArray) {
            try {
                arrayList.add(new FileInputStream(file));
            }
            catch (IOException iOException2) {
                Debug.debugException(iOException2);
                iOException = iOException2;
                break;
            }
        }
        if (iOException != null) {
            for (InputStream inputStream : arrayList) {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                }
            }
            throw iOException;
        }
        this.streamIterator = arrayList.iterator();
        this.activeInputStream = null;
    }

    @Override
    public int read() throws IOException {
        int n;
        while (true) {
            if (this.activeInputStream == null) {
                if (this.streamIterator.hasNext()) {
                    this.activeInputStream = this.streamIterator.next();
                    continue;
                }
                return -1;
            }
            n = this.activeInputStream.read();
            if (n >= 0) break;
            this.activeInputStream.close();
            this.activeInputStream = null;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        while (true) {
            if (this.activeInputStream == null) {
                if (this.streamIterator.hasNext()) {
                    this.activeInputStream = this.streamIterator.next();
                    continue;
                }
                return -1;
            }
            n3 = this.activeInputStream.read(byArray, n, n2);
            if (n3 >= 0) break;
            this.activeInputStream.close();
            this.activeInputStream = null;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.activeInputStream == null) {
            if (this.streamIterator.hasNext()) {
                this.activeInputStream = this.streamIterator.next();
                return this.activeInputStream.skip(l);
            }
            return 0L;
        }
        return this.activeInputStream.skip(l);
    }

    @Override
    public int available() throws IOException {
        if (this.activeInputStream == null) {
            if (this.streamIterator.hasNext()) {
                this.activeInputStream = this.streamIterator.next();
                return this.activeInputStream.available();
            }
            return 0;
        }
        return this.activeInputStream.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException(UtilityMessages.ERR_AGGREGATE_INPUT_STREAM_MARK_NOT_SUPPORTED.get());
    }

    @Override
    public void close() throws IOException {
        IOException iOException = null;
        if (this.activeInputStream != null) {
            try {
                this.activeInputStream.close();
            }
            catch (IOException iOException2) {
                Debug.debugException(iOException2);
                iOException = iOException2;
            }
            this.activeInputStream = null;
        }
        while (this.streamIterator.hasNext()) {
            InputStream inputStream = this.streamIterator.next();
            try {
                inputStream.close();
            }
            catch (IOException iOException3) {
                Debug.debugException(iOException3);
                if (iOException != null) continue;
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

