/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.ByteString;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.UtilityMessages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class ByteStringBuffer
implements Serializable,
Appendable {
    private static final int DEFAULT_INITIAL_CAPACITY = 20;
    private static final byte[] FALSE_VALUE_BYTES = StaticUtils.getBytes("false");
    private static final byte[] TRUE_VALUE_BYTES = StaticUtils.getBytes("true");
    private static final ThreadLocal<byte[]> TEMP_NUMBER_BUFFER = new ThreadLocal();
    private static final long serialVersionUID = 2899392249591230998L;
    private byte[] array;
    private int capacity;
    private int endPos;

    public ByteStringBuffer() {
        this(20);
    }

    public ByteStringBuffer(int n) {
        this.array = new byte[n];
        this.capacity = n;
        this.endPos = 0;
    }

    public ByteStringBuffer append(boolean bl) {
        if (bl) {
            return this.append(TRUE_VALUE_BYTES, 0, 4);
        }
        return this.append(FALSE_VALUE_BYTES, 0, 5);
    }

    public ByteStringBuffer append(byte by) {
        this.ensureCapacity(this.endPos + 1);
        this.array[this.endPos++] = by;
        return this;
    }

    public ByteStringBuffer append(byte[] byArray) throws NullPointerException {
        if (byArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.append(byArray, 0, byArray.length);
    }

    public ByteStringBuffer append(byte[] byArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException {
        if (byArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(n) : (n2 < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n2) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(n, n2, byArray.length));
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n2 > 0) {
            this.ensureCapacity(this.endPos + n2);
            System.arraycopy(byArray, n, this.array, this.endPos, n2);
            this.endPos += n2;
        }
        return this;
    }

    public ByteStringBuffer append(ByteString byteString) throws NullPointerException {
        if (byteString == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        byteString.appendValueTo(this);
        return this;
    }

    public ByteStringBuffer append(ByteStringBuffer byteStringBuffer) throws NullPointerException {
        if (byteStringBuffer == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.append(byteStringBuffer.array, 0, byteStringBuffer.endPos);
    }

    public ByteStringBuffer append(char c) {
        byte by = (byte)(c & 0x7F);
        if (by == c) {
            this.ensureCapacity(this.endPos + 1);
            this.array[this.endPos++] = by;
        } else {
            this.append(String.valueOf(c));
        }
        return this;
    }

    public ByteStringBuffer append(char[] cArray) throws NullPointerException {
        if (cArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.append(cArray, 0, cArray.length);
    }

    public ByteStringBuffer append(char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException {
        if (cArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(n) : (n2 < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n2) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(n, n2, cArray.length));
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n2 > 0) {
            this.ensureCapacity(this.endPos + n2);
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                byte by = (byte)(cArray[n3] & 0x7F);
                if (by != cArray[n3]) {
                    this.append(String.valueOf(cArray, n3, n + n2 - n3));
                    break;
                }
                this.array[this.endPos++] = by;
                ++n4;
                ++n3;
            }
        }
        return this;
    }

    public ByteStringBuffer append(CharSequence charSequence) throws NullPointerException {
        return this.append(charSequence, 0, charSequence.length());
    }

    public ByteStringBuffer append(CharSequence charSequence, int n, int n2) throws NullPointerException, IndexOutOfBoundsException {
        if (charSequence == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        int n3 = n2 - n;
        this.ensureCapacity(this.endPos + n3);
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            byte by = (byte)(c & 0x7F);
            if (by != c) {
                this.append(StaticUtils.getBytes(((Object)charSequence.subSequence(i, n3)).toString()));
                break;
            }
            this.array[this.endPos++] = by;
        }
        return this;
    }

    public ByteStringBuffer append(int n) {
        int n2 = ByteStringBuffer.getBytes(n);
        return this.append(TEMP_NUMBER_BUFFER.get(), 0, n2);
    }

    public ByteStringBuffer append(long l) {
        int n = ByteStringBuffer.getBytes(l);
        return this.append(TEMP_NUMBER_BUFFER.get(), 0, n);
    }

    public ByteStringBuffer insert(int n, boolean bl) throws IndexOutOfBoundsException {
        if (bl) {
            return this.insert(n, TRUE_VALUE_BYTES, 0, 4);
        }
        return this.insert(n, FALSE_VALUE_BYTES, 0, 5);
    }

    public ByteStringBuffer insert(int n, byte by) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.endPos) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(n) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(n, this.endPos);
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n == this.endPos) {
            return this.append(by);
        }
        this.ensureCapacity(this.endPos + 1);
        System.arraycopy(this.array, n, this.array, n + 1, this.endPos - n);
        this.array[n] = by;
        ++this.endPos;
        return this;
    }

    public ByteStringBuffer insert(int n, byte[] byArray) throws NullPointerException, IndexOutOfBoundsException {
        if (byArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.insert(n, byArray, 0, byArray.length);
    }

    public ByteStringBuffer insert(int n, byte[] byArray, int n2, int n3) throws NullPointerException, IndexOutOfBoundsException {
        if (byArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        if (n < 0 || n > this.endPos || n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(n) : (n > this.endPos ? UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(n, this.endPos) : (n2 < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(n2) : (n3 < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n3) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(n2, n3, byArray.length))));
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n3 == 0) {
            return this;
        }
        if (n == this.endPos) {
            return this.append(byArray, n2, n3);
        }
        this.ensureCapacity(this.endPos + n3);
        System.arraycopy(this.array, n, this.array, n + n3, this.endPos - n);
        System.arraycopy(byArray, n2, this.array, n, n3);
        this.endPos += n3;
        return this;
    }

    public ByteStringBuffer insert(int n, ByteString byteString) throws NullPointerException, IndexOutOfBoundsException {
        if (byteString == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.insert(n, byteString.getValue());
    }

    public ByteStringBuffer insert(int n, ByteStringBuffer byteStringBuffer) throws NullPointerException, IndexOutOfBoundsException {
        if (byteStringBuffer == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.insert(n, byteStringBuffer.array, 0, byteStringBuffer.endPos);
    }

    public ByteStringBuffer insert(int n, char c) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.endPos) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(n) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(n, this.endPos);
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n == this.endPos) {
            return this.append(c);
        }
        byte by = (byte)(c & 0x7F);
        if (by == c) {
            this.ensureCapacity(this.endPos + 1);
            System.arraycopy(this.array, n, this.array, n + 1, this.endPos - n);
            this.array[n] = by;
            ++this.endPos;
        } else {
            this.insert(n, String.valueOf(c));
        }
        return this;
    }

    public ByteStringBuffer insert(int n, char[] cArray) throws NullPointerException, IndexOutOfBoundsException {
        if (cArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.insert(n, new String(cArray, 0, cArray.length));
    }

    public ByteStringBuffer insert(int n, char[] cArray, int n2, int n3) throws NullPointerException, IndexOutOfBoundsException {
        if (cArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        return this.insert(n, new String(cArray, n2, n3));
    }

    public ByteStringBuffer insert(int n, CharSequence charSequence) throws NullPointerException, IndexOutOfBoundsException {
        if (charSequence == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        if (n < 0 || n > this.endPos) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_POS_NEGATIVE.get(n) : UtilityMessages.ERR_BS_BUFFER_POS_TOO_LARGE.get(n, this.endPos);
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n == this.endPos) {
            return this.append(charSequence);
        }
        return this.insert(n, StaticUtils.getBytes(((Object)charSequence).toString()));
    }

    public ByteStringBuffer insert(int n, int n2) throws IndexOutOfBoundsException {
        int n3 = ByteStringBuffer.getBytes(n2);
        return this.insert(n, TEMP_NUMBER_BUFFER.get(), 0, n3);
    }

    public ByteStringBuffer insert(int n, long l) throws IndexOutOfBoundsException {
        int n2 = ByteStringBuffer.getBytes(l);
        return this.insert(n, TEMP_NUMBER_BUFFER.get(), 0, n2);
    }

    public ByteStringBuffer delete(int n) throws IndexOutOfBoundsException {
        return this.delete(0, n);
    }

    public ByteStringBuffer delete(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(n));
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n2));
        }
        if (n + n2 > this.endPos) {
            throw new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(n, n2, this.endPos));
        }
        if (n2 == 0) {
            return this;
        }
        if (n == 0) {
            if (n2 == this.endPos) {
                this.endPos = 0;
                return this;
            }
            int n3 = this.endPos - n2;
            System.arraycopy(this.array, n2, this.array, 0, n3);
            this.endPos = n3;
            return this;
        }
        if (n + n2 == this.endPos) {
            this.endPos = n;
            return this;
        }
        int n4 = this.endPos - (n + n2);
        System.arraycopy(this.array, n + n2, this.array, n, n4);
        this.endPos -= n2;
        return this;
    }

    public ByteStringBuffer set(boolean bl) {
        if (bl) {
            return this.set(TRUE_VALUE_BYTES, 0, 4);
        }
        return this.set(FALSE_VALUE_BYTES, 0, 5);
    }

    public ByteStringBuffer set(byte by) {
        this.endPos = 0;
        return this.append(by);
    }

    public ByteStringBuffer set(byte[] byArray) throws NullPointerException {
        if (byArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        this.endPos = 0;
        return this.append(byArray, 0, byArray.length);
    }

    public ByteStringBuffer set(byte[] byArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException {
        if (byArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(n) : (n2 < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n2) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(n, n2, byArray.length));
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        this.endPos = 0;
        return this.append(byArray, n, n2);
    }

    public ByteStringBuffer set(ByteString byteString) throws NullPointerException {
        if (byteString == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BYTE_STRING_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        this.endPos = 0;
        byteString.appendValueTo(this);
        return this;
    }

    public ByteStringBuffer set(ByteStringBuffer byteStringBuffer) throws NullPointerException {
        if (byteStringBuffer == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_BUFFER_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        this.endPos = 0;
        return this.append(byteStringBuffer.array, 0, byteStringBuffer.endPos);
    }

    public ByteStringBuffer set(char c) {
        this.endPos = 0;
        return this.append(c);
    }

    public ByteStringBuffer set(char[] cArray) throws NullPointerException {
        if (cArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        this.endPos = 0;
        return this.append(cArray, 0, cArray.length);
    }

    public ByteStringBuffer set(char[] cArray, int n, int n2) throws NullPointerException, IndexOutOfBoundsException {
        if (cArray == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_ARRAY_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            String string = n < 0 ? UtilityMessages.ERR_BS_BUFFER_OFFSET_NEGATIVE.get(n) : (n2 < 0 ? UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n2) : UtilityMessages.ERR_BS_BUFFER_OFFSET_PLUS_LENGTH_TOO_LARGE.get(n, n2, cArray.length));
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        this.endPos = 0;
        return this.append(cArray, n, n2);
    }

    public ByteStringBuffer set(CharSequence charSequence) throws NullPointerException {
        if (charSequence == null) {
            NullPointerException nullPointerException = new NullPointerException(UtilityMessages.ERR_BS_BUFFER_CHAR_SEQUENCE_NULL.get());
            Debug.debugCodingError(nullPointerException);
            throw nullPointerException;
        }
        this.endPos = 0;
        return this.append(charSequence);
    }

    public ByteStringBuffer set(int n) {
        int n2 = ByteStringBuffer.getBytes(n);
        return this.set(TEMP_NUMBER_BUFFER.get(), 0, n2);
    }

    public ByteStringBuffer set(long l) {
        int n = ByteStringBuffer.getBytes(l);
        return this.set(TEMP_NUMBER_BUFFER.get(), 0, n);
    }

    public ByteStringBuffer clear() {
        this.endPos = 0;
        return this;
    }

    public ByteStringBuffer clear(boolean bl) {
        this.endPos = 0;
        if (bl) {
            Arrays.fill(this.array, (byte)0);
        }
        return this;
    }

    public byte[] getBackingArray() {
        return this.array;
    }

    public boolean isEmpty() {
        return this.endPos == 0;
    }

    public int length() {
        return this.endPos;
    }

    public void setLength(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_LENGTH_NEGATIVE.get(n));
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (n > this.endPos) {
            this.ensureCapacity(n);
            Arrays.fill(this.array, this.endPos, n, (byte)0);
            this.endPos = n;
        } else {
            this.endPos = n;
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public void ensureCapacity(int n) {
        if (this.capacity < n) {
            int n2 = Math.max(n, 2 * this.capacity + 2);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.array, 0, byArray, 0, this.capacity);
            this.array = byArray;
            this.capacity = n2;
        }
    }

    public void setCapacity(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(UtilityMessages.ERR_BS_BUFFER_CAPACITY_NEGATIVE.get(n));
            Debug.debugCodingError(indexOutOfBoundsException);
            throw indexOutOfBoundsException;
        }
        if (this.capacity == n) {
            return;
        }
        if (this.capacity < n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.array, 0, byArray, 0, this.capacity);
            this.array = byArray;
            this.capacity = n;
        } else {
            byte[] byArray = new byte[n];
            System.arraycopy(this.array, 0, byArray, 0, n);
            this.array = byArray;
            this.endPos = Math.min(this.endPos, n);
            this.capacity = n;
        }
    }

    public ByteStringBuffer trimToSize() {
        if (this.endPos != this.capacity) {
            byte[] byArray = new byte[this.endPos];
            System.arraycopy(this.array, 0, byArray, 0, this.endPos);
            this.array = byArray;
            this.capacity = this.endPos;
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.endPos];
        System.arraycopy(this.array, 0, byArray, 0, this.endPos);
        return byArray;
    }

    public ByteString toByteString() {
        return new ASN1OctetString(this.toByteArray());
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.array, 0, this.endPos);
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.array, 0, this.endPos);
    }

    private static int getBytes(long l) {
        byte[] byArray = TEMP_NUMBER_BUFFER.get();
        if (byArray == null) {
            byArray = new byte[20];
            TEMP_NUMBER_BUFFER.set(byArray);
        }
        if (l == Long.MIN_VALUE) {
            byArray[0] = 45;
            byArray[1] = 57;
            byArray[2] = 50;
            byArray[3] = 50;
            byArray[4] = 51;
            byArray[5] = 51;
            byArray[6] = 55;
            byArray[7] = 50;
            byArray[8] = 48;
            byArray[9] = 51;
            byArray[10] = 54;
            byArray[11] = 56;
            byArray[12] = 53;
            byArray[13] = 52;
            byArray[14] = 55;
            byArray[15] = 55;
            byArray[16] = 53;
            byArray[17] = 56;
            byArray[18] = 48;
            byArray[19] = 56;
            return 20;
        }
        if (l == 0L) {
            byArray[0] = 48;
            return 1;
        }
        int n = 0;
        long l2 = l;
        if (l < 0L) {
            byArray[0] = 45;
            n = 1;
            l2 = Math.abs(l);
        }
        long l3 = l2 <= 9L ? 1L : (l2 <= 99L ? 10L : (l2 <= 999L ? 100L : (l2 <= 9999L ? 1000L : (l2 <= 99999L ? 10000L : (l2 <= 999999L ? 100000L : (l2 <= 9999999L ? 1000000L : (l2 <= 99999999L ? 10000000L : (l2 <= 999999999L ? 100000000L : (l2 <= 9999999999L ? 1000000000L : (l2 <= 99999999999L ? 10000000000L : (l2 <= 999999999999L ? 100000000000L : (l2 <= 9999999999999L ? 1000000000000L : (l2 <= 99999999999999L ? 10000000000000L : (l2 <= 999999999999999L ? 100000000000000L : (l2 <= 9999999999999999L ? 1000000000000000L : (l2 <= 99999999999999999L ? 10000000000000000L : (l2 <= 999999999999999999L ? 100000000000000000L : 1000000000000000000L)))))))))))))))));
        while (true) {
            long l4 = l2 / l3;
            switch ((int)l4) {
                case 0: {
                    byArray[n++] = 48;
                    break;
                }
                case 1: {
                    byArray[n++] = 49;
                    break;
                }
                case 2: {
                    byArray[n++] = 50;
                    break;
                }
                case 3: {
                    byArray[n++] = 51;
                    break;
                }
                case 4: {
                    byArray[n++] = 52;
                    break;
                }
                case 5: {
                    byArray[n++] = 53;
                    break;
                }
                case 6: {
                    byArray[n++] = 54;
                    break;
                }
                case 7: {
                    byArray[n++] = 55;
                    break;
                }
                case 8: {
                    byArray[n++] = 56;
                    break;
                }
                case 9: {
                    byArray[n++] = 57;
                }
            }
            if (l3 == 1L) break;
            if ((l2 -= l3 * l4) == 0L) {
                while (l3 > 1L) {
                    byArray[n++] = 48;
                    l3 /= 10L;
                }
                break;
            }
            l3 /= 10L;
        }
        return n;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.endPos; ++i) {
            n += this.array[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteStringBuffer)) {
            return false;
        }
        ByteStringBuffer byteStringBuffer = (ByteStringBuffer)object;
        if (this.endPos != byteStringBuffer.endPos) {
            return false;
        }
        for (int i = 0; i < this.endPos; ++i) {
            if (this.array[i] == byteStringBuffer.array[i]) continue;
            return false;
        }
        return true;
    }

    public ByteStringBuffer duplicate() {
        ByteStringBuffer byteStringBuffer = new ByteStringBuffer(this.endPos);
        return byteStringBuffer.append(this);
    }

    public String toString() {
        return StaticUtils.toUTF8String(this.array, 0, this.endPos);
    }
}

