/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.util.DebugType;
import com.unboundid.util.StaticUtils;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Debug
implements Serializable {
    public static final String PROPERTY_DEBUG_ENABLED = "com.unboundid.ldap.sdk.debug.enabled";
    public static final String PROPERTY_INCLUDE_STACK_TRACE = "com.unboundid.ldap.sdk.debug.includeStackTrace";
    public static final String PROPERTY_DEBUG_LEVEL = "com.unboundid.ldap.sdk.debug.level";
    public static final String PROPERTY_DEBUG_TYPE = "com.unboundid.ldap.sdk.debug.type";
    public static final String LOGGER_NAME = "com.unboundid.ldap.sdk";
    private static final Logger logger = Logger.getLogger("com.unboundid.ldap.sdk");
    private static final long serialVersionUID = -6079754380415146030L;
    private static boolean debugEnabled;
    private static boolean includeStackTrace;
    private static EnumSet<DebugType> debugTypes;

    private Debug() {
    }

    public static void initialize() {
        includeStackTrace = false;
        debugEnabled = false;
        debugTypes = EnumSet.allOf(DebugType.class);
        logger.setLevel(Level.ALL);
    }

    public static void initialize(Properties properties) {
        Object object;
        String string;
        String string2;
        Debug.initialize();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String string3 = properties.getProperty(PROPERTY_DEBUG_ENABLED);
        if (string3 != null && string3.length() > 0) {
            if (string3.equalsIgnoreCase("true")) {
                debugEnabled = true;
            } else if (string3.equalsIgnoreCase("false")) {
                debugEnabled = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + string3 + "' for property " + PROPERTY_DEBUG_ENABLED + ".  The value must be either " + "'true' or 'false'.");
            }
        }
        if ((string2 = properties.getProperty(PROPERTY_INCLUDE_STACK_TRACE)) != null && string2.length() > 0) {
            if (string2.equalsIgnoreCase("true")) {
                includeStackTrace = true;
            } else if (string2.equalsIgnoreCase("false")) {
                includeStackTrace = false;
            } else {
                throw new IllegalArgumentException("Invalid value '" + string2 + "' for property " + PROPERTY_INCLUDE_STACK_TRACE + ".  The value must be either " + "'true' or 'false'.");
            }
        }
        if ((string = properties.getProperty(PROPERTY_DEBUG_TYPE)) != null && string.length() > 0) {
            debugTypes = EnumSet.noneOf(DebugType.class);
            object = new StringTokenizer(string, ", ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                DebugType debugType = DebugType.forName(string4);
                if (debugType == null) {
                    throw new IllegalArgumentException("Invalid value '" + string4 + "' for property " + PROPERTY_DEBUG_TYPE + ".  Allowed values include:  " + DebugType.getTypeNameList() + '.');
                }
                debugTypes.add(debugType);
            }
        }
        if ((object = properties.getProperty(PROPERTY_DEBUG_LEVEL)) != null && ((String)object).length() > 0) {
            logger.setLevel(Level.parse((String)object));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static boolean debugEnabled() {
        return debugEnabled;
    }

    public static boolean debugEnabled(DebugType debugType) {
        return debugEnabled && debugTypes.contains((Object)debugType);
    }

    public static void setEnabled(boolean bl) {
        debugTypes = EnumSet.allOf(DebugType.class);
        debugEnabled = bl;
    }

    public static void setEnabled(boolean bl, Set<DebugType> set) {
        debugTypes = set == null || set.isEmpty() ? EnumSet.allOf(DebugType.class) : EnumSet.copyOf(set);
        debugEnabled = bl;
    }

    public static boolean includeStackTrace() {
        return includeStackTrace;
    }

    public static void setIncludeStackTrace(boolean bl) {
        includeStackTrace = bl;
    }

    public static EnumSet<DebugType> getDebugTypes() {
        return debugTypes;
    }

    public static void debugException(Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            Debug.debugException(Level.WARNING, throwable);
        }
    }

    public static void debugException(Level level, Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.EXCEPTION)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("caughtException=\"");
            StaticUtils.getStackTrace(throwable, stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString(), throwable);
        }
    }

    public static void debugConnect(String string, int n) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, string, n, null);
        }
    }

    public static void debugConnect(Level level, String string, int n) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(level, string, n, null);
        }
    }

    public static void debugConnect(String string, int n, LDAPConnection lDAPConnection) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugConnect(Level.INFO, string, n, lDAPConnection);
        }
    }

    public static void debugConnect(Level level, String string, int n, LDAPConnection lDAPConnection) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("connectedTo=\"");
            stringBuilder.append(string);
            stringBuilder.append(':');
            stringBuilder.append(n);
            stringBuilder.append('\"');
            if (lDAPConnection != null) {
                String string2;
                stringBuilder.append(" connectionID=");
                stringBuilder.append(lDAPConnection.getConnectionID());
                String string3 = lDAPConnection.getConnectionName();
                if (string3 != null) {
                    stringBuilder.append(" connectionName=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append('\"');
                }
                if ((string2 = lDAPConnection.getConnectionPoolName()) != null) {
                    stringBuilder.append(" connectionPoolName=\"");
                    stringBuilder.append(string2);
                    stringBuilder.append('\"');
                }
            }
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugDisconnect(String string, int n, DisconnectType disconnectType, String string2, Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, string, n, null, disconnectType, string2, throwable);
        }
    }

    public static void debugDisconnect(Level level, String string, int n, DisconnectType disconnectType, String string2, Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(level, string, n, null, disconnectType, string2, throwable);
        }
    }

    public static void debugDisconnect(String string, int n, LDAPConnection lDAPConnection, DisconnectType disconnectType, String string2, Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            Debug.debugDisconnect(Level.INFO, string, n, lDAPConnection, disconnectType, string2, throwable);
        }
    }

    public static void debugDisconnect(Level level, String string, int n, LDAPConnection lDAPConnection, DisconnectType disconnectType, String string2, Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CONNECT)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            if (lDAPConnection != null) {
                String string3;
                stringBuilder.append("connectionID=");
                stringBuilder.append(lDAPConnection.getConnectionID());
                String string4 = lDAPConnection.getConnectionName();
                if (string4 != null) {
                    stringBuilder.append(" connectionName=\"");
                    stringBuilder.append(string4);
                    stringBuilder.append('\"');
                }
                if ((string3 = lDAPConnection.getConnectionPoolName()) != null) {
                    stringBuilder.append(" connectionPoolName=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append('\"');
                }
                stringBuilder.append(' ');
            }
            stringBuilder.append("disconnectedFrom=\"");
            stringBuilder.append(string);
            stringBuilder.append(':');
            stringBuilder.append(n);
            stringBuilder.append("\" disconnectType=\"");
            stringBuilder.append(disconnectType.name());
            stringBuilder.append('\"');
            if (string2 != null) {
                stringBuilder.append("\" disconnectMessage=\"");
                stringBuilder.append(string2);
                stringBuilder.append('\"');
            }
            if (throwable != null) {
                stringBuilder.append("\" disconnectCause=\"");
                StaticUtils.getStackTrace(throwable, stringBuilder);
                stringBuilder.append('\"');
            }
            logger.log(level, stringBuilder.toString(), lDAPConnection);
        }
    }

    public static void debugLDAPRequest(LDAPRequest lDAPRequest) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, lDAPRequest, -1, null);
        }
    }

    public static void debugLDAPRequest(Level level, LDAPRequest lDAPRequest) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(level, lDAPRequest, -1, null);
        }
    }

    public static void debugLDAPRequest(LDAPRequest lDAPRequest, int n, LDAPConnection lDAPConnection) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPRequest(Level.INFO, lDAPRequest, n, lDAPConnection);
        }
    }

    public static void debugLDAPRequest(Level level, LDAPRequest lDAPRequest, int n, LDAPConnection lDAPConnection) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            if (lDAPConnection != null) {
                String string;
                stringBuilder.append("connectionID=");
                stringBuilder.append(lDAPConnection.getConnectionID());
                String string2 = lDAPConnection.getConnectionName();
                if (string2 != null) {
                    stringBuilder.append(" connectionName=\"");
                    stringBuilder.append(string2);
                    stringBuilder.append('\"');
                }
                if ((string = lDAPConnection.getConnectionPoolName()) != null) {
                    stringBuilder.append(" connectionPoolName=\"");
                    stringBuilder.append(string);
                    stringBuilder.append('\"');
                }
                stringBuilder.append(" connectedTo=\"");
                stringBuilder.append(lDAPConnection.getConnectedAddress());
                stringBuilder.append(':');
                stringBuilder.append(lDAPConnection.getConnectedPort());
                stringBuilder.append("\" ");
            }
            if (n >= 0) {
                stringBuilder.append(" messageID=");
                stringBuilder.append(n);
                stringBuilder.append(' ');
            }
            stringBuilder.append("sendingLDAPRequest=\"");
            lDAPRequest.toString(stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugLDAPResult(LDAPResponse lDAPResponse) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, lDAPResponse, null);
        }
    }

    public static void debugLDAPResult(Level level, LDAPResponse lDAPResponse) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(level, lDAPResponse, null);
        }
    }

    public static void debugLDAPResult(LDAPResponse lDAPResponse, LDAPConnection lDAPConnection) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            Debug.debugLDAPResult(Level.INFO, lDAPResponse, lDAPConnection);
        }
    }

    public static void debugLDAPResult(Level level, LDAPResponse lDAPResponse, LDAPConnection lDAPConnection) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDAP)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            if (lDAPConnection != null) {
                String string;
                stringBuilder.append("connectionID=");
                stringBuilder.append(lDAPConnection.getConnectionID());
                String string2 = lDAPConnection.getConnectionName();
                if (string2 != null) {
                    stringBuilder.append(" connectionName=\"");
                    stringBuilder.append(string2);
                    stringBuilder.append('\"');
                }
                if ((string = lDAPConnection.getConnectionPoolName()) != null) {
                    stringBuilder.append(" connectionPoolName=\"");
                    stringBuilder.append(string);
                    stringBuilder.append('\"');
                }
                stringBuilder.append(" connectedTo=\"");
                stringBuilder.append(lDAPConnection.getConnectedAddress());
                stringBuilder.append(':');
                stringBuilder.append(lDAPConnection.getConnectedPort());
                stringBuilder.append("\" ");
            }
            stringBuilder.append("readLDAPResult=\"");
            lDAPResponse.toString(stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugASN1Write(ASN1Element aSN1Element) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, aSN1Element);
        }
    }

    public static void debugASN1Write(Level level, ASN1Element aSN1Element) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("writingASN1Element=\"");
            aSN1Element.toString(stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugASN1Write(ASN1Buffer aSN1Buffer) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Write(Level.INFO, aSN1Buffer);
        }
    }

    public static void debugASN1Write(Level level, ASN1Buffer aSN1Buffer) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("writingASN1Element=\"");
            StaticUtils.toHex(aSN1Buffer.toByteArray(), stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugASN1Read(ASN1Element aSN1Element) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            Debug.debugASN1Read(Level.INFO, aSN1Element);
        }
    }

    public static void debugASN1Read(Level level, ASN1Element aSN1Element) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("readASN1Element=\"");
            aSN1Element.toString(stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugASN1Read(Level level, String string, int n, int n2, Object object) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.ASN1)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("readASN1Element=\"dataType='");
            stringBuilder.append(string);
            stringBuilder.append("' berType='");
            stringBuilder.append(StaticUtils.toHex((byte)(n & 0xFF)));
            stringBuilder.append('\'');
            stringBuilder.append("' valueLength=");
            stringBuilder.append(n2);
            if (object != null) {
                stringBuilder.append(" value='");
                if (object instanceof byte[]) {
                    StaticUtils.toHex((byte[])object, stringBuilder);
                } else {
                    stringBuilder.append(object);
                }
                stringBuilder.append('\'');
            }
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugLDIFWrite(LDIFRecord lDIFRecord) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFWrite(Level.INFO, lDIFRecord);
        }
    }

    public static void debugLDIFWrite(Level level, LDIFRecord lDIFRecord) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("writingLDIFRecord=\"");
            lDIFRecord.toString(stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugLDIFRead(LDIFRecord lDIFRecord) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            Debug.debugLDIFRead(Level.INFO, lDIFRecord);
        }
    }

    public static void debugLDIFRead(Level level, LDIFRecord lDIFRecord) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.LDIF)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("readLDIFRecord=\"");
            lDIFRecord.toString(stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugMonitor(Entry entry, String string) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            Debug.debugMonitor(Level.FINE, entry, string);
        }
    }

    public static void debugMonitor(Level level, Entry entry, String string) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.MONITOR)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("monitorEntryDN=\"");
            stringBuilder.append(entry.getDN());
            stringBuilder.append("\" message=\"");
            stringBuilder.append(string);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debugCodingError(Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)DebugType.CODING_ERROR)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, Level.SEVERE);
            stringBuilder.append("codingError=\"");
            StaticUtils.getStackTrace(throwable, stringBuilder);
            stringBuilder.append('\"');
            logger.log(Level.SEVERE, stringBuilder.toString());
        }
    }

    public static void debug(Level level, DebugType debugType, String string) {
        if (debugEnabled && debugTypes.contains((Object)debugType)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("message=\"");
            stringBuilder.append(string);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString());
        }
    }

    public static void debug(Level level, DebugType debugType, String string, Throwable throwable) {
        if (debugEnabled && debugTypes.contains((Object)debugType)) {
            StringBuilder stringBuilder = new StringBuilder();
            Debug.addCommonHeader(stringBuilder, level);
            stringBuilder.append("message=\"");
            stringBuilder.append(string);
            stringBuilder.append('\"');
            stringBuilder.append(" exception=\"");
            StaticUtils.getStackTrace(throwable, stringBuilder);
            stringBuilder.append('\"');
            logger.log(level, stringBuilder.toString(), throwable);
        }
    }

    private static void addCommonHeader(StringBuilder stringBuilder, Level level) {
        stringBuilder.append("level=\"");
        stringBuilder.append(level.getName());
        stringBuilder.append("\" threadID=");
        stringBuilder.append(Thread.currentThread().getId());
        stringBuilder.append(" threadName=\"");
        stringBuilder.append(Thread.currentThread().getName());
        if (includeStackTrace) {
            stringBuilder.append("\" calledFrom=\"");
            boolean bl = false;
            boolean bl2 = false;
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                String string = stackTraceElement.getClassName();
                if (string.equals(Debug.class.getName())) {
                    bl2 = true;
                    continue;
                }
                if (!bl2) continue;
                if (bl) {
                    stringBuilder.append(" / ");
                }
                bl = true;
                stringBuilder.append(stackTraceElement.getMethodName());
                stringBuilder.append('(');
                stringBuilder.append(stackTraceElement.getFileName());
                int n = stackTraceElement.getLineNumber();
                if (n > 0) {
                    stringBuilder.append(':');
                    stringBuilder.append(n);
                } else if (stackTraceElement.isNativeMethod()) {
                    stringBuilder.append(":native");
                }
                stringBuilder.append(')');
            }
        }
        stringBuilder.append("\" revision=");
        stringBuilder.append(22058L);
        stringBuilder.append(' ');
    }

    static {
        Debug.initialize(System.getProperties());
    }
}

