/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.LDAPSDKRuntimeException;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticUtils {
    public static final byte[] NO_BYTES = new byte[0];
    public static final Control[] NO_CONTROLS = new Control[0];
    public static final String[] NO_STRINGS = new String[0];
    public static final String EOL = System.getProperty("line.separator");
    public static final byte[] EOL_BYTES = StaticUtils.getBytes(EOL);
    public static final int TERMINAL_WIDTH_COLUMNS;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTERS;
    private static volatile Set<String> TO_CODE_SENSITIVE_ATTRIBUTE_NAMES;

    private StaticUtils() {
    }

    public static byte[] getBytes(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                try {
                    return string.getBytes("UTF-8");
                }
                catch (Exception exception) {
                    Debug.debugException(exception);
                    return string.getBytes();
                }
            }
            byArray[i] = (byte)(c & 0x7F);
        }
        return byArray;
    }

    public static boolean isASCIIString(byte[] byArray) {
        for (byte by : byArray) {
            if ((by & 0x80) != 128) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrintableString(byte[] byArray) {
        block3: for (byte by : byArray) {
            if ((by & 0x80) == 128) {
                return false;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57) continue;
            switch (by) {
                case 32: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 61: 
                case 63: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String toUTF8String(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return new String(byArray);
        }
    }

    public static String toUTF8String(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF-8");
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            return new String(byArray, n, n2);
        }
    }

    public static String toInitialLowerCase(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return StaticUtils.toLowerCase(string);
        }
        char c = string.charAt(0);
        if (c >= 'A' && c <= 'Z' || c < ' ' || c > '~') {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, Character.toLowerCase(c));
            return stringBuilder.toString();
        }
        return string;
    }

    public static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        block28: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case 'A': {
                    cArray[i] = 97;
                    continue block28;
                }
                case 'B': {
                    cArray[i] = 98;
                    continue block28;
                }
                case 'C': {
                    cArray[i] = 99;
                    continue block28;
                }
                case 'D': {
                    cArray[i] = 100;
                    continue block28;
                }
                case 'E': {
                    cArray[i] = 101;
                    continue block28;
                }
                case 'F': {
                    cArray[i] = 102;
                    continue block28;
                }
                case 'G': {
                    cArray[i] = 103;
                    continue block28;
                }
                case 'H': {
                    cArray[i] = 104;
                    continue block28;
                }
                case 'I': {
                    cArray[i] = 105;
                    continue block28;
                }
                case 'J': {
                    cArray[i] = 106;
                    continue block28;
                }
                case 'K': {
                    cArray[i] = 107;
                    continue block28;
                }
                case 'L': {
                    cArray[i] = 108;
                    continue block28;
                }
                case 'M': {
                    cArray[i] = 109;
                    continue block28;
                }
                case 'N': {
                    cArray[i] = 110;
                    continue block28;
                }
                case 'O': {
                    cArray[i] = 111;
                    continue block28;
                }
                case 'P': {
                    cArray[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    cArray[i] = 113;
                    continue block28;
                }
                case 'R': {
                    cArray[i] = 114;
                    continue block28;
                }
                case 'S': {
                    cArray[i] = 115;
                    continue block28;
                }
                case 'T': {
                    cArray[i] = 116;
                    continue block28;
                }
                case 'U': {
                    cArray[i] = 117;
                    continue block28;
                }
                case 'V': {
                    cArray[i] = 118;
                    continue block28;
                }
                case 'W': {
                    cArray[i] = 119;
                    continue block28;
                }
                case 'X': {
                    cArray[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    cArray[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    cArray[i] = 122;
                    continue block28;
                }
                default: {
                    if (cArray[i] <= '\u007f') continue block28;
                    return string.toLowerCase();
                }
            }
        }
        return new String(cArray);
    }

    public static boolean isHex(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static String toHex(byte by) {
        StringBuilder stringBuilder = new StringBuilder(2);
        StaticUtils.toHex(by, stringBuilder);
        return stringBuilder.toString();
    }

    public static void toHex(byte by, StringBuilder stringBuilder) {
        switch (by & 0xF0) {
            case 0: {
                stringBuilder.append('0');
                break;
            }
            case 16: {
                stringBuilder.append('1');
                break;
            }
            case 32: {
                stringBuilder.append('2');
                break;
            }
            case 48: {
                stringBuilder.append('3');
                break;
            }
            case 64: {
                stringBuilder.append('4');
                break;
            }
            case 80: {
                stringBuilder.append('5');
                break;
            }
            case 96: {
                stringBuilder.append('6');
                break;
            }
            case 112: {
                stringBuilder.append('7');
                break;
            }
            case 128: {
                stringBuilder.append('8');
                break;
            }
            case 144: {
                stringBuilder.append('9');
                break;
            }
            case 160: {
                stringBuilder.append('a');
                break;
            }
            case 176: {
                stringBuilder.append('b');
                break;
            }
            case 192: {
                stringBuilder.append('c');
                break;
            }
            case 208: {
                stringBuilder.append('d');
                break;
            }
            case 224: {
                stringBuilder.append('e');
                break;
            }
            case 240: {
                stringBuilder.append('f');
            }
        }
        switch (by & 0xF) {
            case 0: {
                stringBuilder.append('0');
                break;
            }
            case 1: {
                stringBuilder.append('1');
                break;
            }
            case 2: {
                stringBuilder.append('2');
                break;
            }
            case 3: {
                stringBuilder.append('3');
                break;
            }
            case 4: {
                stringBuilder.append('4');
                break;
            }
            case 5: {
                stringBuilder.append('5');
                break;
            }
            case 6: {
                stringBuilder.append('6');
                break;
            }
            case 7: {
                stringBuilder.append('7');
                break;
            }
            case 8: {
                stringBuilder.append('8');
                break;
            }
            case 9: {
                stringBuilder.append('9');
                break;
            }
            case 10: {
                stringBuilder.append('a');
                break;
            }
            case 11: {
                stringBuilder.append('b');
                break;
            }
            case 12: {
                stringBuilder.append('c');
                break;
            }
            case 13: {
                stringBuilder.append('d');
                break;
            }
            case 14: {
                stringBuilder.append('e');
                break;
            }
            case 15: {
                stringBuilder.append('f');
            }
        }
    }

    public static String toHex(byte[] byArray) {
        Validator.ensureNotNull(byArray);
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        StaticUtils.toHex(byArray, stringBuilder);
        return stringBuilder.toString();
    }

    public static void toHex(byte[] byArray, StringBuilder stringBuilder) {
        StaticUtils.toHex(byArray, null, stringBuilder);
    }

    public static void toHex(byte[] byArray, String string, StringBuilder stringBuilder) {
        boolean bl = true;
        for (byte by : byArray) {
            if (bl) {
                bl = false;
            } else if (string != null) {
                stringBuilder.append(string);
            }
            StaticUtils.toHex(by, stringBuilder);
        }
    }

    public static String toHexPlusASCII(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.toHexPlusASCII(byArray, n, stringBuilder);
        return stringBuilder.toString();
    }

    public static void toHexPlusASCII(byte[] byArray, int n, StringBuilder stringBuilder) {
        int n2;
        int n3;
        if (byArray == null || byArray.length == 0) {
            return;
        }
        for (n3 = 0; n3 < n; ++n3) {
            stringBuilder.append(' ');
        }
        n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            StaticUtils.toHex(byArray[n3++], stringBuilder);
            stringBuilder.append(' ');
            if (n3 % 16 != 0) continue;
            stringBuilder.append("  ");
            for (n2 = n4; n2 < n3; ++n2) {
                if (byArray[n2] < 32 || byArray[n2] > 126) {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append((char)byArray[n2]);
            }
            stringBuilder.append(EOL);
            n4 = n3;
            if (n3 >= byArray.length) continue;
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(' ');
            }
        }
        if (byArray.length % 16 != 0 && (n2 = 16 - byArray.length % 16) > 0) {
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                stringBuilder.append("   ");
            }
            stringBuilder.append("  ");
            for (n5 = n4; n5 < byArray.length; ++n5) {
                if (byArray[n5] < 32 || byArray[n5] > 126) {
                    stringBuilder.append(' ');
                    continue;
                }
                stringBuilder.append((char)byArray[n5]);
            }
            stringBuilder.append(EOL);
        }
    }

    public static void hexEncode(char c, StringBuilder stringBuilder) {
        byte[] byArray = c <= '\u007f' ? new byte[]{(byte)(c & 0x7F)} : StaticUtils.getBytes(String.valueOf(c));
        for (byte by : byArray) {
            stringBuilder.append('\\');
            StaticUtils.toHex(by, stringBuilder);
        }
    }

    public static void byteArrayToCode(byte[] byArray, StringBuilder stringBuilder) {
        stringBuilder.append("new byte[] {");
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(" (byte) 0x");
            StaticUtils.toHex(byArray[i], stringBuilder);
        }
        stringBuilder.append(" }");
    }

    public static String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.getStackTrace(throwable, stringBuilder);
        return stringBuilder.toString();
    }

    public static void getStackTrace(Throwable throwable, StringBuilder stringBuilder) {
        stringBuilder.append(StaticUtils.getUnqualifiedClassName(throwable.getClass()));
        stringBuilder.append('(');
        String string = throwable.getMessage();
        if (string != null) {
            stringBuilder.append("message='");
            stringBuilder.append(string);
            stringBuilder.append("', ");
        }
        stringBuilder.append("trace='");
        StaticUtils.getStackTrace(throwable.getStackTrace(), stringBuilder);
        stringBuilder.append('\'');
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuilder.append(", cause=");
            StaticUtils.getStackTrace(throwable2, stringBuilder);
        }
        stringBuilder.append(", revision=");
        stringBuilder.append(22058L);
        stringBuilder.append(')');
    }

    public static String getStackTrace(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.getStackTrace(stackTraceElementArray, stringBuilder);
        return stringBuilder.toString();
    }

    public static void getStackTrace(StackTraceElement[] stackTraceElementArray, StringBuilder stringBuilder) {
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" / ");
            }
            stringBuilder.append(stackTraceElementArray[i].getMethodName());
            stringBuilder.append('(');
            stringBuilder.append(stackTraceElementArray[i].getFileName());
            int n = stackTraceElementArray[i].getLineNumber();
            if (n > 0) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
            stringBuilder.append(')');
        }
    }

    public static String getExceptionMessage(Throwable throwable) {
        if (throwable == null) {
            return UtilityMessages.ERR_NO_EXCEPTION.get();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (throwable instanceof LDAPSDKException) {
            stringBuilder.append(((LDAPSDKException)throwable).getExceptionMessage());
        } else if (throwable instanceof LDAPSDKRuntimeException) {
            stringBuilder.append(((LDAPSDKRuntimeException)throwable).getExceptionMessage());
        }
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return StaticUtils.getStackTrace(throwable);
        }
        stringBuilder.append(String.valueOf(throwable));
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuilder.append(" caused by ");
            stringBuilder.append(StaticUtils.getExceptionMessage(throwable2));
        }
        return stringBuilder.toString();
    }

    public static String getUnqualifiedClassName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String encodeGeneralizedTime(long l) {
        return StaticUtils.encodeGeneralizedTime(new Date(l));
    }

    public static String encodeGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMATTERS.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            DATE_FORMATTERS.set(simpleDateFormat);
        }
        return simpleDateFormat.format(date);
    }

    public static Date decodeGeneralizedTime(String string) throws ParseException {
        String string2;
        String string3;
        String string4;
        int n;
        TimeZone timeZone;
        Validator.ensureNotNull(string);
        if (string.endsWith("Z")) {
            timeZone = TimeZone.getTimeZone("UTC");
            n = string.length() - 1;
        } else {
            n = string.lastIndexOf(45);
            if (n < 0 && (n = string.lastIndexOf(43)) < 0) {
                throw new ParseException(UtilityMessages.ERR_GENTIME_DECODE_CANNOT_PARSE_TZ.get(string), 0);
            }
            timeZone = TimeZone.getTimeZone("GMT" + string.substring(n));
            if (timeZone.getRawOffset() == 0 && !string.endsWith("+0000") && !string.endsWith("-0000")) {
                throw new ParseException(UtilityMessages.ERR_GENTIME_DECODE_CANNOT_PARSE_TZ.get(string), n);
            }
        }
        int n2 = string.lastIndexOf(46, n);
        if (n2 > 0) {
            int n3 = n - n2 - 1;
            switch (n3) {
                case 0: {
                    string4 = "";
                    string3 = string.substring(0, n2);
                    break;
                }
                case 1: {
                    string4 = ".SSS";
                    string3 = string.substring(0, n2 + 2) + "00";
                    break;
                }
                case 2: {
                    string4 = ".SSS";
                    string3 = string.substring(0, n2 + 3) + '0';
                    break;
                }
                default: {
                    string4 = ".SSS";
                    string3 = string.substring(0, n2 + 4);
                    break;
                }
            }
        } else {
            string4 = "";
            n2 = n;
            string3 = string.substring(0, n);
        }
        switch (n2) {
            case 10: {
                string2 = "yyyyMMddHH" + string4;
                break;
            }
            case 12: {
                string2 = "yyyyMMddHHmm" + string4;
                break;
            }
            case 14: {
                string2 = "yyyyMMddHHmmss" + string4;
                break;
            }
            default: {
                throw new ParseException(UtilityMessages.ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH.get(string), n2);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.parse(string3);
    }

    public static String trimLeading(String string) {
        int n;
        Validator.ensureNotNull(string);
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        if (n == 0) {
            return string;
        }
        if (n >= n2) {
            return "";
        }
        return string.substring(n, n2);
    }

    public static String trimTrailing(String string) {
        int n;
        int n2;
        Validator.ensureNotNull(string);
        for (n2 = n = string.length() - 1; n2 >= 0 && string.charAt(n2) == ' '; --n2) {
        }
        if (n2 < 0) {
            return "";
        }
        if (n2 == n) {
            return string;
        }
        return string.substring(0, n2 + 1);
    }

    public static List<String> wrapLine(String string, int n) {
        return StaticUtils.wrapLine(string, n, n);
    }

    public static List<String> wrapLine(String string, int n, int n2) {
        ArrayList<String> arrayList;
        block9: {
            String string2;
            int n3;
            if (n > 0) {
                Validator.ensureTrue(n2 > 0);
            }
            if ((n3 = string.indexOf(10)) >= 0) {
                ArrayList<String> arrayList2 = new ArrayList<String>(10);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList2.addAll(StaticUtils.wrapLine(stringTokenizer.nextToken(), n, n2));
                }
                return arrayList2;
            }
            int n4 = string.length();
            if (n <= 0 || n4 < n) {
                return Arrays.asList(string);
            }
            int n5 = n;
            int n6 = 0;
            arrayList = new ArrayList<String>(5);
            do {
                int n7;
                if ((n7 = string.lastIndexOf(32, n5)) > n6) {
                    string2 = StaticUtils.trimTrailing(string.substring(n6, n7));
                    if (string2.length() > 0) {
                        arrayList.add(string2);
                    }
                    n5 = n7;
                } else {
                    arrayList.add(string.substring(n6, n5));
                }
                while (n5 < n4 && string.charAt(n5) == ' ') {
                    ++n5;
                }
                n6 = n5;
            } while ((n5 += n2) < n4);
            if (n6 >= n4 || (string2 = string.substring(n6)).length() <= 0) break block9;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String concatenateStrings(String ... stringArray) {
        return StaticUtils.concatenateStrings(null, null, "  ", null, null, stringArray);
    }

    public static String concatenateStrings(List<String> list) {
        return StaticUtils.concatenateStrings(null, null, "  ", null, null, list);
    }

    public static String concatenateStrings(String string, String string2, String string3, String string4, String string5, String ... stringArray) {
        return StaticUtils.concatenateStrings(string, string2, string3, string4, string5, Arrays.asList(stringArray));
    }

    public static String concatenateStrings(String string, String string2, String string3, String string4, String string5, List<String> list) {
        Validator.ensureNotNull(list);
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(iterator.next());
            if (string4 != null) {
                stringBuilder.append(string4);
            }
            if (string3 == null || !iterator.hasNext()) continue;
            stringBuilder.append(string3);
        }
        if (string5 != null) {
            stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    public static String secondsToHumanReadableDuration(long l) {
        return StaticUtils.millisToHumanReadableDuration(l * 1000L);
    }

    public static String millisToHumanReadableDuration(long l) {
        long l2;
        long l3;
        StringBuilder stringBuilder = new StringBuilder();
        long l4 = l;
        long l5 = l4 / 86400000L;
        if (l5 > 0L) {
            l4 -= l5 * 86400000L;
            if (l5 == 1L) {
                stringBuilder.append(UtilityMessages.INFO_NUM_DAYS_SINGULAR.get(l5));
            } else {
                stringBuilder.append(UtilityMessages.INFO_NUM_DAYS_PLURAL.get(l5));
            }
        }
        if ((l3 = l4 / 3600000L) > 0L) {
            l4 -= l3 * 3600000L;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            if (l3 == 1L) {
                stringBuilder.append(UtilityMessages.INFO_NUM_HOURS_SINGULAR.get(l3));
            } else {
                stringBuilder.append(UtilityMessages.INFO_NUM_HOURS_PLURAL.get(l3));
            }
        }
        if ((l2 = l4 / 60000L) > 0L) {
            l4 -= l2 * 60000L;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            if (l2 == 1L) {
                stringBuilder.append(UtilityMessages.INFO_NUM_MINUTES_SINGULAR.get(l2));
            } else {
                stringBuilder.append(UtilityMessages.INFO_NUM_MINUTES_PLURAL.get(l2));
            }
        }
        if (l4 == 1000L) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(UtilityMessages.INFO_NUM_SECONDS_SINGULAR.get(1));
        } else if (l4 > 0L || stringBuilder.length() == 0) {
            long l6;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            if ((l4 -= (l6 = l4 / 1000L) * 1000L) % 1000L != 0L) {
                double d = (double)l6 + (double)l4 / 1000.0;
                DecimalFormat decimalFormat = new DecimalFormat("0.000");
                stringBuilder.append(UtilityMessages.INFO_NUM_SECONDS_WITH_DECIMAL.get(decimalFormat.format(d)));
            } else {
                stringBuilder.append(UtilityMessages.INFO_NUM_SECONDS_PLURAL.get(l6));
            }
        }
        return stringBuilder.toString();
    }

    public static long nanosToMillis(long l) {
        return Math.max(0L, Math.round((double)l / 1000000.0));
    }

    public static long millisToNanos(long l) {
        return Math.max(0L, l * 1000000L);
    }

    public static boolean isNumericOID(String string) {
        boolean bl = true;
        boolean bl2 = false;
        block4: for (char c : string.toCharArray()) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    bl = false;
                    continue block4;
                }
                case '.': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    bl2 = true;
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return bl2 && !bl;
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        switch (string.length()) {
            case 0: {
                return string;
            }
            case 1: {
                return string.toUpperCase();
            }
        }
        char c = string.charAt(0);
        if (Character.isUpperCase(c)) {
            return string;
        }
        return Character.toUpperCase(c) + string.substring(1);
    }

    public static byte[] encodeUUID(UUID uUID) {
        byte[] byArray = new byte[16];
        long l = uUID.getMostSignificantBits();
        byArray[0] = (byte)(l >> 56 & 0xFFL);
        byArray[1] = (byte)(l >> 48 & 0xFFL);
        byArray[2] = (byte)(l >> 40 & 0xFFL);
        byArray[3] = (byte)(l >> 32 & 0xFFL);
        byArray[4] = (byte)(l >> 24 & 0xFFL);
        byArray[5] = (byte)(l >> 16 & 0xFFL);
        byArray[6] = (byte)(l >> 8 & 0xFFL);
        byArray[7] = (byte)(l & 0xFFL);
        long l2 = uUID.getLeastSignificantBits();
        byArray[8] = (byte)(l2 >> 56 & 0xFFL);
        byArray[9] = (byte)(l2 >> 48 & 0xFFL);
        byArray[10] = (byte)(l2 >> 40 & 0xFFL);
        byArray[11] = (byte)(l2 >> 32 & 0xFFL);
        byArray[12] = (byte)(l2 >> 24 & 0xFFL);
        byArray[13] = (byte)(l2 >> 16 & 0xFFL);
        byArray[14] = (byte)(l2 >> 8 & 0xFFL);
        byArray[15] = (byte)(l2 & 0xFFL);
        return byArray;
    }

    public static UUID decodeUUID(byte[] byArray) throws ParseException {
        if (byArray.length != 16) {
            throw new ParseException(UtilityMessages.ERR_DECODE_UUID_INVALID_LENGTH.get(StaticUtils.toHex(byArray)), 0);
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[i] & 0xFF);
        }
        long l2 = 0L;
        for (int i = 8; i < 16; ++i) {
            l2 = l2 << 8 | (long)(byArray[i] & 0xFF);
        }
        return new UUID(l, l2);
    }

    public static boolean isWindows() {
        String string = StaticUtils.toLowerCase(System.getProperty("os.name"));
        return string != null && string.contains("windows");
    }

    public static List<String> toArgumentList(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return Collections.emptyList();
        }
        int n = -1;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == '\"') {
                if (n >= 0) {
                    n = -1;
                    continue;
                }
                n = i;
                continue;
            }
            if (c == ' ') {
                if (n >= 0) {
                    stringBuilder.append(c);
                    continue;
                }
                if (stringBuilder.length() <= 0) continue;
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        if (string.endsWith("\\") && !string.endsWith("\\\\")) {
            throw new ParseException(UtilityMessages.ERR_ARG_STRING_DANGLING_BACKSLASH.get(), string.length() - 1);
        }
        if (n >= 0) {
            throw new ParseException(UtilityMessages.ERR_ARG_STRING_UNMATCHED_QUOTE.get(n), n);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <T> List<T> toList(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        arrayList.addAll(Arrays.asList(TArray));
        return arrayList;
    }

    public static <T> List<T> toNonNullList(T[] TArray) {
        if (TArray == null) {
            return new ArrayList(0);
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        arrayList.addAll(Arrays.asList(TArray));
        return arrayList;
    }

    public static boolean bothNullOrEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean bothNullOrEqualIgnoreCase(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean stringsEqualIgnoreCaseOrderIndependent(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        if (stringArray.length == 1) {
            return stringArray[0].equalsIgnoreCase(stringArray2[0]);
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            hashSet.add(StaticUtils.toLowerCase(string));
        }
        HashSet hashSet2 = new HashSet(stringArray2.length);
        for (String string : stringArray2) {
            hashSet2.add(StaticUtils.toLowerCase(string));
        }
        return hashSet.equals(hashSet2);
    }

    public static <T> boolean arraysEqualOrderIndependent(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return TArray2 == null;
        }
        if (TArray2 == null) {
            return false;
        }
        if (TArray.length != TArray2.length) {
            return false;
        }
        if (TArray.length == 1) {
            return TArray[0].equals(TArray2[0]);
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(TArray));
        HashSet<T> hashSet2 = new HashSet<T>(Arrays.asList(TArray2));
        return hashSet.equals(hashSet2);
    }

    public static int numBytesInUTF8CharacterWithFirstByte(byte by) {
        if ((by & 0x7F) == by) {
            return 1;
        }
        if ((by & 0xE0) == 192) {
            return 2;
        }
        if ((by & 0xF0) == 224) {
            return 3;
        }
        if ((by & 0xF8) == 240) {
            return 4;
        }
        return -1;
    }

    public static boolean isSensitiveToCodeAttribute(String string) {
        String string2 = Attribute.getBaseName(string).toLowerCase();
        return TO_CODE_SENSITIVE_ATTRIBUTE_NAMES.contains(string2);
    }

    public static Set<String> getSensitiveToCodeAttributeBaseNames() {
        return TO_CODE_SENSITIVE_ATTRIBUTE_NAMES;
    }

    public static void setSensitiveToCodeAttributes(String ... stringArray) {
        StaticUtils.setSensitiveToCodeAttributes(StaticUtils.toList(stringArray));
    }

    public static void setSensitiveToCodeAttributes(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            TO_CODE_SENSITIVE_ATTRIBUTE_NAMES = Collections.emptySet();
        } else {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(collection.size());
            for (String string : collection) {
                linkedHashSet.add(Attribute.getBaseName(string).toLowerCase());
            }
            TO_CODE_SENSITIVE_ATTRIBUTE_NAMES = Collections.unmodifiableSet(linkedHashSet);
        }
    }

    public static IOException createIOExceptionWithCause(String string, Throwable throwable) {
        if (throwable == null) {
            return new IOException(string);
        }
        try {
            if (string == null) {
                Constructor constructor = IOException.class.getConstructor(Throwable.class);
                return (IOException)constructor.newInstance(throwable);
            }
            Constructor constructor = IOException.class.getConstructor(String.class, Throwable.class);
            return (IOException)constructor.newInstance(string, throwable);
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            if (string == null) {
                return new IOException(StaticUtils.getExceptionMessage(throwable));
            }
            return new IOException(string + " (caused by " + StaticUtils.getExceptionMessage(throwable) + ')');
        }
    }

    static {
        int n = 80;
        String string = System.getenv("COLUMNS");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        TERMINAL_WIDTH_COLUMNS = n;
        DATE_FORMATTERS = new ThreadLocal();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(4);
        linkedHashSet.add("userpassword");
        linkedHashSet.add("2.5.4.35");
        linkedHashSet.add("authpassword");
        linkedHashSet.add("1.3.6.1.4.1.4203.1.3.4");
        TO_CODE_SENSITIVE_ATTRIBUTE_NAMES = Collections.unmodifiableSet(linkedHashSet);
    }
}

