/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.UtilityMessages;

public final class Validator {
    private Validator() {
    }

    public static void ensureNotNull(Object object) throws LDAPSDKUsageException {
        if (object == null) {
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(0, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureNotNullWithMessage(Object object, String string) throws LDAPSDKUsageException {
        if (object == null) {
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(string, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureNotNull(Object object, Object object2) throws LDAPSDKUsageException {
        if (object == null || object2 == null) {
            int n = object == null ? 0 : 1;
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(n, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureNotNull(Object object, Object object2, Object object3) throws LDAPSDKUsageException {
        if (object == null || object2 == null || object3 == null) {
            int n = object == null ? 0 : (object2 == null ? 1 : 2);
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(n, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureNotNull(Object object, Object object2, Object object3, Object object4) throws LDAPSDKUsageException {
        if (object == null || object2 == null || object3 == null || object4 == null) {
            int n = object == null ? 0 : (object2 == null ? 1 : (object3 == null ? 2 : 3));
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(n, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureNotNull(Object object, Object object2, Object object3, Object object4, Object object5) throws LDAPSDKUsageException {
        if (object == null || object2 == null || object3 == null || object4 == null || object5 == null) {
            int n = object == null ? 0 : (object2 == null ? 1 : (object3 == null ? 2 : (object4 == null ? 3 : 4)));
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(n, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureTrue(boolean bl) throws LDAPSDKUsageException {
        if (!bl) {
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_TRUE_CHECK_FAILURE.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureTrue(boolean bl, String string) throws LDAPSDKUsageException {
        if (!bl) {
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(string, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureFalse(boolean bl) throws LDAPSDKUsageException {
        if (bl) {
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FALSE_CHECK_FAILURE.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }

    public static void ensureFalse(boolean bl, String string) throws LDAPSDKUsageException {
        if (bl) {
            LDAPSDKUsageException lDAPSDKUsageException = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(string, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(lDAPSDKUsageException);
            throw lDAPSDKUsageException;
        }
    }
}

