/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class WakeableSleeper
implements Serializable {
    private static final long serialVersionUID = 755656862953269760L;
    private final AtomicBoolean sleeping = new AtomicBoolean(false);
    private final AtomicBoolean shutDown = new AtomicBoolean(false);
    private final AtomicLong wakeupCount = new AtomicLong(0L);

    public boolean isShutDown() {
        return this.shutDown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep(long l) {
        AtomicLong atomicLong = this.wakeupCount;
        synchronized (atomicLong) {
            boolean bl;
            if (this.isShutDown()) {
                return false;
            }
            Validator.ensureTrue(this.sleeping.compareAndSet(false, true), "WakeableSleeper.sleep() must not be invoked concurrently by multiple threads against the same instance.");
            try {
                long l2 = this.wakeupCount.get();
                this.wakeupCount.wait(l);
                long l3 = this.wakeupCount.get();
                bl = l2 == l3;
                this.sleeping.set(false);
            }
            catch (InterruptedException interruptedException) {
                boolean bl2;
                try {
                    Debug.debugException(interruptedException);
                    bl2 = false;
                    this.sleeping.set(false);
                }
                catch (Throwable throwable) {
                    this.sleeping.set(false);
                    throw throwable;
                }
                return bl2;
            }
            return bl;
        }
    }

    public void shutDown() {
        this.shutDown.set(true);
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        AtomicLong atomicLong = this.wakeupCount;
        synchronized (atomicLong) {
            this.wakeupCount.incrementAndGet();
            this.wakeupCount.notifyAll();
        }
    }
}

