/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.parallel;

import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Result;
import com.unboundid.util.parallel.ResultProcessor;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
public final class AsynchronousParallelProcessor<I, O> {
    private final BlockingQueue<I> pendingQueue;
    private final ParallelProcessor<I, O> parallelProcessor;
    private final ResultProcessor<I, O> resultProcessor;
    private final InvokerThread invokerThread;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicReference<Throwable> invocationException = new AtomicReference();

    public AsynchronousParallelProcessor(BlockingQueue<I> blockingQueue, ParallelProcessor<I, O> parallelProcessor, ResultProcessor<I, O> resultProcessor) {
        this.pendingQueue = blockingQueue;
        this.parallelProcessor = parallelProcessor;
        this.resultProcessor = resultProcessor;
        this.invokerThread = new InvokerThread();
        this.invokerThread.start();
    }

    public AsynchronousParallelProcessor(BlockingQueue<I> blockingQueue, ParallelProcessor<I, O> parallelProcessor, BlockingQueue<Result<I, O>> blockingQueue2) {
        this(blockingQueue, parallelProcessor, new OutputEnqueuer(blockingQueue2));
    }

    public synchronized void submit(I i) throws InterruptedException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("cannot call submit() after shutdown()");
        }
        Throwable throwable = this.invocationException.get();
        if (throwable != null) {
            this.shutdown();
            throw new RuntimeException(throwable);
        }
        this.pendingQueue.put(i);
    }

    public synchronized void shutdown() throws InterruptedException {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.invokerThread.join();
        this.parallelProcessor.shutdown();
    }

    private final class InvokerThread
    extends Thread {
        private InvokerThread() {
            super("Asynchronous Parallel Processor");
            this.setDaemon(true);
        }

        public void run() {
            while (!AsynchronousParallelProcessor.this.shutdown.get() || !AsynchronousParallelProcessor.this.pendingQueue.isEmpty()) {
                try {
                    Object e = AsynchronousParallelProcessor.this.pendingQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (e == null) continue;
                    ArrayList arrayList = new ArrayList(1 + AsynchronousParallelProcessor.this.pendingQueue.size());
                    arrayList.add(e);
                    AsynchronousParallelProcessor.this.pendingQueue.drainTo(arrayList);
                    ArrayList arrayList2 = AsynchronousParallelProcessor.this.parallelProcessor.processAll(arrayList);
                    for (Result result : arrayList2) {
                        AsynchronousParallelProcessor.this.resultProcessor.processResult(result);
                    }
                }
                catch (Throwable throwable) {
                    Debug.debugException(throwable);
                    AsynchronousParallelProcessor.this.invocationException.compareAndSet(null, throwable);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OutputEnqueuer<I, O>
    implements ResultProcessor<I, O> {
        private final BlockingQueue<Result<I, O>> outputQueue;

        private OutputEnqueuer(BlockingQueue<Result<I, O>> blockingQueue) {
            this.outputQueue = blockingQueue;
        }

        @Override
        public void processResult(Result<I, O> result) throws Exception {
            this.outputQueue.put(result);
        }
    }
}

