/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ssl.SSLMessages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.X509TrustManager;

public final class PromptTrustManager
implements X509TrustManager {
    private static final MessageDigest MD5;
    private static final MessageDigest SHA1;
    private final boolean examineValidityDates;
    private final ConcurrentHashMap<String, Boolean> acceptedCerts;
    private final InputStream in;
    private final PrintStream out;
    private final String acceptedCertsFile;

    public PromptTrustManager() {
        this(null, true, null, null);
    }

    public PromptTrustManager(String string) {
        this(string, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PromptTrustManager(String string, boolean bl, InputStream inputStream, PrintStream printStream) {
        this.acceptedCertsFile = string;
        this.examineValidityDates = bl;
        this.in = inputStream == null ? System.in : inputStream;
        this.out = printStream == null ? System.out : printStream;
        this.acceptedCerts = new ConcurrentHashMap();
        if (string == null) return;
        BufferedReader bufferedReader = null;
        File file = new File(string);
        if (file.exists()) {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.acceptedCerts.put(string2, false);
            }
        }
        Object var9_9 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
        return;
        {
            catch (Exception exception) {
                Debug.debugException(exception);
                Object var9_10 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (Exception exception2) {
                    Debug.debugException(exception2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCacheFile() throws IOException {
        Object object;
        Object object2;
        File file;
        block6: {
            file = new File(this.acceptedCertsFile + ".new");
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                object2 = this.acceptedCerts.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    bufferedWriter.write((String)object);
                    bufferedWriter.newLine();
                }
                Object var6_5 = null;
                if (bufferedWriter == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                throw throwable;
            }
            bufferedWriter.close();
        }
        if (((File)(object2 = new File(this.acceptedCertsFile))).exists()) {
            object = new File(this.acceptedCertsFile + ".previous");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            ((File)object2).renameTo((File)object);
        }
        file.renameTo((File)object2);
    }

    public synchronized boolean wouldPrompt(X509Certificate[] x509CertificateArray) {
        X509Certificate x509Certificate = x509CertificateArray[0];
        String string = StaticUtils.toLowerCase(StaticUtils.toHex(x509Certificate.getSignature()));
        Boolean bl = this.acceptedCerts.get(string);
        if (bl == null) {
            return true;
        }
        if (bl.booleanValue() || !this.examineValidityDates) {
            return false;
        }
        Date date = new Date();
        return !date.before(x509Certificate.getNotBefore()) && !date.after(x509Certificate.getNotAfter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkCertificateChain(X509Certificate[] x509CertificateArray, boolean bl) throws CertificateException {
        String string;
        Object object;
        String string2 = null;
        Date date = new Date();
        X509Certificate x509Certificate = x509CertificateArray[0];
        if (this.examineValidityDates) {
            if (date.before(x509Certificate.getNotBefore())) {
                string2 = SSLMessages.WARN_PROMPT_NOT_YET_VALID.get();
            } else if (date.after(x509Certificate.getNotAfter())) {
                string2 = SSLMessages.WARN_PROMPT_EXPIRED.get();
            }
        }
        if (!(this.examineValidityDates && string2 != null || (object = this.acceptedCerts.get(string = StaticUtils.toLowerCase(StaticUtils.toHex(x509Certificate.getSignature())))) == null)) {
            if (string2 == null) return;
            if (!this.examineValidityDates) return;
            if (Boolean.TRUE.equals(object)) {
                return;
            }
        }
        if (bl) {
            this.out.println(SSLMessages.INFO_PROMPT_SERVER_HEADING.get());
        } else {
            this.out.println(SSLMessages.INFO_PROMPT_CLIENT_HEADING.get());
        }
        this.out.println('\t' + SSLMessages.INFO_PROMPT_SUBJECT.get(x509Certificate.getSubjectX500Principal().getName("CANONICAL")));
        this.out.println("\t\t" + SSLMessages.INFO_PROMPT_MD5_FINGERPRINT.get(PromptTrustManager.getFingerprint(x509Certificate, MD5)));
        this.out.println("\t\t" + SSLMessages.INFO_PROMPT_SHA1_FINGERPRINT.get(PromptTrustManager.getFingerprint(x509Certificate, SHA1)));
        for (int i = 1; i < x509CertificateArray.length; ++i) {
            this.out.println('\t' + SSLMessages.INFO_PROMPT_ISSUER_SUBJECT.get(i, x509CertificateArray[i].getSubjectX500Principal().getName("CANONICAL")));
            this.out.println("\t\t" + SSLMessages.INFO_PROMPT_MD5_FINGERPRINT.get(PromptTrustManager.getFingerprint(x509CertificateArray[i], MD5)));
            this.out.println("\t\t" + SSLMessages.INFO_PROMPT_SHA1_FINGERPRINT.get(PromptTrustManager.getFingerprint(x509CertificateArray[i], SHA1)));
        }
        this.out.println(SSLMessages.INFO_PROMPT_VALIDITY.get(String.valueOf(x509Certificate.getNotBefore()), String.valueOf(x509Certificate.getNotAfter())));
        if (x509CertificateArray.length == 1) {
            this.out.println();
            this.out.println(SSLMessages.WARN_PROMPT_SELF_SIGNED.get());
        }
        if (string2 != null) {
            this.out.println();
            this.out.println(string2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        block6: while (true) {
            try {
                do {
                    this.out.println();
                    this.out.print(SSLMessages.INFO_PROMPT_MESSAGE.get());
                    this.out.flush();
                    object = bufferedReader.readLine();
                    if (object == null) {
                        throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_END_OF_STREAM.get());
                    }
                    if (((String)object).equalsIgnoreCase("y") || ((String)object).equalsIgnoreCase("yes")) break block6;
                    if (((String)object).equalsIgnoreCase("n")) throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get());
                } while (!((String)object).equalsIgnoreCase("no"));
                throw new CertificateException(SSLMessages.ERR_CERTIFICATE_REJECTED_BY_USER.get());
            }
            catch (CertificateException certificateException) {
                throw certificateException;
            }
            catch (Exception exception) {
                Debug.debugException(exception);
                continue;
            }
            break;
        }
        object = StaticUtils.toLowerCase(StaticUtils.toHex(x509Certificate.getSignature()));
        this.acceptedCerts.put((String)object, string2 != null);
        if (this.acceptedCertsFile == null) return;
        try {
            this.writeCacheFile();
            return;
        }
        catch (Exception exception) {
            Debug.debugException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFingerprint(X509Certificate x509Certificate, MessageDigest messageDigest) throws CertificateException {
        byte[] byArray;
        byte[] byArray2 = x509Certificate.getEncoded();
        Object object = messageDigest;
        synchronized (object) {
            byArray = messageDigest.digest(byArray2);
        }
        object = new StringBuilder(3 * byArray2.length);
        StaticUtils.toHex(byArray, ":", (StringBuilder)object);
        return ((StringBuilder)object).toString();
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkCertificateChain(x509CertificateArray, false);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkCertificateChain(x509CertificateArray, true);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    static {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new RuntimeException(exception);
        }
        MD5 = messageDigest;
        messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            Debug.debugException(exception);
            throw new RuntimeException(exception);
        }
        SHA1 = messageDigest;
    }
}

