/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum SSLMessages {
    ERR_CERTIFICATE_REJECTED_BY_END_OF_STREAM("The certificate cannot be trusted because the end of the standard input stream was reached without finding information about whether to trust the presented certificate."),
    ERR_CERTIFICATE_REJECTED_BY_USER("The user rejected the provided certificate."),
    ERR_KEYSTORE_CANNOT_GET_KEY_MANAGERS("Unable to obtain key managers for key store file ''{0}'' using format ''{1}'':  {2}"),
    ERR_KEYSTORE_CANNOT_LOAD("Unable to load key store ''{0}'' of type ''{1}'':  {2}"),
    ERR_KEYSTORE_NO_SUCH_FILE("Key store file ''{0}'' does not exist."),
    ERR_NO_ENABLED_SSL_PROTOCOLS_AVAILABLE_FOR_SOCKET("None of the configured set of enabled SSL protocols could be configured for use with the SSL socket.  The currently-enabled protocols are:  {0}.  The SSL socket indicated its supported protocols are:  {1}.  You may explicitly configure the enabled protocols using the {2} system property or by calling the {3} method."),
    ERR_PKCS11_CANNOT_ACCESS("Unable to access the PKCS#11 key store:  {0}"),
    ERR_PKCS11_CANNOT_GET_KEY_MANAGERS("Unable to obtain key managers for the PKCS#11 key store:  {0}"),
    ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_INPUT("The shutdownInput method is not supported for SSL sockets."),
    ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_OUTPUT("The shutdownOutput method is not supported for SSL sockets."),
    ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED("Sending urgent data is not supported for SSL sockets."),
    ERR_TRUSTSTORE_CANNOT_GET_TRUST_MANAGERS("Unable to obtain trust managers for trust store file ''{0}'' using format ''{1}'':  {2}"),
    ERR_TRUSTSTORE_CANNOT_LOAD("Unable to load trust store ''{0}'' of type ''{1}'':  {2}"),
    ERR_TRUSTSTORE_NO_SUCH_FILE("Trust store file ''{0}'' does not exist."),
    ERR_TRUSTSTORE_UNSUPPORTED_FORMAT("Unsupported trust store format ''{0}''."),
    INFO_PROMPT_CLIENT_HEADING("The client presented the following certificate:"),
    INFO_PROMPT_ISSUER_SUBJECT("Issuer[{0,number,0}] Subject:  {1}"),
    INFO_PROMPT_MD5_FINGERPRINT("MD5 Fingerprint:  {0}"),
    INFO_PROMPT_MESSAGE("Do you wish to trust this certificate?  Enter 'y' or 'n': "),
    INFO_PROMPT_SERVER_HEADING("The server presented the following certificate:"),
    INFO_PROMPT_SHA1_FINGERPRINT("SHA-1 Fingerprint:  {0}"),
    INFO_PROMPT_SUBJECT("Subject:  {0}"),
    INFO_PROMPT_VALIDITY("The certificate is valid from {0} to {1}."),
    WARN_PROMPT_EXPIRED("WARNING:  This certificate is expired."),
    WARN_PROMPT_NOT_YET_VALID("WARNING:  The current time is before the certificate validity start date."),
    WARN_PROMPT_SELF_SIGNED("WARNING:  The certificate is self-signed.");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<SSLMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<SSLMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private SSLMessages(String string2) {
        this.defaultText = string2;
    }

    public String get() {
        String string = MESSAGE_STRINGS.get((Object)this);
        if (string == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            try {
                string = RESOURCE_BUNDLE.getString(this.name());
            }
            catch (Exception exception) {
                string = this.defaultText;
            }
            MESSAGE_STRINGS.putIfAbsent(this, string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... objectArray) {
        MessageFormat messageFormat = MESSAGES.get((Object)this);
        if (messageFormat == null) {
            if (RESOURCE_BUNDLE == null) {
                messageFormat = new MessageFormat(this.defaultText);
            } else {
                try {
                    messageFormat = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception exception) {
                    messageFormat = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, messageFormat);
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(objectArray);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("unboundid-ldapsdk-ssl");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = resourceBundle;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

