/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SetEnabledProtocolsSSLSocketFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSLUtil {
    public static final String PROPERTY_DEFAULT_SSL_PROTOCOL = "com.unboundid.util.SSLUtil.defaultSSLProtocol";
    public static final String PROPERTY_ENABLED_SSL_PROTOCOLS = "com.unboundid.util.SSLUtil.enabledSSLProtocols";
    private static final AtomicReference<String> DEFAULT_SSL_PROTOCOL = new AtomicReference<String>("TLSv1");
    private static final AtomicReference<Set<String>> ENABLED_SSL_PROTOCOLS = new AtomicReference();
    private final KeyManager[] keyManagers;
    private final TrustManager[] trustManagers;

    public SSLUtil() {
        this.keyManagers = null;
        this.trustManagers = null;
    }

    public SSLUtil(TrustManager trustManager) {
        this.keyManagers = null;
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(TrustManager[] trustManagerArray) {
        this.keyManagers = null;
        this.trustManagers = trustManagerArray == null || trustManagerArray.length == 0 ? null : trustManagerArray;
    }

    public SSLUtil(KeyManager keyManager, TrustManager trustManager) {
        this.keyManagers = keyManager == null ? null : new KeyManager[]{keyManager};
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray) {
        this.keyManagers = keyManagerArray == null || keyManagerArray.length == 0 ? null : keyManagerArray;
        this.trustManagers = trustManagerArray == null || trustManagerArray.length == 0 ? null : trustManagerArray;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException {
        return this.createSSLContext(DEFAULT_SSL_PROTOCOL.get());
    }

    public SSLContext createSSLContext(String string) throws GeneralSecurityException {
        Validator.ensureNotNull(string);
        SSLContext sSLContext = SSLContext.getInstance(string);
        sSLContext.init(this.keyManagers, this.trustManagers, null);
        return sSLContext;
    }

    public SSLContext createSSLContext(String string, String string2) throws GeneralSecurityException {
        Validator.ensureNotNull(string, string2);
        SSLContext sSLContext = SSLContext.getInstance(string, string2);
        sSLContext.init(this.keyManagers, this.trustManagers, null);
        return sSLContext;
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException {
        return new SetEnabledProtocolsSSLSocketFactory(this.createSSLContext().getSocketFactory(), ENABLED_SSL_PROTOCOLS.get());
    }

    public SSLSocketFactory createSSLSocketFactory(String string) throws GeneralSecurityException {
        return new SetEnabledProtocolsSSLSocketFactory(this.createSSLContext(string).getSocketFactory(), string);
    }

    public SSLSocketFactory createSSLSocketFactory(String string, String string2) throws GeneralSecurityException {
        return this.createSSLContext(string, string2).getSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException {
        return this.createSSLContext().getServerSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory(String string) throws GeneralSecurityException {
        return this.createSSLContext(string).getServerSocketFactory();
    }

    public SSLServerSocketFactory createSSLServerSocketFactory(String string, String string2) throws GeneralSecurityException {
        return this.createSSLContext(string, string2).getServerSocketFactory();
    }

    public static String getDefaultSSLProtocol() {
        return DEFAULT_SSL_PROTOCOL.get();
    }

    public static void setDefaultSSLProtocol(String string) {
        Validator.ensureNotNull(string);
        DEFAULT_SSL_PROTOCOL.set(string);
    }

    public static Set<String> getEnabledSSLProtocols() {
        return ENABLED_SSL_PROTOCOLS.get();
    }

    public static void setEnabledSSLProtocols(Collection<String> collection) {
        if (collection == null) {
            ENABLED_SSL_PROTOCOLS.set(Collections.emptySet());
        } else {
            ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(new HashSet<String>(collection)));
        }
    }

    public static void applyEnabledSSLProtocols(Socket socket) throws LDAPException {
        try {
            SSLUtil.applyEnabledSSLProtocols(socket, ENABLED_SSL_PROTOCOLS.get());
        }
        catch (IOException iOException) {
            Debug.debugException(iOException);
            throw new LDAPException(ResultCode.CONNECT_ERROR, iOException.getMessage(), iOException);
        }
    }

    static void applyEnabledSSLProtocols(Socket socket, Set<String> set) throws IOException {
        Object object;
        if (socket == null || !(socket instanceof SSLSocket) || set.isEmpty()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String stringArray2 : set) {
            hashSet.add(StaticUtils.toLowerCase(stringArray2));
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        String[] stringArray = sSLSocket.getSupportedProtocols();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String i : stringArray) {
            if (!hashSet.contains(StaticUtils.toLowerCase(i))) continue;
            arrayList.add(i);
        }
        if (arrayList.isEmpty()) {
            object = new StringBuilder();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)object).append('\'');
                ((StringBuilder)object).append(iterator.next());
                ((StringBuilder)object).append('\'');
                if (!iterator.hasNext()) continue;
                ((StringBuilder)object).append(", ");
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\'');
                stringBuilder.append(stringArray[i]);
                stringBuilder.append('\'');
            }
            throw new IOException(SSLMessages.ERR_NO_ENABLED_SSL_PROTOCOLS_AVAILABLE_FOR_SOCKET.get(((StringBuilder)object).toString(), stringBuilder.toString(), PROPERTY_ENABLED_SSL_PROTOCOLS, SSLUtil.class.getName() + ".setEnabledSSLProtocols"));
        }
        object = new String[arrayList.size()];
        sSLSocket.setEnabledProtocols(arrayList.toArray((T[])object));
    }

    static void configureSSLDefaults() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = System.getProperty(PROPERTY_DEFAULT_SSL_PROTOCOL);
        if (string != null && string.length() > 0) {
            DEFAULT_SSL_PROTOCOL.set(string);
        } else {
            try {
                object4 = SSLContext.class.getMethod("getDefault", new Class[0]);
                object3 = (SSLContext)((Method)object4).invoke(null, new Object[0]);
                object2 = SSLContext.class.getMethod("getSupportedSSLParameters", new Class[0]);
                object = ((Method)object2).invoke(object3, new Object[0]);
                Class<?> clazz = Class.forName("javax.net.ssl.SSLParameters");
                Method method = clazz.getMethod("getProtocols", new Class[0]);
                String[] stringArray = (String[])method.invoke(object, new Object[0]);
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
                if (hashSet.contains("TLSv1.2")) {
                    DEFAULT_SSL_PROTOCOL.set("TLSv1.2");
                } else if (hashSet.contains("TLSv1.1")) {
                    DEFAULT_SSL_PROTOCOL.set("TLSv1.1");
                } else if (hashSet.contains("TLSv1")) {
                    DEFAULT_SSL_PROTOCOL.set("TLSv1");
                }
            }
            catch (Exception exception) {
                Debug.debugException(exception);
            }
        }
        object4 = new HashSet(10);
        ((HashSet)object4).add("TLSv1");
        if (DEFAULT_SSL_PROTOCOL.get().equals("TLSv1.2")) {
            ((HashSet)object4).add("TLSv1.1");
            ((HashSet)object4).add("TLSv1.2");
        } else if (DEFAULT_SSL_PROTOCOL.get().equals("TLSv1.1")) {
            ((HashSet)object4).add("TLSv1.1");
        }
        object3 = System.getProperty(PROPERTY_ENABLED_SSL_PROTOCOLS);
        if (object3 != null && ((String)object3).length() > 0) {
            ((HashSet)object4).clear();
            object2 = new StringTokenizer((String)object3, ", ", false);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (((String)object).length() <= 0) continue;
                ((HashSet)object4).add(object);
            }
        }
        ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(object4));
    }

    static {
        SSLUtil.configureSSLDefaults();
    }
}

