/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
final class SetEnabledProtocolsSocket
extends SSLSocket {
    private final Set<String> protocols;
    private final SSLSocket delegateSocket;

    SetEnabledProtocolsSocket(Socket socket, Set<String> set) {
        Validator.ensureTrue(socket instanceof SSLSocket);
        Validator.ensureFalse(socket.isConnected());
        this.delegateSocket = (SSLSocket)socket;
        this.protocols = set;
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        this.delegateSocket.connect(socketAddress, n);
        SSLUtil.applyEnabledSSLProtocols(this.delegateSocket, this.protocols);
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        this.delegateSocket.bind(socketAddress);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegateSocket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegateSocket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.delegateSocket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.delegateSocket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegateSocket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegateSocket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.delegateSocket.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.delegateSocket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegateSocket.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.delegateSocket.setTcpNoDelay(bl);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.delegateSocket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.delegateSocket.setSoLinger(bl, n);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.delegateSocket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int n) throws IOException {
        throw new SocketException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED.get());
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        throw new SocketException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED.get());
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        throw new SocketException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_URGENT_DATA_NOT_SUPPORTED.get());
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        this.delegateSocket.setSoTimeout(n);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.delegateSocket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        this.delegateSocket.setSendBufferSize(n);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.delegateSocket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        this.delegateSocket.setReceiveBufferSize(n);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.delegateSocket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.delegateSocket.setKeepAlive(bl);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.delegateSocket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.delegateSocket.setTrafficClass(n);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegateSocket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.delegateSocket.setReuseAddress(bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegateSocket.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.delegateSocket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_INPUT.get());
    }

    @Override
    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException(SSLMessages.ERR_SET_ENABLED_PROTOCOLS_SOCKET_SHUTDOWN_OUTPUT.get());
    }

    @Override
    public boolean isConnected() {
        return this.delegateSocket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.delegateSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegateSocket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.delegateSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.delegateSocket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int n, int n2, int n3) {
        this.delegateSocket.setPerformancePreferences(n, n2, n3);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegateSocket.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.delegateSocket.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] stringArray) {
        this.delegateSocket.setEnabledCipherSuites(stringArray);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.delegateSocket.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.delegateSocket.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] stringArray) {
        this.delegateSocket.setEnabledProtocols(stringArray);
    }

    @Override
    public SSLSession getSession() {
        return this.delegateSocket.getSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.delegateSocket.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.delegateSocket.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.delegateSocket.startHandshake();
    }

    @Override
    public void setUseClientMode(boolean bl) {
        this.delegateSocket.setUseClientMode(bl);
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegateSocket.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.delegateSocket.setNeedClientAuth(bl);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegateSocket.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.delegateSocket.setWantClientAuth(bl);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegateSocket.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        this.delegateSocket.setEnableSessionCreation(bl);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegateSocket.getEnableSessionCreation();
    }

    @Override
    public String toString() {
        return this.delegateSocket.toString();
    }
}

