/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class TrustStoreTrustManager
implements X509TrustManager,
Serializable {
    private static final long serialVersionUID = -4093869102727719415L;
    private final boolean examineValidityDates;
    private final char[] trustStorePIN;
    private final String trustStoreFile;
    private final String trustStoreFormat;

    public TrustStoreTrustManager(File file) {
        this(file.getAbsolutePath(), null, null, true);
    }

    public TrustStoreTrustManager(String string) {
        this(string, null, null, true);
    }

    public TrustStoreTrustManager(File file, char[] cArray, String string, boolean bl) {
        this(file.getAbsolutePath(), cArray, string, bl);
    }

    public TrustStoreTrustManager(String string, char[] cArray, String string2, boolean bl) {
        Validator.ensureNotNull(string);
        this.trustStoreFile = string;
        this.trustStorePIN = cArray;
        this.examineValidityDates = bl;
        this.trustStoreFormat = string2 == null ? KeyStore.getDefaultType() : string2;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private synchronized X509TrustManager[] getTrustManagers(X509Certificate[] var1_1) throws CertificateException {
        block17: {
            if (this.examineValidityDates) {
                var2_2 = new Date();
                for (TrustManager[] var6_11 : var1_1) {
                    var6_11.checkValidity((Date)var2_2);
                }
            }
            if (!(var2_2 = new File(this.trustStoreFile)).exists()) {
                throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_NO_SUCH_FILE.get(new Object[]{this.trustStoreFile}));
            }
            try {
                var3_3 = KeyStore.getInstance(this.trustStoreFormat);
            }
            catch (Exception var4_5) {
                Debug.debugException(var4_5);
                throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_UNSUPPORTED_FORMAT.get(new Object[]{this.trustStoreFormat}), var4_5);
            }
            var4_6 = null;
            try {
                var4_6 = new FileInputStream((File)var2_2);
                var3_3.load(var4_6, this.trustStorePIN);
                var8_12 = null;
                ** if (var4_6 == null) goto lbl-1000
            }
            catch (Throwable var7_17) {
                var8_13 = null;
                if (var4_6 != null) {
                    try {
                        var4_6.close();
                    }
                    catch (Exception var9_16) {
                        Debug.debugException(var9_16);
                    }
                }
                throw var7_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var4_6.close();
                }
                catch (Exception var9_15) {
                    Debug.debugException(var9_15);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (Exception var5_8) {
                    Debug.debugException(var5_8);
                    throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_CANNOT_LOAD.get(new Object[]{this.trustStoreFile, this.trustStoreFormat, String.valueOf(var5_8)}), var5_8);
                }
            }
        }
        try {
            var5_9 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            var5_9.init(var3_3);
            var6_11 = var5_9.getTrustManagers();
            var7_18 = new X509TrustManager[var6_11.length];
            for (var8_14 = 0; var8_14 < var6_11.length; ++var8_14) {
                var7_18[var8_14] = (X509TrustManager)var6_11[var8_14];
            }
            return var7_18;
        }
        catch (Exception var5_10) {
            Debug.debugException(var5_10);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_CANNOT_GET_TRUST_MANAGERS.get(new Object[]{this.trustStoreFile, this.trustStoreFormat, String.valueOf(var5_10)}), var5_10);
        }
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509TrustManager x509TrustManager : this.getTrustManagers(x509CertificateArray)) {
            x509TrustManager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509TrustManager x509TrustManager : this.getTrustManagers(x509CertificateArray)) {
            x509TrustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }

    public synchronized X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

